/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.bus;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openinstaller.bus.BusEvent;
import org.openinstaller.bus.BusException;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.NoSuchMemberException;
import org.openinstaller.bus.ServiceProvider;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Msg;
import org.openinstaller.util.logging.LogUtils;

public final class ControlBus {
    private boolean gShutdownFlag = false;
    private final Collection<ServiceProvider> gMembers;
    private static Object instanceLock = new Object();
    private static ControlBus instance = null;
    private final List<ServiceProvider> gInitList = new Vector<ServiceProvider>();
    private final Map<String, Thread> gInitThreads = new HashMap<String, Thread>();
    private final Object gMemberLock = new Object();
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private static final long INIT_WAIT_TIME = 90000L;

    private ControlBus() {
        this.gMembers = new Vector<ServiceProvider>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ControlBus getInstance() {
        Object object = instanceLock;
        synchronized (object) {
            if (instance == null) {
                instance = new ControlBus();
            }
        }
        return instance;
    }

    public String getName() {
        return "svc://general/bus";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitializing(String aName) {
        Object object = this.gMemberLock;
        synchronized (object) {
            for (ServiceProvider theProvider : this.gInitList) {
                if (!theProvider.getName().equals(aName)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitComplete() {
        Object object = this.gMemberLock;
        synchronized (object) {
            return this.gInitList.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(final ServiceProvider aProvider) throws BusException {
        Object object = this.gMemberLock;
        synchronized (object) {
            if (this.gShutdownFlag) {
                throw new BusException("shutdown in progress.  Cannot register provider", "provider=" + aProvider.getName());
            }
        }
        Thread theInitThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean theInitSuccessFlag = false;
                try {
                    aProvider.init(ControlBus.this);
                    theInitSuccessFlag = true;
                }
                catch (RuntimeException theRuntimeException) {
                    LogUtils.log(LOGGER, Level.WARNING, "PROVIDER_FAILED_INITIALIZATION", theRuntimeException, "error=" + EnhancedException.getLastCause(theRuntimeException).getLocalizedMessage(), "provider=" + aProvider.getName());
                    LOGGER.log(Level.WARNING, "PROVIDER_FAILED_INITIALIZATION", new String[]{"provider=" + aProvider.getName(), "error=" + EnhancedException.getLastCause(theRuntimeException).getLocalizedMessage()});
                    try {
                        ControlBus.this.publishEvent(new BusEvent("shutdown"));
                    }
                    catch (InvalidArgumentException theEIAEx) {
                        LOGGER.log(Level.WARNING, "ILLEGAL_EVENT", theEIAEx);
                    }
                }
                catch (Exception theEx) {
                    LogUtils.log(LOGGER, Level.WARNING, "PROVIDER_FAILED_INITIALIZATION", theEx, "error=" + EnhancedException.getLastCause(theEx).getLocalizedMessage(), "provider=" + aProvider.getName());
                }
                Object object = ControlBus.this.gMemberLock;
                synchronized (object) {
                    ControlBus.this.gInitList.remove(aProvider);
                    ControlBus.this.gInitThreads.remove(aProvider.getName());
                    if (theInitSuccessFlag) {
                        ControlBus.this.gMembers.add(aProvider);
                    }
                }
                LOGGER.log(Level.FINE, "completed initializing provider " + aProvider.getName());
            }
        });
        theInitThread.setName("Initializer for " + aProvider.getName());
        Object object2 = this.gMemberLock;
        synchronized (object2) {
            this.gInitList.add(aProvider);
            this.gInitThreads.put(aProvider.getName(), theInitThread);
        }
        theInitThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ServiceProvider aProvider) throws BusException {
        Object object = this.gMemberLock;
        synchronized (object) {
            if (!this.gMembers.contains(aProvider)) {
                throw new NoSuchMemberException(Msg.get(ControlBus.class, "NO_BUS_MEMBER", aProvider.getName(), this.getName()));
            }
            aProvider.shutdown();
            this.gMembers.remove(aProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAll() {
        Object object = this.gMemberLock;
        synchronized (object) {
            this.gMembers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishEvent(final BusEvent aEvent) {
        Object object = this.gMemberLock;
        synchronized (object) {
            Iterator<ServiceProvider> i$ = this.gMembers.iterator();
            while (i$.hasNext()) {
                ServiceProvider theMember;
                final ServiceProvider theNEXTMEMBER = theMember = i$.next();
                Thread theHandler = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        theNEXTMEMBER.receiveEvent(ControlBus.this, aEvent);
                    }
                });
                theHandler.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusResponse publishRequest(BusRequest aReq, String aRecipient) throws NoSuchMemberException {
        if (this.isInitializing(aRecipient)) {
            Thread theInitThread;
            Object object = this.gMemberLock;
            synchronized (object) {
                theInitThread = this.gInitThreads.get(aRecipient);
            }
            if (theInitThread != null) {
                try {
                    LOGGER.log(Level.FINE, "Provider [ " + aRecipient + "] is initializing, request [" + aReq + "] pending...");
                    theInitThread.join(90000L);
                    LOGGER.log(Level.FINE, "Provider [ " + aRecipient + "] is DONE initializing, request [" + aReq + "] continuing...");
                }
                catch (InterruptedException theEx) {
                    LOGGER.log(Level.INFO, "Provider " + aRecipient + " interrupted during initialization");
                }
            }
        }
        ServiceProvider theRecip = null;
        Object object = this.gMemberLock;
        synchronized (object) {
            Iterator<ServiceProvider> theMembers = this.gMembers.iterator();
            Pattern thePattern = Pattern.compile(aRecipient);
            while (theMembers.hasNext()) {
                ServiceProvider theNextMember = theMembers.next();
                Matcher theMatcher = thePattern.matcher(theNextMember.getName());
                if (!theMatcher.matches()) continue;
                theRecip = theNextMember;
            }
        }
        if (theRecip == null) {
            throw new NoSuchMemberException(aRecipient + " does not match any registered providers");
        }
        LOGGER.finest("BusRequest For: [" + theRecip.getName() + "] Request: [" + aReq.toString() + "] By: [" + ClassUtils.getFQCallingMethodName() + "(*)");
        BusResponse theResp = new BusResponse();
        theRecip.receiveRequest(this, aReq, theResp);
        return theResp;
    }

    public BusResponse publishRequestNoWait(BusRequest aReq, String aRecipient) throws NoSuchMemberException {
        return this.publishRequestNoWait(aReq, new BusResponse(), aRecipient);
    }

    public BusResponse publishRequestNoWait(final BusRequest aReq, final BusResponse aReUseThisResponse, String aRecipient) throws NoSuchMemberException {
        Iterator<ServiceProvider> theMembers = this.gMembers.iterator();
        Pattern thePattern = Pattern.compile(aRecipient);
        while (theMembers.hasNext()) {
            final ServiceProvider theNEXTMEMBER = theMembers.next();
            Matcher theMatcher = thePattern.matcher(theNEXTMEMBER.getName());
            if (theMatcher.matches()) {
                Thread theHandler = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        theNEXTMEMBER.receiveRequest(ControlBus.this, aReq, aReUseThisResponse);
                    }
                });
                theHandler.start();
                return aReUseThisResponse;
            }
            LOGGER.log(Level.FINER, "SKIPPING_NON_MATCHING_MEMBER", new String[]{theNEXTMEMBER.getName(), aRecipient});
        }
        throw new NoSuchMemberException(aRecipient + " does not match any registered providers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.gMemberLock;
        synchronized (object) {
            this.gShutdownFlag = true;
            for (ServiceProvider theNextMember : this.gMembers) {
                try {
                    theNextMember.shutdown();
                }
                catch (BusException theEx) {
                    LOGGER.log(Level.WARNING, "Could not properly shut down provider", new String[]{"provider=" + theNextMember.getName()});
                }
            }
        }
        this.unregisterAll();
        this.gShutdownFlag = false;
    }
}

