/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ExecuteCommand;
import org.openinstaller.util.Msg;
import org.openinstaller.util.Platform;

public final class BrowserLauncher {
    private static final Map<URL, JFrame> theDisplayedWindows = Collections.synchronizedMap(new HashMap());
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    private BrowserLauncher() {
    }

    public static void openURL(URL aURL, boolean aInternalFlag) throws EnhancedException {
        String theURL = aURL.toString();
        if (aInternalFlag) {
            BrowserLauncher.showJavaBrowser(aURL);
            return;
        }
        block1 : switch (Platform.getCurrentOsType()) {
            case UNIX: {
                String[] theCommand;
                if ((Platform.getCurrentOsName() == Platform.OSName.MACOS || Platform.getCurrentOsName() == Platform.OSName.MACOSX) && BrowserLauncher.executeCommand(theCommand = new String[]{"open", theURL}, true) != 0) {
                    BrowserLauncher.showJavaBrowser(aURL);
                }
                if (Platform.getCurrentOsName() == Platform.OSName.SOLARIS) {
                    theCommand = new String[]{"/usr/dt/bin/sdtwebclient", theURL};
                    if (BrowserLauncher.executeCommand(theCommand, false) == 0) {
                        return;
                    }
                    LOGGER.log(Level.FINE, "sdtwebclient could not find any web browser in PATH");
                }
                DesktopType theDesktopEnvironment = BrowserLauncher.detectDesktopEnvironment();
                switch (theDesktopEnvironment) {
                    case GNOME: {
                        theCommand = new String[]{"gnome-open", theURL};
                        if (BrowserLauncher.executeCommand(theCommand, true) == 0) break block1;
                        BrowserLauncher.showJavaBrowser(aURL);
                        break;
                    }
                    case KDE: {
                        theCommand = new String[]{"kfmclient exec", theURL};
                        if (BrowserLauncher.executeCommand(theCommand, true) == 0) break block1;
                        BrowserLauncher.showJavaBrowser(aURL);
                        break;
                    }
                    case CDE: {
                        try {
                            File theTmp = File.createTempFile("browsercommand", null);
                            FileWriter theFW = new FileWriter(theTmp);
                            theFW.write(theURL + "\n");
                            theFW.close();
                            theCommand = new String[]{"/usr/dt/bin/dtaction", "Browse", theTmp.getAbsolutePath()};
                            if (BrowserLauncher.executeCommand(theCommand, true) != 0) {
                                BrowserLauncher.showJavaBrowser(aURL);
                            }
                            theTmp.delete();
                            break;
                        }
                        catch (IOException theEx) {
                            LOGGER.log(Level.FINE, "Error writing to temporary file.");
                            throw new EnhancedException("BROWSER_NOT_SUPPORTED", (Throwable)theEx, new String[0]);
                        }
                    }
                    default: {
                        BrowserLauncher.showJavaBrowser(aURL);
                        break;
                    }
                }
                break;
            }
            case WINDOWS: {
                String[] theCommand = new String[]{"cmd.exe", "/c", "start", "\"\"", theURL};
                if (BrowserLauncher.executeCommand(theCommand, true) == 0 || BrowserLauncher.executeCommand(theCommand = new String[]{"command.exe", "/c", "start", "\"\"", theURL}, true) == 0) break;
                throw new EnhancedException("BROWSER_NOT_SUPPORTED", new String[0]);
            }
            default: {
                throw new EnhancedException("UNSUPPORTED_PLATFORM", "platform=" + (Object)((Object)Platform.getCurrentOsName()));
            }
        }
    }

    private static DesktopType detectDesktopEnvironment() throws EnhancedException {
        if ("Default".equalsIgnoreCase(System.getenv("GNOME_DESKTOP_SESSION_ID"))) {
            return DesktopType.GNOME;
        }
        if ("true".equalsIgnoreCase(System.getenv("KDE_FULL_SESSION"))) {
            return DesktopType.KDE;
        }
        if (System.getenv("DTUSERSESSION") != null && System.getenv("DTUSERSESSION").length() != 0) {
            return DesktopType.CDE;
        }
        throw new EnhancedException("BROWSER_NOT_SUPPORTED", new String[0]);
    }

    private static int executeCommand(String[] aCommand, boolean aWaitFor) {
        try {
            ExecuteCommand theExecCmd = new ExecuteCommand(aCommand);
            theExecCmd.setWaitFor(aWaitFor);
            theExecCmd.execute();
            return theExecCmd.getResult();
        }
        catch (EnhancedException theEx) {
            LOGGER.log(Level.FINE, "Error executing command. Command=" + Arrays.toString(aCommand));
            return -1;
        }
    }

    private static void showJavaBrowser(final URL aURL) throws EnhancedException {
        if (theDisplayedWindows.get(aURL) != null) {
            theDisplayedWindows.get(aURL).requestFocus();
            return;
        }
        final JFrame theFrame = new JFrame(aURL.getPath());
        final JEditorPane theHtmlViewer = new JEditorPane();
        theHtmlViewer.setEditable(false);
        theHtmlViewer.setContentType("text/html");
        final Stack theBackStack = new Stack();
        final Stack theNextStack = new Stack();
        final JButton theBackButton = new JButton("< " + Msg.get("back", new Object[0]));
        final JButton theNextButton = new JButton(Msg.get("next", new Object[0]) + " >");
        final JButton theCloseButton = new JButton(Msg.get("close", new Object[0]));
        theBackButton.setEnabled(false);
        theBackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEv) {
                try {
                    theNextStack.push(theHtmlViewer.getPage());
                    theNextButton.setEnabled(true);
                    theFrame.invalidate();
                    theHtmlViewer.setPage((URL)theBackStack.pop());
                    if (theBackStack.isEmpty()) {
                        theBackButton.setEnabled(false);
                        theFrame.invalidate();
                    }
                }
                catch (IOException theEx) {
                    LOGGER.log(Level.WARNING, "CANNOT_BROWSE_PAGE", aURL);
                }
            }
        });
        theNextButton.setEnabled(false);
        theNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEv) {
                try {
                    theBackStack.push(theHtmlViewer.getPage());
                    theBackButton.setEnabled(true);
                    theFrame.invalidate();
                    theHtmlViewer.setPage((URL)theNextStack.pop());
                    if (theNextStack.isEmpty()) {
                        theNextButton.setEnabled(false);
                        theFrame.invalidate();
                    }
                }
                catch (IOException theEx) {
                    LOGGER.log(Level.WARNING, "CANNOT_BROWSE_PAGE", aURL);
                }
            }
        });
        theCloseButton.setEnabled(true);
        theCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEv) {
                theDisplayedWindows.remove(aURL);
                theFrame.setVisible(false);
                theFrame.dispose();
            }
        });
        theHtmlViewer.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent aEv) {
                if (aEv.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        theBackStack.push(((JEditorPane)aEv.getSource()).getPage());
                        theBackButton.setEnabled(true);
                        theNextStack.clear();
                        theNextButton.setEnabled(false);
                        theCloseButton.setEnabled(true);
                        ((JEditorPane)aEv.getSource()).setPage(aEv.getURL());
                        theFrame.invalidate();
                    }
                    catch (IOException theEx) {
                        LOGGER.log(Level.WARNING, "CANNOT_BROWSE_PAGE", aURL);
                    }
                }
            }
        });
        try {
            theHtmlViewer.setPage(aURL);
        }
        catch (IOException theEx) {
            throw new EnhancedException(theEx);
        }
        JScrollPane theViewerScrollPane = new JScrollPane(theHtmlViewer);
        theViewerScrollPane.setPreferredSize(new Dimension(640, 480));
        JPanel theButtonPanel = new JPanel(new GridBagLayout());
        theButtonPanel.add(theBackButton);
        theButtonPanel.add(theNextButton);
        theButtonPanel.add(theCloseButton);
        theFrame.getContentPane().add((Component)theButtonPanel, "North");
        theFrame.getContentPane().add((Component)theViewerScrollPane, "Center");
        theFrame.pack();
        theFrame.setVisible(true);
        theDisplayedWindows.put(aURL, theFrame);
    }

    private static enum DesktopType {
        GNOME,
        KDE,
        CDE;

    }
}

