/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.task;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.NoSuchMemberException;
import org.openinstaller.core.EngineConfigCommand;
import org.openinstaller.core.EngineConfigItem;
import org.openinstaller.pkg.MSIPackageUtils;
import org.openinstaller.pkg.PackageException;
import org.openinstaller.pkg.RPMPackageUtils;
import org.openinstaller.pkg.SVR4PackageUtils;
import org.openinstaller.pkg.ZIPPackageUtils;
import org.openinstaller.provider.task.Task;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.ProgressListener;
import org.openinstaller.sims.util.SimsUtils;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.Platform;

public final class UninstallTask
extends Task {
    private final Package gPackage;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    boolean perform(ProgressListener aListener) {
        String theAltRoot;
        String theDomain;
        String thePkgFormat;
        try {
            thePkgFormat = UninstallTask.getPackageFormat();
        }
        catch (EnhancedException aException) {
            LOGGER.log(Level.SEVERE, "CANNOT_DETERMINE_PACKAGEFORMAT", "os=" + Platform.getCurrentOsName().getValue());
            return false;
        }
        String thePkgName = this.gPackage.getName();
        String theAltRootPath = null;
        try {
            String theInstallHome = UninstallTask.getInstallLocation();
            theDomain = UninstallTask.getDomain();
            BusRequest theReq = new BusRequest("ConfigRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.ALTERNATE_ROOT));
            BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/EngineConfig");
            Object theAltRootObj = theResp.getResult();
            if (theAltRootObj != null) {
                theAltRootPath = (String)theAltRootObj;
            }
            if (theAltRootPath == null || theInstallHome == null) {
                theAltRoot = theAltRootPath == null && theInstallHome != null ? theInstallHome : theAltRootPath;
            } else {
                File theAltFile = new File(theAltRootPath);
                theAltRoot = new File(theAltFile, theInstallHome).getAbsolutePath();
            }
        }
        catch (NoSuchMemberException theNSEx) {
            theNSEx.addContext("CANNOT_DETERMINE_ALT_ROOT", new String[0]);
            LOGGER.log(Level.SEVERE, "CANNOT_DETERMINE_ALT_ROOT", theNSEx);
            return false;
        }
        catch (EnhancedException theEe) {
            LOGGER.log(Level.SEVERE, "MISSING_UNINSTALL_INFO", theEe.getMessage());
            return false;
        }
        if (thePkgFormat.equalsIgnoreCase("svr4")) {
            try {
                if (UninstallTask.isDryRun()) {
                    LOGGER.log(Level.FINE, "DRY_RUN_MODE", new String[]{"package=" + thePkgName, "Alternate Root=" + theAltRoot});
                }
                SVR4PackageUtils.removePkg((String)thePkgName, (String)theDomain, (String)theAltRoot);
            }
            catch (PackageException thePEx) {
                thePEx.addContext("CANT_PERFORM_REMOVE_TASK", new String[]{"package=" + thePkgName});
                LOGGER.log(Level.SEVERE, "CANT_REMOVE_PACKAGE", thePEx);
                return false;
            }
        } else if (thePkgFormat.equalsIgnoreCase("rpm")) {
            try {
                RPMPackageUtils.removePkg((String)thePkgName, (String)theAltRootPath, (String)theDomain, (File)SimsUtils.getFinalAltRoot((String)theAltRootPath, (String)theDomain), (boolean)UninstallTask.isDryRun());
            }
            catch (PackageException thePEx) {
                thePEx.addContext("CANT_PERFORM_REMOVE_TASK", new String[]{"package=" + thePkgName});
                LOGGER.log(Level.SEVERE, "CANT_REMOVE_RPM", thePEx);
                return false;
            }
            catch (EnhancedException theEEx) {
                theEEx.addContext("CANT_PERFORM_REMOVE_TASK", new String[]{"package=" + thePkgName});
                LOGGER.log(Level.SEVERE, "CANT_REMOVE_RPM", theEEx);
                return false;
            }
        } else if (thePkgFormat.equalsIgnoreCase("msi")) {
            try {
                MSIPackageUtils.removePkg((String)this.gPackage.getName(), (String)this.gPackage.getInstance());
            }
            catch (PackageException thePEx) {
                LOGGER.log(Level.SEVERE, "CANT_REMOVE_MSI", thePEx);
                return false;
            }
        } else if (thePkgFormat.equalsIgnoreCase("zip")) {
            try {
                if (UninstallTask.isDryRun()) {
                    LOGGER.log(Level.FINE, "DRY_RUN_MODE", new String[]{"package=" + thePkgName, "Alternate Root=" + theAltRoot});
                }
                ZIPPackageUtils.removePkg((String)this.gPackage.getName(), (String)theAltRoot, (ProgressListener)aListener);
            }
            catch (PackageException thePEx) {
                LOGGER.log(Level.SEVERE, "CANT_REMOVE_ZIP", thePEx);
                return false;
            }
        } else if (thePkgFormat.equalsIgnoreCase("depot")) {
            LOGGER.log(Level.FINE, "Not implemented yet");
        }
        return true;
    }

    public UninstallTask(Package aPackage) {
        this.gPackage = aPackage;
    }
}

