/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.swixgen;

import java.util.List;
import org.openinstaller.provider.conf.apoc.APOCPropValue;
import org.openinstaller.provider.ui.swixgen.SwiXMLVisual;
import org.openinstaller.util.EnhancedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SwiXMLTextArea
extends SwiXMLVisual {
    private int gColumns = 0;
    private String gText = null;

    private SwiXMLTextArea() {
        this.gStartTag = "<scrollpane name=\"gScrollPane\" viewportborder=\"LineBorder(${dynamic_component_viewportborder_color})\" VerticalScrollBarPolicy=\"JScrollPane.VERTICAL_SCROLLBAR_ALWAYS\" HorizontalScrollBarPolicy=\"JScrollPane.HORIZANTAL_SCROLLBAR_AS_NEEDED\"> <textarea linewrap=\"true\" wrapstyleword=\"true\" background=\"${dynamic_component_background}\" font=\"${dynamic_content_font}\" foreground=\"${dynamic_component_foreground}\" ";
        this.gEndTag = "</scrollpane> ";
    }

    public SwiXMLTextArea(String aName, String aActionCommand, List<APOCPropValue> aValue) throws EnhancedException {
        this();
        this.setName(aName);
        this.setActionCommand(aActionCommand);
        this.setValue(aValue);
    }

    @Override
    public void setValue(List<APOCPropValue> aValue) throws EnhancedException {
        String theOORValue = this.getOORValue(aValue);
        if ((null == theOORValue || theOORValue.length() == 0) && 1 == aValue.size()) {
            theOORValue = this.convertAPOCVarToFreemarkerVar(aValue.get(0).getValue());
        }
        if (null == theOORValue) {
            theOORValue = "";
        } else {
            theOORValue = theOORValue.replaceAll("&", "&amp;");
            theOORValue = theOORValue.replaceAll("<", "&lt;");
            theOORValue = theOORValue.replaceAll(">", "&gt;");
            theOORValue = theOORValue.replaceAll("\"", "&quot;");
            theOORValue = theOORValue.replaceAll("'", "&apos;");
        }
        this.gText = theOORValue;
    }

    public void setRows(Integer aRows) {
        if (null != aRows) {
            this.gAttributes.append(" rows=\"").append(aRows).append("\"");
        }
    }

    public void setColumns(Integer aColumns) {
        if (null != aColumns) {
            this.gColumns = aColumns;
            this.gAttributes.append(" columns=\"").append(this.gColumns).append("\"");
        }
    }

    public int getColumns() {
        return this.gColumns;
    }

    public void setReadOnly(boolean aValue) {
        if (aValue) {
            this.gAttributes.append(" editable=\"false\"");
        }
    }

    @Override
    public String getSwiXML() {
        return this.gStartTag + this.gAttributes.toString() + " > " + this.gText + "</textarea><gridbagconstraints " + this.gGridBagAttributes.toString() + " />" + this.gEndTag;
    }
}

