/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.wizard;

import bsh.EvalError;
import bsh.Interpreter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openinstaller.bindings.ui.pagesequence.Page;
import org.openinstaller.bus.BusEvent;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.provider.conf.ConfigHelper;
import org.openinstaller.provider.conf.apoc.APOCProperty;
import org.openinstaller.provider.conf.apoc.APOCTemplate;
import org.openinstaller.provider.ui.UserInterfaceWizard;
import org.openinstaller.provider.ui.sequencer.GlobalPageSequence;
import org.openinstaller.provider.ui.swixgen.SwiXMLBuilder;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Scripting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWizard
implements UserInterfaceWizard {
    protected static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    public final ControlBus gBus = ControlBus.getInstance();
    protected URL gMediaLocationURL;
    protected APOCTemplate gAPOCTemplate;
    public SwiXMLBuilder gSwiXMLBuilder;

    protected AbstractWizard() {
    }

    protected void startEventQueueWatchdog() {
        try {
            Class<?> theEventQueueWatchdog = Class.forName("org.openinstaller.debug.ui.EventQueueWatchdog");
            if (null != theEventQueueWatchdog) {
                theEventQueueWatchdog.getMethod("start", new Class[0]).invoke(null, new Object[0]);
            }
        }
        catch (Throwable theException) {
            LOGGER.finest("Could not initialize Swing Event Queue Watchdog: " + theException.getMessage());
            LOGGER.finest(EnhancedException.getStackAsString((Throwable)theException));
        }
    }

    protected Set<String> getActiveModesSet() {
        try {
            Object theObject = ConfigHelper.getValue("PageFlow.Mode.ACTIVE_MODES_LIST");
            HashSet<String> theReturnSet = new HashSet<String>();
            if (null == theObject) {
                LOGGER.fine("CAUTION: Global page flow modes list not available at PageFlow.Mode.ACTIVE_MODES_LIST. Returning empty set.");
            } else if (theObject instanceof List) {
                List theList = (List)theObject;
                theReturnSet.addAll(theList);
                LOGGER.fine("Global Skip list is a proper list: " + ((Object)theReturnSet).toString());
            } else {
                LOGGER.fine("CAUTION: Global Skip list data type is not a list.");
                if (theObject instanceof String) {
                    theReturnSet.add((String)theObject);
                    LOGGER.fine(((Object)theReturnSet).toString());
                    LOGGER.fine("CAUTION: Global Skip list is a string: " + ((Object)theReturnSet).toString());
                } else {
                    LOGGER.fine("CAUTION: Returning empty Global Skip list.");
                }
            }
            return theReturnSet;
        }
        catch (EnhancedException theException) {
            LOGGER.fine("CAUTION: Error while trying to get PageFlow.Mode.ACTIVE_MODES_LIST : " + theException.getMessage());
            LOGGER.fine("CAUTION: Returning empty set.");
            return new HashSet<String>();
        }
    }

    public boolean isSkippable(Page aPage) throws EnhancedException {
        LOGGER.finest("Doing " + ClassUtils.getMethodName() + " for " + aPage.getName());
        Set<String> theActiveModes = this.getActiveModesSet();
        if (0 != theActiveModes.size()) {
            String theWhen = aPage.getWhen();
            if (null == theWhen || "".equals(theWhen)) {
                LOGGER.finest("when is empty or not defined");
                return false;
            }
            LOGGER.finest("Skip condition is: [" + theWhen + "]");
            Interpreter theInterpreter = Scripting.getInterpreter();
            String theExpr = theWhen;
            Matcher theMatcher = Pattern.compile("([A-Za-z0-9_.\\[\\]\\{\\}-]+)").matcher(theWhen);
            while (theMatcher.find()) {
                String theNextModeTag = theMatcher.group();
                LOGGER.finest("One match + [" + theNextModeTag + "]");
                if ("true".equals(theNextModeTag) || "false".equals(theNextModeTag)) {
                    LOGGER.finest("Ignoring it.");
                    continue;
                }
                if (theActiveModes.contains(theNextModeTag)) {
                    theExpr = theExpr.replaceAll(Pattern.quote(theNextModeTag), "true");
                    LOGGER.finest("After replacement with true + [" + theExpr + "]");
                    continue;
                }
                theExpr = theExpr.replaceAll(Pattern.quote(theNextModeTag), "false");
                LOGGER.finest("After replacement with false + [" + theExpr + "]");
            }
            LOGGER.finest("Done replacing [" + theExpr + "]");
            try {
                theExpr = "((boolean)(" + theExpr + "));";
                Object theRes = theInterpreter.eval(theExpr);
                LOGGER.finest("The return result class is " + theRes.getClass());
                return (Boolean)theRes == false;
            }
            catch (EvalError aEvalError) {
                throw new EnhancedException("CAN_NOT_PARSE_PAGE_SHOW_CONDITION", new String[]{theExpr, "condition=" + theWhen, "page=" + aPage.getName()});
            }
        }
        LOGGER.fine("No modes to worry about. We will not skip");
        boolean theResult = false;
        LOGGER.fine("isSkippable = " + theResult);
        return theResult;
    }

    @Override
    public void setNextButtonText(String aText) {
    }

    @Override
    public void setBackButtonText(String aText) {
    }

    @Override
    public void setCancelButtonText(String aText) {
    }

    @Override
    public void setHelpButtonText(String aText) {
    }

    public static final void setInitialProperties(Properties aAnswerfileProps) throws EnhancedException {
        for (Map.Entry<Object, Object> theProperty : aAnswerfileProps.entrySet()) {
            String theKey = (String)theProperty.getKey();
            String theVal = (String)theProperty.getValue();
            if (theKey == null || theVal == null) {
                throw new EnhancedException("NULL_PROPERTY", new String[]{"property=" + theKey, "value=" + theVal});
            }
            String[] theParts = theKey.split("\\.", 2);
            if (theParts.length != 2) {
                throw new EnhancedException("INVALID_PROPERTY", new String[]{"property=" + theKey, "value=" + theVal});
            }
            String theProd = theParts[0];
            String theProdProp = theParts[1];
            try {
                AbstractWizard.setUIValue(theProd, theProdProp, theVal);
            }
            catch (EnhancedException theEx) {
                LOGGER.log(Level.FINEST, "Can't find UI properties for " + theProd + " prop:" + theProdProp + " val: " + theVal);
                String theUIFailReason = EnhancedException.getLastCause((Throwable)theEx).getLocalizedMessage();
                try {
                    AbstractWizard.setModelValue(theProd, theProdProp, theVal);
                }
                catch (EnhancedException theEx2) {
                    String theCompoundReason = EnhancedException.getLastCause((Throwable)theEx2).getLocalizedMessage();
                    if (theUIFailReason != null) {
                        theCompoundReason = theCompoundReason + ": " + theUIFailReason;
                    }
                    LOGGER.finest("Initial load for a property failed.\n" + EnhancedException.getCompleteStack((Throwable)theEx2) + "\ncomponent=" + theProd + "\nproperty=" + theProdProp + "\nvalue=" + theVal + "\nreason=" + theCompoundReason);
                }
            }
        }
    }

    private static void setUIValue(String aProd, String aVarName, String aFrozenValue) throws EnhancedException {
        List<APOCProperty> theProperties = ConfigHelper.getUIProperties(aProd);
        for (APOCProperty theAPOCProperty : theProperties) {
            String theDataPath = theAPOCProperty.getDataPath();
            if ("".equals(theDataPath)) {
                LOGGER.fine("Skipping variable with no datapath.");
                continue;
            }
            LOGGER.fine("About to deal with product " + aProd + " and variable " + aVarName);
            if (!theDataPath.equals(aVarName)) continue;
            Object theFinalValue = ConfigHelper.thaw(aFrozenValue, ConfigHelper.getType(aProd + "." + aVarName));
            ConfigHelper.setValue(aProd + "." + aVarName, theFinalValue);
            return;
        }
        throw new EnhancedException("NO_PARAM_FOR_PROD", new String[]{"component=" + aProd, "property=" + aVarName, "value=" + aFrozenValue});
    }

    private static void setModelValue(String aProd, String aVarName, String aFrozenValue) throws EnhancedException {
        ConfigHelper.setValue(aProd + "." + aVarName, ConfigHelper.thaw(aFrozenValue, ConfigHelper.getType(aProd + "." + aVarName)));
    }

    @Override
    public void clickCancel() {
        try {
            this.gBus.publishEvent(new BusEvent("shutdown"));
        }
        catch (InvalidArgumentException theEIAEx) {
            LOGGER.log(Level.SEVERE, "BUS_EVENT_REQ_FAILED", theEIAEx);
        }
    }

    protected void populateDataModel() throws EnhancedException {
        ArrayList<String> theNames = new ArrayList<String>();
        int theCurrentIndex = GlobalPageSequence.getPageIndex();
        int thePageCountRemovedBeforeCurrentPage = 0;
        List<Page> thePages = GlobalPageSequence.getPages();
        for (int i = 0; i < thePages.size(); ++i) {
            Page thePage = thePages.get(i);
            if (!this.isSkippable(thePage)) {
                String theLabel = thePage.getLabel();
                LOGGER.fine("populateDataModel: Adding label [" + theLabel + "]");
                theNames.add(theLabel);
                continue;
            }
            if (i >= theCurrentIndex) continue;
            ++thePageCountRemovedBeforeCurrentPage;
        }
        this.gSwiXMLBuilder.replaceInDataModel("activeIndex", theCurrentIndex - thePageCountRemovedBeforeCurrentPage);
        this.gSwiXMLBuilder.replaceInDataModel("buttons", theNames);
        this.gSwiXMLBuilder.replaceInDataModel("curPageTitle", GlobalPageSequence.getPageAtIndex(theCurrentIndex).getLabel());
        boolean theNext = theCurrentIndex != GlobalPageSequence.getPageCount() - 1;
        this.gSwiXMLBuilder.replaceInDataModel("showNext", theNext);
    }
}

