/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.sims.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.SIMSException;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Encoders {
    private static final char ENTITY_SEP = '#';

    private Encoders() {
    }

    public static String encodeProducts(Iterable<SystemProduct> aProductSet) {
        StringBuilder theContained = new StringBuilder();
        Iterator<SystemProduct> theIter = aProductSet.iterator();
        while (theIter.hasNext()) {
            theContained.append(StringUtils.escape((String)SystemProduct.encode(theIter.next()), (char)'#'));
            if (!theIter.hasNext()) continue;
            theContained.append('#');
        }
        return theContained.toString();
    }

    public static String encodePackages(Iterable<Package> aPackageSet) {
        StringBuilder theContained = new StringBuilder();
        Iterator<Package> theIter = aPackageSet.iterator();
        while (theIter.hasNext()) {
            theContained.append(StringUtils.escape((String)Package.encode(theIter.next()), (char)'#'));
            if (!theIter.hasNext()) continue;
            theContained.append('#');
        }
        return theContained.toString();
    }

    public static SystemProduct[] decodeProducts(String aContainedProductInfo) throws SIMSException {
        String[] theProdSpecs = aContainedProductInfo.split(Character.toString('#'));
        SystemProduct[] theProds = new SystemProduct[theProdSpecs.length];
        for (int theIndex = 0; theIndex < theProdSpecs.length; ++theIndex) {
            theProds[theIndex] = new SystemProduct(StringUtils.unescape((String)theProdSpecs[theIndex], (char)'#'));
        }
        return theProds;
    }

    public static Package[] decodePackages(String aContainedPackageInfo) throws SIMSException {
        String[] thePkgSpecs = aContainedPackageInfo.split(Character.toString('#'));
        Package[] thePkgs = new Package[thePkgSpecs.length];
        for (int theIndex = 0; theIndex < thePkgSpecs.length; ++theIndex) {
            thePkgs[theIndex] = new Package(StringUtils.unescape((String)thePkgSpecs[theIndex], (char)'#'));
        }
        return thePkgs;
    }

    public static String[] split(String aStr, char aEsc) {
        ArrayList<String> theComps = new ArrayList<String>();
        String[] theSplit = aStr.split(Character.toString(aEsc), -1);
        for (int theIndex = 0; theIndex < theSplit.length; ++theIndex) {
            if (theSplit[theIndex].endsWith("\\")) {
                int theSubIndex;
                StringBuilder theResult = new StringBuilder(theSplit[theIndex]);
                for (theSubIndex = theIndex + 1; theSubIndex < theSplit.length; ++theSubIndex) {
                    theResult.append(aEsc);
                    theResult.append(theSplit[theSubIndex]);
                    if (!theSplit[theSubIndex].endsWith("\\")) break;
                }
                theComps.add(theResult.toString());
                theIndex = theSubIndex;
                continue;
            }
            theComps.add(theSplit[theIndex]);
        }
        return theComps.toArray(new String[0]);
    }
}

