/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.service.BridgeContext;
import com.sun.messaging.bridge.service.stomp.NotConnectedException;
import com.sun.messaging.bridge.service.stomp.StompFrameMessage;
import com.sun.messaging.bridge.service.stomp.StompProtocolException;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandler;
import com.sun.messaging.bridge.service.stomp.StompSenderSession;
import com.sun.messaging.bridge.service.stomp.StompSenderSessionImpl;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.StompSubscriberSession;
import com.sun.messaging.bridge.service.stomp.StompTransactedSession;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;

public class StompConnection
implements ExceptionListener {
    private Logger _logger = null;
    private BridgeContext _bc = null;
    private Properties _jmsprop = null;
    private Connection _connection = null;
    private String _connectionUID = "";
    private boolean _connectionException = false;
    private StompSenderSession _pubSession = null;
    private String _clientid = null;
    private StompBridgeResources _sbr = null;
    private Map<String, StompSubscriberSession> _subSessions = Collections.synchronizedMap(new HashMap());
    private StompTransactedSession _txSession = null;
    private StompProtocolHandler _sph = null;

    public StompConnection(BridgeContext bridgeContext, Properties properties, StompProtocolHandler stompProtocolHandler) {
        this._logger = StompServer.logger();
        this._bc = bridgeContext;
        this._jmsprop = properties;
        this._sph = stompProtocolHandler;
        this._sbr = StompServer.getStompBridgeResources();
    }

    public synchronized String connect(String string, String string2, String string3) throws Exception {
        if (this._connection != null) {
            throw new IllegalStateException("Unexpected " + (Object)((Object)StompFrameMessage.Command.CONNECT) + ", already connected");
        }
        if (string3 == null) {
            this._logger.log(Level.INFO, this._sbr.getString("BSS1000", string));
        } else {
            this._logger.log(Level.INFO, this._sbr.getString("BSS1001", string, string3));
        }
        this._connection = string != null ? this._bc.getConnectionFactory(this._jmsprop).createConnection(string, string2) : this._bc.getConnectionFactory(this._jmsprop).createConnection();
        if (string3 != null) {
            this._clientid = string3;
            this._connection.setClientID(string3);
        }
        ((ConnectionImpl)this._connection)._setAppTransactedAck();
        this._connectionUID = ((ConnectionImpl)this._connection)._getConnectionID() + "[" + this._connection.getClientID() + "]";
        this._connection.start();
        this._logger.log(Level.INFO, this._sbr.getString("BSS1002", this._connectionUID, string));
        return this._connectionUID;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public String toString() {
        String string = this._connectionUID;
        return string == null ? "" : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect(boolean bl) throws Exception {
        if (bl) {
            this.checkConnection();
        }
        if (this._connection != null) {
            try {
                if (this._pubSession != null) {
                    this._pubSession.close();
                    this._pubSession = null;
                }
                if (this._txSession != null) {
                    this._txSession.close();
                    this._txSession = null;
                }
                Map<String, StompSubscriberSession> map = this._subSessions;
                synchronized (map) {
                    for (String string : this._subSessions.keySet()) {
                        StompSubscriberSession stompSubscriberSession = this._subSessions.get(string);
                        stompSubscriberSession.close();
                    }
                    this._subSessions.clear();
                }
                this._connection.close();
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                this._connection = null;
                this._connectionException = false;
            }
            this._logger.log(Level.INFO, this._sbr.getString("BSS1003", this._connectionUID));
        } else {
            this._logger.log(Level.FINE, this._sbr.getString("BSS1004", this._connectionUID));
        }
    }

    public synchronized void beginTransactedSession(String string) throws Exception {
        String string2;
        Connection connection = this._connection;
        this.checkConnection(connection);
        if (string == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this._txSession == null) {
            this._txSession = new StompTransactedSession(this);
        }
        if ((string2 = this._txSession.getTransactionID()) != null) {
            throw new StompProtocolException(this._sbr.getKString("BSS4002", string2, string));
        }
        this._txSession.setTransactionID(string);
    }

    public synchronized void commitTransactedSession(String string) throws Exception {
        Connection connection = this._connection;
        this.checkConnection(connection);
        if (string == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this._txSession == null) {
            throw new StompProtocolException(this._sbr.getKString("BSS4003", string));
        }
        String string2 = this._txSession.getTransactionID();
        if (string2 == null || !string2.equals(string)) {
            throw new StompProtocolException(this._sbr.getKString("BSS4004", string) + (string2 == null ? "" : " " + this._sbr.getString("BSS1005", string2)));
        }
        this._txSession.commit();
    }

    public synchronized void abortTransactedSession(String string) throws Exception {
        Connection connection = this._connection;
        this.checkConnection(connection);
        if (string == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this._txSession == null) {
            throw new StompProtocolException(this._sbr.getKString("BSS4003", string));
        }
        String string2 = this._txSession.getTransactionID();
        String string3 = this._txSession.getLastRolledbackTID();
        if (string2 == null && string3 != null && string3.equals(string)) {
            this._logger.log(Level.INFO, this._sbr.getString("BSS1006", string));
            return;
        }
        if (string2 == null || !string2.equals(string)) {
            throw new StompProtocolException(this._sbr.getKString("BSS4004", string) + (string2 == null ? "" : " " + this._sbr.getString("BSS1005", string2)));
        }
        this._txSession.rollback();
    }

    public synchronized StompTransactedSession getTransactedSession(String string) throws Exception {
        this.checkConnection();
        if (string == null) {
            throw new IllegalArgumentException("Unexpected call: null transaction id");
        }
        if (this._txSession == null) {
            throw new StompProtocolException(this._sbr.getKString("BSS4003", string));
        }
        String string2 = this._txSession.getTransactionID();
        if (string2 == null || !string2.equals(string)) {
            throw new StompProtocolException(this._sbr.getKString("BSS4004", string) + (string2 == null ? "" : " " + this._sbr.getString("BSS1005", string2)));
        }
        return this._txSession;
    }

    public synchronized StompTransactedSession getTransactedSession() throws Exception {
        this.checkConnection();
        if (this._txSession == null) {
            return null;
        }
        if (this._txSession.getTransactionID() == null) {
            return null;
        }
        return this._txSession;
    }

    public synchronized StompSenderSession getSenderSession() throws Exception {
        Connection connection = this._connection;
        this.checkConnection(connection);
        if (this._pubSession == null) {
            this._pubSession = new StompSenderSessionImpl(connection);
        }
        return this._pubSession;
    }

    public synchronized StompSubscriberSession createSubscriberSession(String string, int n) throws Exception {
        Connection connection = this._connection;
        this.checkConnection(connection);
        if (string == null) {
            throw new IllegalArgumentException("No subscription id");
        }
        StompSubscriberSession stompSubscriberSession = this._subSessions.get(string);
        if (stompSubscriberSession != null) {
            throw new StompProtocolException(this._sbr.getKString("BSS4005", string));
        }
        stompSubscriberSession = new StompSubscriberSession(string, n, this);
        this._subSessions.put(string, stompSubscriberSession);
        return stompSubscriberSession;
    }

    public synchronized StompSubscriberSession getSubscriberSession(String string) throws Exception {
        this.checkConnection();
        if (string == null) {
            throw new IllegalArgumentException("No subscription id");
        }
        StompSubscriberSession stompSubscriberSession = this._subSessions.get(string);
        return stompSubscriberSession;
    }

    public synchronized String closeSubscriber(String string, String string2) throws Exception {
        String string3;
        this.checkConnection();
        StompSubscriberSession stompSubscriberSession = null;
        if (string2 == null) {
            stompSubscriberSession = this._subSessions.get(string);
            if (stompSubscriberSession != null) {
                stompSubscriberSession.close();
                this._subSessions.remove(string);
                return null;
            }
        } else {
            if (this._clientid == null) {
                throw new StompProtocolException(this._sbr.getKString("BSS4006", string2));
            }
            string3 = null;
            for (String string4 : this._subSessions.keySet()) {
                stompSubscriberSession = this._subSessions.get(string4);
                string3 = stompSubscriberSession.getDuraName();
                if (string3 == null || !string3.equals(string2)) continue;
                stompSubscriberSession.closeSubscriber();
                stompSubscriberSession.getJMSSession().unsubscribe(string2);
                stompSubscriberSession.close();
                this._subSessions.remove(string4);
                return string4;
            }
        }
        if (this._txSession != null) {
            string3 = this._txSession.closeSubscriber(string, string2);
            if (string2 != null) {
                return string3;
            }
            if (string3 != null) {
                return string3;
            }
        } else if (string2 != null) {
            this.getSenderSession().getJMSSession().unsubscribe(string2);
            return null;
        }
        throw new StompProtocolException(this._sbr.getKString("BSS4007", string));
    }

    public synchronized void ackNonTransacted(String string, String string2) throws Exception {
        this.checkConnection();
        StompSubscriberSession stompSubscriberSession = null;
        for (String string3 : this._subSessions.keySet()) {
            if (!string3.startsWith(string)) continue;
            stompSubscriberSession = this._subSessions.get(string3);
            stompSubscriberSession.ack(string2);
            return;
        }
        throw new StompProtocolException(this._sbr.getKString("BSS4008", string2, "subscription".toString()));
    }

    private synchronized void checkConnection() throws Exception {
        this.checkConnection(this._connection);
        if (this._connectionException) {
            this.disconnect(false);
            this._connectionException = false;
        }
    }

    private synchronized void checkConnection(Connection connection) throws Exception {
        if (connection == null) {
            throw new NotConnectedException(this._sbr.getKString("BSS4009"));
        }
    }

    public void onException(JMSException jMSException) {
        this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3000", this._connectionUID, jMSException.getMessage()), jMSException);
        this._connectionException = true;
    }

    protected StompFrameMessage toStompFrameMessage(Message message, String string, Session session) throws Exception {
        return this._sph.toStompFrameMessage(message, string, session);
    }
}

