/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.async.AsyncQueueWriteUnit;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.util.AttributeHolder;
import com.sun.grizzly.util.SSLOutputWriter;
import com.sun.grizzly.util.WorkerThread;
import com.sun.messaging.bridge.service.BridgeContext;
import com.sun.messaging.bridge.service.stomp.AsyncStompOutputHandler;
import com.sun.messaging.bridge.service.stomp.StompFrameMessage;
import com.sun.messaging.bridge.service.stomp.StompOutputHandler;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandler;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Properties;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

public class StompProtocolFilter
implements ProtocolFilter,
StompOutputHandler {
    protected static final String STOMP_PROTOCOL_HANDLER_ATTR = "stomp-protocol-handler";
    private Logger _logger = StompServer.logger();
    private BridgeContext _bc = null;
    private Properties _jmsprop = null;
    private StompBridgeResources _sbr = null;

    public StompProtocolFilter(BridgeContext bridgeContext, Properties properties) {
        this._bc = bridgeContext;
        this._jmsprop = properties;
        this._sbr = StompServer.getStompBridgeResources();
    }

    public boolean execute(Context context) throws IOException {
        StompProtocolHandler stompProtocolHandler = null;
        try {
            stompProtocolHandler = this.getStompProtocolHandler(context);
            StompFrameMessage stompFrameMessage = (StompFrameMessage)context.removeAttribute("ProtocolMessage");
            switch (stompFrameMessage.getCommand()) {
                case CONNECT: {
                    stompProtocolHandler.onCONNECT(stompFrameMessage, this, context);
                    break;
                }
                case SEND: {
                    stompProtocolHandler.onSEND(stompFrameMessage, this, context);
                    break;
                }
                case SUBSCRIBE: {
                    AsyncStompOutputHandler asyncStompOutputHandler = new AsyncStompOutputHandler(context.getSelectionKey(), context.getSelectorHandler(), ((WorkerThread)Thread.currentThread()).getSSLEngine(), stompProtocolHandler, this._bc);
                    stompProtocolHandler.onSUBSCRIBE(stompFrameMessage, this, context, asyncStompOutputHandler);
                    break;
                }
                case UNSUBSCRIBE: {
                    stompProtocolHandler.onUNSUBSCRIBE(stompFrameMessage, this, context);
                    break;
                }
                case BEGIN: {
                    stompProtocolHandler.onBEGIN(stompFrameMessage, this, context);
                    break;
                }
                case COMMIT: {
                    stompProtocolHandler.onCOMMIT(stompFrameMessage, this, context);
                    break;
                }
                case ABORT: {
                    stompProtocolHandler.onABORT(stompFrameMessage, this, context);
                    break;
                }
                case ACK: {
                    stompProtocolHandler.onACK(stompFrameMessage, this, context);
                    break;
                }
                case DISCONNECT: {
                    stompProtocolHandler.onDISCONNECT(stompFrameMessage, this, context);
                    break;
                }
                case ERROR: {
                    this.sendToClient(stompFrameMessage, context, stompProtocolHandler);
                    break;
                }
                default: {
                    throw new IOException("Internal Error: unexpected STOMP frame " + (Object)((Object)stompFrameMessage.getCommand()));
                }
            }
        }
        catch (Throwable throwable) {
            this._logger.log(Level.SEVERE, throwable.getMessage(), throwable);
            try {
                StompFrameMessage stompFrameMessage = StompProtocolHandler.toStompErrorMessage("StompProtocolFilter", throwable);
                this.sendToClient(stompFrameMessage, context, stompProtocolHandler);
            }
            catch (Exception exception) {
                this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3001", throwable.toString(), exception.toString()), exception);
            }
        }
        return false;
    }

    public void sendToClient(StompFrameMessage stompFrameMessage) throws Exception {
        throw new UnsupportedOperationException("sendToclient(msg)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToClient(final StompFrameMessage stompFrameMessage, final Context context, StompProtocolHandler stompProtocolHandler) throws Exception {
        block11: {
            try {
                boolean bl = false;
                if (stompFrameMessage.getCommand() == StompFrameMessage.Command.ERROR && stompFrameMessage.isFatalERROR()) {
                    bl = true;
                }
                SSLEngine sSLEngine = ((WorkerThread)Thread.currentThread()).getSSLEngine();
                ByteBuffer byteBuffer = stompFrameMessage.marshall();
                if (sSLEngine == null) {
                    if (!bl) {
                        context.getAsyncQueueWritable().writeToAsyncQueue(byteBuffer);
                    } else {
                        AsyncWriteCallbackHandler asyncWriteCallbackHandler = new AsyncWriteCallbackHandler(){

                            public void onWriteCompleted(SelectionKey selectionKey, AsyncQueueWriteUnit asyncQueueWriteUnit) {
                                StompProtocolFilter.this._logger.log(Level.FINE, "Completed sending " + stompFrameMessage + ", canceling key " + selectionKey);
                                context.getSelectorHandler().getSelectionKeyHandler().cancel(selectionKey);
                            }

                            public void onException(Exception exception, SelectionKey selectionKey, ByteBuffer byteBuffer, Queue<AsyncQueueWriteUnit> queue) {
                            }
                        };
                        context.getAsyncQueueWritable().writeToAsyncQueue(byteBuffer, asyncWriteCallbackHandler);
                    }
                    break block11;
                }
                SelectableChannel selectableChannel = context.getSelectionKey().channel();
                Object object = selectableChannel;
                synchronized (object) {
                    SSLOutputWriter.flushChannel((SelectableChannel)selectableChannel, (ByteBuffer)byteBuffer);
                }
                if (bl) {
                    object = context.getSelectionKey();
                    this._logger.log(Level.INFO, this._sbr.getKString("BSS1007", stompFrameMessage.toString(), object));
                    context.getSelectorHandler().getSelectionKeyHandler().cancel((SelectionKey)object);
                }
            }
            catch (ClosedChannelException closedChannelException) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS2002", stompFrameMessage.toString(), closedChannelException.toString()));
                if (stompProtocolHandler != null) {
                    stompProtocolHandler.close(false);
                }
                throw closedChannelException;
            }
        }
    }

    public boolean postExecute(Context context) throws IOException {
        return true;
    }

    private StompProtocolHandler getStompProtocolHandler(Context context) {
        StompProtocolHandler stompProtocolHandler = null;
        AttributeHolder attributeHolder = context.getAttributeHolderByScope(Context.AttributeScope.CONNECTION);
        if (attributeHolder == null) {
            WorkerThread workerThread = (WorkerThread)Thread.currentThread();
            attributeHolder = workerThread.getAttachment();
            context.getSelectionKey().attach(attributeHolder);
        }
        if ((stompProtocolHandler = (StompProtocolHandler)attributeHolder.getAttribute(STOMP_PROTOCOL_HANDLER_ATTR)) == null) {
            stompProtocolHandler = new StompProtocolHandler(this._bc, this._jmsprop);
            attributeHolder.setAttribute(STOMP_PROTOCOL_HANDLER_ATTR, (Object)stompProtocolHandler);
        }
        return stompProtocolHandler;
    }
}

