/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ConnectionConsumerReader;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.RemoteAcknowledgeException;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jmq.jmsclient.XAResourceImpl;
import com.sun.messaging.jmq.jmsclient.XAResourceMap;
import com.sun.messaging.jmq.jmsclient.XASessionImpl;
import com.sun.messaging.jmq.jmsspi.ServerSession;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.ServerSessionPool;

public class ConnectionConsumerImpl
extends Consumer
implements ConnectionConsumer,
Traceable {
    protected ServerSessionPool serverSessionPool;
    protected int maxMessages;
    private SessionQueue readQueue = null;
    private ConnectionConsumerReader reader = null;
    private Long readQueueId = null;
    private javax.jms.ServerSession serverSession = null;
    private SessionImpl session = null;
    private Object closeLock = new Object();
    private boolean failoverInProgress = false;
    private Object recreationLock = new Object();
    private boolean recreationInProgress1 = false;
    private boolean recreationInProgress2 = false;
    private Long interestIdToBeRecreated = null;
    private List seenSessions = Collections.synchronizedList(new ArrayList());

    public ConnectionConsumerImpl(ConnectionImpl connectionImpl, Destination destination, String string, ServerSessionPool serverSessionPool, int n, String string2) throws JMSException {
        super(connectionImpl, destination, string, false);
        if (string2 != null) {
            if (connectionImpl.clientID == null) {
                String string3 = AdministeredObject.cr.getKString("C4053", "\"\"");
                throw new JMSException(string3, "C4053");
            }
            this.setDurable(true);
            this.setDurableName(string2);
        }
        this.serverSessionPool = serverSessionPool;
        this.maxMessages = n;
        this.init();
    }

    public void init() throws JMSException {
        this.readQueue = new SessionQueue();
        if (this.connection.getIsStopped()) {
            this.readQueue.setIsLocked(true);
        }
        this.readQueueId = this.connection.getNextSessionId();
        this.connection.addToReadQTable(this.readQueueId, this.readQueue);
        this.reader = new ConnectionConsumerReader(this);
        this.reader.start();
        this.addInterest();
    }

    private void addInterest() throws JMSException {
        this.connection.addConnectionConsumer(this);
        this.registerInterest();
    }

    private void removeInterest() throws JMSException {
        this.connection.removeConnectionConsumer(this);
        this.deregisterInterest();
    }

    protected Long getReadQueueId() {
        return this.readQueueId;
    }

    protected SessionQueue getReadQueue() {
        return this.readQueue;
    }

    protected boolean canRecreate() {
        if (this.destination instanceof Queue) {
            return true;
        }
        return this.getDurableName() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRecreation(RemoteAcknowledgeException remoteAcknowledgeException) {
        Long l = this.getInterestId();
        Hashtable<Long, ConnectionConsumerImpl> hashtable = new Hashtable<Long, ConnectionConsumerImpl>();
        hashtable.put(l, this);
        if (SessionImpl.matchConsumerIDs(remoteAcknowledgeException, hashtable, ConnectionImpl.connectionLogger)) {
            Object object = this.recreationLock;
            synchronized (object) {
                if (this.interestIdToBeRecreated == null || !this.interestIdToBeRecreated.equals(l)) {
                    if (!this.getInterestId().equals(l)) {
                        return;
                    }
                    this.interestIdToBeRecreated = l;
                    ConnectionImpl.connectionLogger.log(Level.FINE, "Notified ConnectionConsumer[" + l + "] to be recreated");
                    if (this.readQueue.isEmpty()) {
                        this.readQueue.enqueueNotify(null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean recreateIfNecessary() throws JMSException {
        if (!this.canRecreate()) {
            return false;
        }
        var1_1 = null;
        var2_2 = false;
        var3_3 = this.closeLock;
        synchronized (var3_3) {
            this.checkState();
            if (this.failoverInProgress) {
                return false;
            }
            var4_4 = this.recreationLock;
            synchronized (var4_4) {
                var1_1 = this.interestIdToBeRecreated;
                this.setRecreationInProgress1(true);
            }
        }
        var3_3 = ConnectionImpl.connectionLogger;
        var4_5 = false;
        try {
            var5_6 = this.getInterestId();
            if (var1_1 == null || !var1_1.equals(var5_6)) ** GOTO lbl145
            var3_3.log(Level.INFO, "Recreate ConnectionConsumer[" + var5_6 + "] ...");
            var6_7 = this.connection.getProtocolHandler();
            try {
                var6_7.stopSession(this.connection.getConnectionID());
                var3_3.log(Level.FINE, "Stopped ConnectionConsumer[" + var5_6 + "]'s session " + var5_6);
                var4_5 = true;
            }
            catch (Throwable var7_9) {
                var8_12 = "Exception in stopping ConnectionConsumer[" + var5_6 + "]'s session";
                var3_3.log(Level.SEVERE, var8_12, var7_9);
                if (var7_9 instanceof JMSException) {
                    throw (JMSException)var7_9;
                }
                var9_15 = new JMSException(var8_12 + ": " + var7_9.getMessage());
                var9_15.initCause(var7_9);
                throw var9_15;
            }
            var7_10 = this.closeLock;
            synchronized (this.closeLock) {
                block68: {
                    this.checkState();
                    if (!this.failoverInProgress) break block68;
                    var8_13 = false;
                    // ** MonitorExit[var7_10] (shouldn't be in output)
                    var19_17 = null;
                    this.setRecreationInProgress1(false);
                    this.setRecreationInProgress2(false);
                    if (var4_5 == false) return var8_13;
                    var20_22 = this.connection.getProtocolHandler();
                    var3_3.log(Level.INFO, "Start ConnectionConsumer[" + this.getInterestId() + "]'s session " + this.connection.getConnectionID());
                    ** GOTO lbl-1000
                }
                var8_14 = this.recreationLock;
                synchronized (var8_14) {
                    this.setRecreationInProgress2(true);
                }
                // ** MonitorExit[var7_10] (shouldn't be in output)
                var3_3.log(Level.INFO, "Reset ConnectionConsumer[" + var5_6 + "]'s ServerSessions " + this.seenSessions.size());
                var7_10 = null;
                var8_14 = this.seenSessions;
                synchronized (var8_14) {
                    var7_10 = this.seenSessions.toArray(new SessionImpl[0]);
                }
                var8_14 = null;
                for (var9_16 = 0; var9_16 < var7_10.length; ++var9_16) {
                    var8_14 = var7_10[var9_16];
                    var3_3.log(Level.FINE, "Reseting ConnectionConsumer[" + var5_6 + "]'s ServerSession's session " + var8_14);
                    var8_14.resetServerSessionRunner(false);
                    var3_3.log(Level.FINE, "Reseted ConnectionConsumer[" + var5_6 + "]'s ServerSession's session " + var8_14);
                }
                var9_16 = 0;
                var10_47 = 0L;
                while ((var9_16 = XAResourceMap.hasXAResourceForCC(this)) > 0 && !this.failoverInProgress && !this.isClosed) {
                    if (var10_47 % 15000L == 0L) {
                        var10_47 = 0L;
                        var3_3.log(Level.INFO, "Waiting for all active XAResources " + var9_16 + " before recreate ConnectionConsumer[" + var5_6 + "] ...");
                    }
                    var12_48 = this.closeLock;
                    synchronized (var12_48) {
                        try {
                            this.closeLock.wait(1000L);
                            var10_47 += 1000L;
                        }
                        catch (InterruptedException var13_51) {
                            // empty catch block
                        }
                    }
                }
                try {
                    this.deregisterInterest();
                }
                catch (Throwable var12_49) {
                    var13_52 = Level.SEVERE;
                    if (this.connection.getRecoverInProcess()) {
                        var13_52 = Level.WARNING;
                    }
                    var3_3.log(var13_52, "Exception on deregister interest to recreate ConnectionConsumer[" + var5_6 + "]");
                    var14_55 = false;
                    var19_18 = null;
                    this.setRecreationInProgress1(false);
                    this.setRecreationInProgress2(false);
                    if (var4_5 == false) return var14_55;
                    var20_23 = this.connection.getProtocolHandler();
                    var3_3.log(Level.INFO, "Start ConnectionConsumer[" + this.getInterestId() + "]'s session " + this.connection.getConnectionID());
                    while (true) {
                        try {
                            var20_23.resumeSession(this.connection.getConnectionID());
                            var3_3.log(Level.INFO, "Started ConnectionConsumer[" + this.getInterestId() + "]'s session " + this.connection.getConnectionID());
                            return var14_55;
                        }
                        catch (Throwable var21_28) {
                            var22_33 = "Exception on start ConnectionConsumer[" + this.getInterestId() + "]'s session, retry ...";
                            var3_3.log(Level.SEVERE, var22_33, var21_28);
                            var23_38 = this.closeLock;
                            synchronized (var23_38) {
                                try {
                                    this.closeLock.wait(5000L);
                                }
                                catch (InterruptedException var24_43) {
                                    // empty catch block
                                }
                            }
                            if (!this.isClosed) continue;
                        }
                        break;
                    }
                    return var14_55;
                }
                this.readQueue.clear();
                while (true) {
                    try {
                        this.registerInterest();
                        var3_3.log(Level.INFO, "Recreated ConnectionConsumer[" + var5_6 + "]: " + this.getInterestId());
                        var2_2 = true;
                    }
                    catch (Throwable var12_50) {
                        var3_3.log(Level.SEVERE, "Exception on register interest to recreate ConnectionConsumer[" + var5_6 + "], retry ...", var12_50);
                        try {
                            this.deregisterInterest();
                        }
                        catch (Throwable var13_54) {
                            // empty catch block
                        }
                        this.readQueue.clear();
                        var13_53 = this.closeLock;
                        synchronized (var13_53) {
                            try {
                                this.closeLock.wait(5000L);
                            }
                            catch (InterruptedException var14_56) {
                                // empty catch block
                            }
                        }
                        if (!this.isClosed && !this.failoverInProgress) continue;
                    }
                    break;
                }
                var12_48 = this.closeLock;
                synchronized (var12_48) {
                    this.checkState();
                    if (this.failoverInProgress) {
                        throw new JMSException("Connection recovery in progress");
                    }
                }
                this.setRecreationInProgress2(false);
lbl145:
                // 2 sources

                var6_7 = this.recreationLock;
                synchronized (var6_7) {
                    if (this.interestIdToBeRecreated != null) ** break block69
                    var7_11 = var2_2;
                }
                var19_19 = null;
                this.setRecreationInProgress1(false);
                this.setRecreationInProgress2(false);
                if (var4_5 == false) return var7_11;
                var20_24 = this.connection.getProtocolHandler();
                var3_3.log(Level.INFO, "Start ConnectionConsumer[" + this.getInterestId() + "]'s session " + this.connection.getConnectionID());
                ** GOTO lbl189
                {
                    if (this.interestIdToBeRecreated.equals(var1_1)) {
                        this.interestIdToBeRecreated = null;
                    }
                }
                var6_8 = var2_2;
                var19_20 = null;
                this.setRecreationInProgress1(false);
                this.setRecreationInProgress2(false);
                if (var4_5 == false) return var6_8;
                var20_25 = this.connection.getProtocolHandler();
                var3_3.log(Level.INFO, "Start ConnectionConsumer[" + this.getInterestId() + "]'s session " + this.connection.getConnectionID());
                ** GOTO lbl207
            }
        }
        catch (Throwable var18_57) {
            block70: {
                break block70;
lbl-1000:
                // 1 sources

                {
                    while (true) {
                        ** try [egrp 18[TRYBLOCK] [32 : 1133->1195)] { 
lbl173:
                        // 1 sources

                        var20_22.resumeSession(this.connection.getConnectionID());
                        var3_3.log(Level.INFO, "Started ConnectionConsumer[" + this.getInterestId() + "]'s session " + this.connection.getConnectionID());
                        return var8_13;
lbl176:
                        // 1 sources

                        catch (Throwable var21_27) {
                            block71: {
                                var22_32 = "Exception on start ConnectionConsumer[" + this.getInterestId() + "]'s session, retry ...";
                                var3_3.log(Level.SEVERE, var22_32, var21_27);
                                var23_37 = this.closeLock;
                                synchronized (var23_37) {
                                    ** try [egrp 20[TRYBLOCK] [33 : 1245->1258)] { 
lbl182:
                                    // 1 sources

                                    this.closeLock.wait(5000L);
                                    break block71;
lbl184:
                                    // 1 sources

                                    catch (InterruptedException var24_42) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (!this.isClosed) continue;
                        }
                        break;
                    }
                    return var8_13;
lbl189:
                    // 1 sources

                    while (true) {
                        ** try [egrp 18[TRYBLOCK] [32 : 1133->1195)] { 
lbl191:
                        // 1 sources

                        var20_24.resumeSession(this.connection.getConnectionID());
                        var3_3.log(Level.INFO, "Started ConnectionConsumer[" + this.getInterestId() + "]'s session " + this.connection.getConnectionID());
                        return var7_11;
lbl194:
                        // 1 sources

                        catch (Throwable var21_29) {
                            block72: {
                                var22_34 = "Exception on start ConnectionConsumer[" + this.getInterestId() + "]'s session, retry ...";
                                var3_3.log(Level.SEVERE, var22_34, var21_29);
                                var23_39 = this.closeLock;
                                synchronized (var23_39) {
                                    ** try [egrp 20[TRYBLOCK] [33 : 1245->1258)] { 
lbl200:
                                    // 1 sources

                                    this.closeLock.wait(5000L);
                                    break block72;
lbl202:
                                    // 1 sources

                                    catch (InterruptedException var24_44) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (!this.isClosed) continue;
                        }
                        break;
                    }
                    return var7_11;
lbl207:
                    // 1 sources

                    while (true) {
                        ** try [egrp 18[TRYBLOCK] [32 : 1133->1195)] { 
lbl209:
                        // 1 sources

                        var20_25.resumeSession(this.connection.getConnectionID());
                        var3_3.log(Level.INFO, "Started ConnectionConsumer[" + this.getInterestId() + "]'s session " + this.connection.getConnectionID());
                        return var6_8;
lbl212:
                        // 1 sources

                        catch (Throwable var21_30) {
                            block73: {
                                var22_35 = "Exception on start ConnectionConsumer[" + this.getInterestId() + "]'s session, retry ...";
                                var3_3.log(Level.SEVERE, var22_35, var21_30);
                                var23_40 = this.closeLock;
                                synchronized (var23_40) {
                                    ** try [egrp 20[TRYBLOCK] [33 : 1245->1258)] { 
lbl218:
                                    // 1 sources

                                    this.closeLock.wait(5000L);
                                    break block73;
lbl220:
                                    // 1 sources

                                    catch (InterruptedException var24_45) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (!this.isClosed) continue;
                        }
                        break;
                    }
                    return var6_8;
                }
            }
            var19_21 = null;
            this.setRecreationInProgress1(false);
            this.setRecreationInProgress2(false);
            if (var4_5 == false) throw var18_57;
            var20_26 = this.connection.getProtocolHandler();
            var3_3.log(Level.INFO, "Start ConnectionConsumer[" + this.getInterestId() + "]'s session " + this.connection.getConnectionID());
            while (true) {
                try {}
                catch (Throwable var21_31) {
                    block74: {
                        var22_36 = "Exception on start ConnectionConsumer[" + this.getInterestId() + "]'s session, retry ...";
                        var3_3.log(Level.SEVERE, var22_36, var21_31);
                        var23_41 = this.closeLock;
                        synchronized (var23_41) {
                            ** try [egrp 20[TRYBLOCK] [33 : 1245->1258)] { 
lbl240:
                            // 1 sources

                            this.closeLock.wait(5000L);
                            break block74;
lbl242:
                            // 1 sources

                            catch (InterruptedException var24_46) {
                                // empty catch block
                            }
                        }
                    }
                    if (!this.isClosed) continue;
                    throw var18_57;
                }
                var20_26.resumeSession(this.connection.getConnectionID());
                var3_3.log(Level.INFO, "Started ConnectionConsumer[" + this.getInterestId() + "]'s session " + this.connection.getConnectionID());
                throw var18_57;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRecreationInProgress1(boolean bl) {
        Object object = this.recreationLock;
        synchronized (object) {
            this.recreationInProgress1 = bl;
            if (!bl) {
                this.recreationLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRecreationInProgress2(boolean bl) {
        Object object = this.recreationLock;
        synchronized (object) {
            this.recreationInProgress2 = bl;
            if (!bl) {
                this.recreationLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisteredXAResource() {
        Object object = this.closeLock;
        synchronized (object) {
            this.closeLock.notifyAll();
        }
    }

    protected void sessionClosed(SessionImpl sessionImpl) {
        this.seenSessions.remove(sessionImpl);
    }

    protected void onNullMessage() throws JMSException {
        if (this.isClosed) {
            return;
        }
        this.recreateIfNecessary();
    }

    protected void onMessage(MessageImpl messageImpl) throws JMSException {
        if (this.recreateIfNecessary()) {
            return;
        }
        if (this.session == null) {
            this.serverSession = this.serverSessionPool.getServerSession();
            try {
                this.session = (SessionImpl)((Object)this.serverSession.getSession());
                if (this.session.getConnection() != this.connection) {
                    String string = AdministeredObject.cr.getKString("C4029");
                    throw new JMSException(string, "C4029");
                }
                if (this.session.getMessageListener() == null) {
                    String string = AdministeredObject.cr.getKString("C4029");
                    throw new IllegalStateException(string, "C4029");
                }
            }
            catch (JMSException jMSException) {
                if (this.session != null && this.serverSession instanceof ServerSession) {
                    ((ServerSession)this.serverSession).destroy();
                }
                this.session = null;
                this.serverSession = null;
                throw jMSException;
            }
        }
        messageImpl.setSession(this.session);
        this.session.loadMessageToServerSession(messageImpl, this.serverSession, this.isDMQConsumer);
        if (this.session instanceof XASessionImpl) {
            XAResourceImpl xAResourceImpl = (XAResourceImpl)((XASessionImpl)this.session).getXAResource();
            xAResourceImpl.setConnectionConsumer(this);
            this.session.setConnectionConsumer(this);
            if (!this.seenSessions.contains(this.session)) {
                this.seenSessions.add(this.session);
            }
        }
    }

    protected void startServerSession() throws JMSException {
        if (this.serverSession != null) {
            this.serverSession.start();
            this.serverSession = null;
            this.session = null;
        }
    }

    protected int getMaxMessages() {
        return this.maxMessages;
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this.serverSessionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        Object object = this.closeLock;
        synchronized (object) {
            this.isClosed = true;
            this.closeLock.notifyAll();
        }
        this.reader.close();
        long l = 0L;
        Object object2 = this.recreationLock;
        synchronized (object2) {
            while (this.recreationInProgress1) {
                if (l % 15000L == 0L) {
                    l = 0L;
                    ConnectionImpl.connectionLogger.log(Level.INFO, "Waiting for ConnectionConsumer[" + this.getInterestId() + "] reader thread completion ...");
                }
                try {
                    this.recreationLock.wait(5000L);
                    l += 5000L;
                }
                catch (Exception exception) {}
            }
        }
        this.removeInterest();
        this.connection.removeFromReadQTable(this.readQueueId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFailoverInprogress(boolean bl) {
        Object object = this.closeLock;
        synchronized (object) {
            this.failoverInProgress = bl;
            this.closeLock.notifyAll();
            if (!bl) {
                return;
            }
        }
        long l = 0L;
        Object object2 = this.recreationLock;
        synchronized (object2) {
            while (this.recreationInProgress2) {
                if (l % 15000L == 0L) {
                    l = 0L;
                    ConnectionImpl.connectionLogger.log(Level.INFO, "Waiting for reader thread completes recreation of ConnectionConsumer[" + this.getInterestId() + "] ...");
                }
                try {
                    this.recreationLock.wait(5000L);
                    l += 5000L;
                }
                catch (Exception exception) {}
            }
        }
        this.readQueue.clear();
    }

    protected void stop() {
        this.readQueue.stop(false);
    }

    protected void start() {
        this.readQueue.start();
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ ConnectionConsumerImpl dump ------");
        printStream.println("Interest ID: " + this.getInterestId());
        printStream.println("is registered: " + this.getIsRegistered());
        printStream.println("is durable: " + this.getDurable());
        if (this.durable) {
            printStream.println("durableName: " + this.getDurableName());
        }
        printStream.println("destination: " + this.getDestination());
        printStream.println("selector: " + this.messageSelector);
        printStream.println("maxMessages: " + this.maxMessages);
    }

    protected Hashtable getDebugState(boolean bl) {
        Hashtable hashtable = super.getDebugState(bl);
        hashtable.put("maxMessages", String.valueOf(this.maxMessages));
        hashtable.put("recreationInProgress1", this.recreationInProgress1);
        hashtable.put("recreationInProgress2", this.recreationInProgress2);
        hashtable.put("failoverInProgress", this.failoverInProgress);
        Long l = this.interestIdToBeRecreated;
        hashtable.put("interestIdToBeRecreated", String.valueOf(l == null ? "null" : Long.valueOf(l)));
        int n = this.seenSessions.size();
        hashtable.put("#seenSessions", String.valueOf(n));
        int n2 = XAResourceMap.hasXAResourceForCC(this, false);
        hashtable.put("#xaresourcesInFlight", String.valueOf(n2));
        return hashtable;
    }
}

