/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterNewMasterBrokerPrepareInfo {
    private ArrayList<ChangeRecordInfo> records = null;
    private Long xid = null;
    private String uuid = null;
    private BrokerAddress newmaster = null;
    Cluster c = null;
    private GPacket pkt = null;

    private ClusterNewMasterBrokerPrepareInfo(BrokerAddress brokerAddress, ArrayList<ChangeRecordInfo> arrayList, Long l, Cluster cluster) {
        this.records = arrayList;
        this.xid = l;
        this.c = cluster;
        this.newmaster = brokerAddress;
        this.uuid = UUID.randomUUID().toString();
    }

    private ClusterNewMasterBrokerPrepareInfo(GPacket gPacket, Cluster cluster) {
        this.pkt = gPacket;
        this.c = cluster;
    }

    public static ClusterNewMasterBrokerPrepareInfo newInstance(BrokerAddress brokerAddress, ArrayList<ChangeRecordInfo> arrayList, Long l, Cluster cluster) {
        return new ClusterNewMasterBrokerPrepareInfo(brokerAddress, arrayList, l, cluster);
    }

    public static ClusterNewMasterBrokerPrepareInfo newInstance(GPacket gPacket, Cluster cluster) {
        return new ClusterNewMasterBrokerPrepareInfo(gPacket, cluster);
    }

    public GPacket getGPacket() throws Exception {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)51);
        gPacket.putProp("TS", new Long(System.currentTimeMillis()));
        gPacket.putProp("C", new Integer(this.records.size()));
        gPacket.putProp("X", this.xid);
        gPacket.putProp("UUID", this.uuid);
        this.c.marshalBrokerAddress(this.newmaster, gPacket);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < this.records.size(); ++i) {
            byte[] byArray = this.records.get(i).getRecord();
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        gPacket.setPayload(ByteBuffer.wrap(byArray));
        gPacket.setBit(1, true);
        return gPacket;
    }

    public String getUUID() {
        if (this.pkt != null) {
            return (String)this.pkt.getProp("UUID");
        }
        return this.uuid;
    }

    public BrokerAddress getNewMasterBroker() throws Exception {
        assert (this.pkt != null);
        this.newmaster = this.c.unmarshalBrokerAddress(this.pkt);
        return this.newmaster;
    }

    public int getRecordCount() {
        assert (this.pkt != null);
        return (Integer)this.pkt.getProp("C");
    }

    public Long getXid() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp("X");
    }

    public Long getTimestamp() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp("TS");
    }

    public byte[] getRecords() {
        assert (this.pkt != null);
        int n = this.getRecordCount();
        byte[] byArray = null;
        if (this.pkt.getPayload() != null) {
            byArray = this.pkt.getPayload().array();
        }
        return byArray;
    }

    public GPacket getReplyGPacket(int n, String string) {
        assert (this.pkt != null);
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)52);
        gPacket.putProp("X", (Long)this.pkt.getProp("X"));
        gPacket.putProp("S", new Integer(n));
        if (string != null) {
            gPacket.putProp("reason", string);
        }
        return gPacket;
    }

    public String toString() {
        if (this.pkt == null) {
            return "[newMasterBroker=" + this.newmaster + ", records=" + this.records.size() + ", xid=" + this.xid + ", uuid=" + this.uuid + "]";
        }
        return (this.newmaster == null ? "" : "[newMasterBroker=" + this.newmaster) + ", records=" + this.getRecordCount() + ", xid=" + this.getXid() + ", ts=" + this.getTimestamp() + ", uuid=" + this.getUUID() + "]";
    }

    public static Long getReplyPacketXid(GPacket gPacket) {
        return (Long)gPacket.getProp("X");
    }
}

