/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.util;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.service.PortMapper;
import com.sun.messaging.jmq.util.log.LogHandler;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

public class DestinationLogHandler
extends LogHandler {
    static boolean open = false;
    private static int DESTINATION_BEHAVIOR = 1;
    private String topic = "";
    private Destination destination = null;
    private boolean persist = false;
    private int ttl = 300;
    private int capacity = 100;

    public synchronized void configure(Properties properties, String string) throws IllegalArgumentException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        string3 = (string = string + ".") + "capacity";
        string2 = properties.getProperty(string3);
        if (string2 != null) {
            try {
                this.capacity = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string4 = rb.getString("S2000", string3, string2);
            }
        }
        if ((string2 = properties.getProperty(string3 = string + "topic")) != null) {
            this.topic = string2;
        }
        if ((string2 = properties.getProperty(string3 = string + "timetolive")) != null) {
            try {
                this.ttl = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string4 = rb.getString("S2000", string3, string2);
            }
        }
        if ((string2 = properties.getProperty(string3 = string + "persist")) != null) {
            this.persist = string2.equals("true");
        }
        if ((string2 = properties.getProperty(string3 = string + "output")) != null) {
            try {
                this.setLevels(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string4 = (string4 != null ? string4 + "\n" : "") + string3 + ": " + illegalArgumentException.getMessage();
            }
        }
        if (string4 != null) {
            throw new IllegalArgumentException(string4);
        }
        if (open) {
            this.close();
        }
        this.open();
    }

    public void publish(int n, String string) throws IOException {
        if (n == 64 && !this.isAllowForceMessage()) {
            return;
        }
        if (!open) {
            return;
        }
        if (BrokerStateHandler.shuttingDown) {
            return;
        }
        try {
            this.destination = Destination.getLoadedDestination(this.topic, false);
            if (this.destination == null) {
                return;
            }
            if (this.destination.getCapacity() != this.capacity) {
                this.destination.setCapacity(this.capacity);
            }
            if (this.destination.getLimitBehavior() != DESTINATION_BEHAVIOR) {
                this.destination.setLimitBehavior(DESTINATION_BEHAVIOR);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Could not get or configure logging destination \"" + this.topic + "\". Closing destination logger: " + exception);
            iOException.initCause(exception);
            this.close();
            throw iOException;
        }
        if (this.destination.getActiveConsumerCount() <= 0) {
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        long l = System.currentTimeMillis();
        PortMapper portMapper = Globals.getPortMapper();
        int n2 = 0;
        if (portMapper != null) {
            n2 = portMapper.getPort();
        }
        hashtable.put("broker", Globals.getMQAddress().getHostName() + ":" + n2);
        hashtable.put("brokerInstance", Globals.getConfigName());
        hashtable.put("type", this.topic);
        hashtable.put("timestamp", new Long(l));
        hashtable2.put("level", Logger.levelIntToStr(n));
        hashtable2.put("text", string);
        try {
            Packet packet = new Packet(false);
            packet.setProperties(hashtable);
            packet.setPacketType(3);
            packet.setDestination(this.topic);
            packet.setPriority(5);
            packet.setIP(Globals.getBrokerInetAddress().getAddress());
            packet.setPort(n2);
            packet.updateSequenceNumber();
            packet.updateTimestamp();
            packet.generateSequenceNumber(false);
            packet.generateTimestamp(false);
            packet.setIsQueue(false);
            packet.setTransactionID(0L);
            packet.setSendAcknowledge(false);
            packet.setPersistent(this.persist);
            packet.setExpiration(this.ttl == 0 ? 0L : l + (long)this.ttl);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(hashtable2);
            objectOutputStream.flush();
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            objectOutputStream.close();
            byteArrayOutputStream.close();
            packet.setMessageBody(byArray);
            PacketReference packetReference = PacketReference.createReference(packet, null);
            this.destination.queueMessage(packetReference, false);
            Set set = this.destination.routeNewMessage(packetReference);
            this.destination.forwardMessage(set, packetReference);
        }
        catch (Exception exception) {
            this.close();
            Globals.getLogger().log(32, "Destination logger: Can't log to destination: " + this.topic, exception);
            Globals.getLogger().log(32, "Closing destination logger.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!open) {
                open = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (open) {
                open = false;
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.topic;
    }
}

