/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Dimension;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.KeyEvent;
import charvax.swing.JComponent;
import charvax.swing.SwingUtilities;

public class JProgressBar
extends JComponent {
    protected int _minimum = 0;
    protected int _value = 0;
    protected int _maximum = 100;
    protected boolean _stringPainted = false;
    protected String _string = "";
    protected int _width = 50;
    protected boolean _indeterminate;
    protected Thread _indeterminateThread;

    public JProgressBar() {
    }

    public JProgressBar(int min_, int max_) {
        this._minimum = min_;
        this._maximum = max_;
    }

    public void setMinimum(int min_) {
        this._minimum = min_;
        if (this._maximum <= this._minimum) {
            this._maximum = this._minimum + 1;
        }
        if (this._value < this._minimum) {
            this._value = this._minimum;
        }
    }

    public void setValue(int value_) {
        this._value = value_ < this._minimum ? this._minimum : value_;
        this.repaint();
    }

    public void setProgressMax(int theMax) {
        this.setMaximum(theMax);
    }

    public void setMaximum(int max_) {
        this._maximum = max_;
        if (this._minimum > this._maximum) {
            this._minimum = this._maximum - 1;
        }
        if (this._value > this._maximum) {
            this._value = this._maximum;
        }
    }

    public void setSize(Dimension size_) {
        this._width = size_.width;
        if (this._width < 3) {
            throw new IllegalArgumentException("length of progress bar must be at least 3");
        }
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        Insets insets = super.getInsets();
        return this._width + insets.left + insets.right;
    }

    public int getHeight() {
        Insets insets = super.getInsets();
        return 1 + insets.top + insets.bottom;
    }

    public void draw() {
        super.draw();
        Point origin = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        origin.translate(insets.left, insets.top);
        Toolkit term = Toolkit.getDefaultToolkit();
        int colorpair = this.getCursesColor();
        int offset = (this._value - this._minimum) * this._width / this._maximum;
        if (!this.isIndeterminate()) {
            for (int i = 0; i < offset; ++i) {
                term.setCursor(origin.addOffset(i, 0));
                term.addChar(32, Toolkit.A_REVERSE, colorpair);
            }
            for (int k = offset; k < this._width; ++k) {
                term.setCursor(origin.addOffset(k, 0));
                term.addChar(Toolkit.ACS_CKBOARD, 0, colorpair);
            }
        } else {
            for (int i = 0; i < this._width; ++i) {
                term.setCursor(origin.addOffset(i, 0));
                term.addChar(Toolkit.ACS_CKBOARD, 0, colorpair);
            }
            term.setCursor(origin.addOffset(offset, 0));
            term.addChar(32, Toolkit.A_REVERSE, colorpair);
        }
        if (this.isStringPainted()) {
            offset = (this.getSize().width - this._string.length()) / 2;
            term.setCursor(origin.addOffset(offset, 0));
            term.addString(this._string, 0, colorpair);
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void processKeyEvent(KeyEvent ke_) {
    }

    public void requestFocus() {
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println("JProgressBar origin=" + this._origin + " size=" + this.getSize() + " value=" + this._value + " minimum=" + this._minimum + " maximum=" + this._maximum);
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public int getMinimum() {
        return this._minimum;
    }

    public int getValue() {
        return this._value;
    }

    public int getMaximum() {
        return this._maximum;
    }

    public boolean isStringPainted() {
        return this._stringPainted;
    }

    public void setStringPainted(boolean stringPainted_) {
        this._stringPainted = stringPainted_;
    }

    public void setString(String string_) {
        this._string = string_;
        this.repaint();
    }

    public void setIndeterminate(boolean newval) {
        if (newval == this._indeterminate) {
            return;
        }
        this._indeterminate = newval;
        if (newval) {
            this.setMinimum(0);
            this.setMaximum(100);
            this._indeterminateThread = new IndeterminateThread();
            this._indeterminateThread.start();
        } else if (this._indeterminateThread != null && this._indeterminateThread.isAlive()) {
            this._indeterminateThread.interrupt();
        }
    }

    public boolean isIndeterminate() {
        return this._indeterminate;
    }

    public String getString() {
        return this._string;
    }

    public void finalize() {
        if (this._indeterminateThread != null && this._indeterminateThread.isAlive()) {
            this._indeterminateThread.interrupt();
        }
    }

    private class IndeterminateThread
    extends Thread {
        boolean _right = true;
        int _percent = 0;

        private IndeterminateThread() {
        }

        public void run() {
            try {
                while (true) {
                    this.adjust();
                    Thread.sleep(500L);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (JProgressBar.this._indeterminate) {
                                JProgressBar.this.setValue(IndeterminateThread.this._percent);
                            }
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }

        private void adjust() {
            if (this._right) {
                if (this._percent < 96) {
                    this._percent += 4;
                } else {
                    this._right = false;
                }
            } else if (this._percent > 0) {
                this._percent -= 4;
            } else {
                this._right = true;
            }
        }
    }
}

