/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.JDKSelection.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.JDKSelection.utils.SystemUtils;
import org.openinstaller.util.JDKSelection.utils.exceptions.ParseException;
import org.openinstaller.util.JDKSelection.utils.helper.DependencyType;
import org.openinstaller.util.JDKSelection.utils.helper.Platform;
import org.openinstaller.util.JDKSelection.utils.helper.Status;

public abstract class StringUtils {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    public static final String BACK_SLASH = "\\";
    public static final String FORWARD_SLASH = "/";
    public static final String DOUBLE_BACK_SLASH = "\\\\";
    public static final String CR = "\r";
    public static final String LF = "\n";
    public static final String DOT = ".";
    public static final String EMPTY_STRING = "";
    public static final String CRLF = "\r\n";
    public static final String CRLFCRLF = "\r\n\r\n";
    public static final String SPACE = " ";
    public static final String QUOTE = "\"";
    public static final String NEW_LINE_PATTERN = "(?:\r\n|\n|\r)";
    private static final char[] BASE64_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] BASE64_REVERSE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final char BASE64_PAD = '=';
    private static final int BIN_11111111 = 255;
    private static final int BIN_00110000 = 48;
    private static final int BIN_00111100 = 60;
    private static final int BIN_00111111 = 63;

    public static String format(String message, Object ... arguments) {
        return MessageFormat.format(message, arguments);
    }

    public static String capitalizeFirst(String string) {
        return EMPTY_STRING + Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String asString(Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public static String asString(List<? extends Object> objects, String separator) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < objects.size(); ++i) {
            result.append(objects.get(i).toString());
            if (i == objects.size() - 1) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static String asString(Object[] strings, String separator) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            result.append(strings[i] == null ? EMPTY_STRING + null : strings[i].toString());
            if (i == strings.length - 1) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static List<String> asList(String string, String separator) {
        return Arrays.asList(string.split(separator));
    }

    public static String asHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            String byteHex = Integer.toHexString(b);
            if (byteHex.length() == 1) {
                byteHex = "0" + byteHex;
            }
            if (byteHex.length() > 2) {
                byteHex = byteHex.substring(byteHex.length() - 2);
            }
            builder.append(byteHex);
        }
        return builder.toString();
    }

    public static String base64Encode(String string, String charset) throws UnsupportedEncodingException {
        int byte2;
        int byte1;
        int i;
        StringBuilder builder = new StringBuilder();
        byte[] bytes = string.getBytes(charset);
        for (i = 0; i < bytes.length - 2; i += 3) {
            byte1 = bytes[i] & 0xFF;
            byte2 = bytes[i + 1] & 0xFF;
            int byte3 = bytes[i + 2] & 0xFF;
            builder.append(BASE64_TABLE[byte1 >> 2]);
            builder.append(BASE64_TABLE[byte1 << 4 & 0x30 | byte2 >> 4]);
            builder.append(BASE64_TABLE[byte2 << 2 & 0x3C | byte3 >> 6]);
            builder.append(BASE64_TABLE[byte3 & 0x3F]);
        }
        if (i == bytes.length - 2) {
            byte1 = bytes[i] & 0xFF;
            byte2 = bytes[i + 1] & 0xFF;
            builder.append(BASE64_TABLE[byte1 >> 2]);
            builder.append(BASE64_TABLE[byte1 << 4 & 0x30 | byte2 >> 4]);
            builder.append(BASE64_TABLE[byte2 << 2 & 0x3C]);
            builder.append('=');
        }
        if (i == bytes.length - 1) {
            byte1 = bytes[i] & 0xFF;
            builder.append(BASE64_TABLE[byte1 >> 2]);
            builder.append(BASE64_TABLE[byte1 << 4 & 0x30]);
            builder.append('=');
            builder.append('=');
        }
        return builder.toString();
    }

    public static String base64Decode(String string, String charset) throws UnsupportedEncodingException {
        byte byte2;
        byte byte1;
        int completeBlocksNumber = string.length() / 4;
        int missingBytesNumber = 0;
        if (string.endsWith("=")) {
            --completeBlocksNumber;
            ++missingBytesNumber;
        }
        if (string.endsWith("==")) {
            ++missingBytesNumber;
        }
        int decodedLength = completeBlocksNumber * 3 + (3 - missingBytesNumber);
        byte[] decodedBytes = new byte[decodedLength];
        int encodedCounter = 0;
        int decodedCounter = 0;
        for (int i = 0; i < completeBlocksNumber; ++i) {
            byte byte12 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            byte byte22 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            byte byte3 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            byte byte4 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            decodedBytes[decodedCounter++] = (byte)(byte12 << 2 | byte22 >> 4);
            decodedBytes[decodedCounter++] = (byte)(byte22 << 4 | byte3 >> 2);
            decodedBytes[decodedCounter++] = (byte)(byte3 << 6 | byte4);
        }
        if (missingBytesNumber == 1) {
            byte1 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            byte2 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            byte byte3 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            decodedBytes[decodedCounter++] = (byte)(byte1 << 2 | byte2 >> 4);
            decodedBytes[decodedCounter++] = (byte)(byte2 << 4 | byte3 >> 2);
        }
        if (missingBytesNumber == 2) {
            byte1 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            byte2 = BASE64_REVERSE_TABLE[string.charAt(encodedCounter++)];
            decodedBytes[decodedCounter++] = (byte)(byte1 << 2 | byte2 >> 4);
        }
        return new String(decodedBytes, charset);
    }

    public static String pad(String string, int number) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < number; ++i) {
            builder.append(string);
        }
        return builder.toString();
    }

    public static String escapeRegExp(String string) {
        return string.replace(BACK_SLASH, DOUBLE_BACK_SLASH);
    }

    public static String readStream(InputStream stream) throws IOException {
        StringBuilder builder = new StringBuilder();
        byte[] buffer = new byte[1024];
        while (stream.available() > 0) {
            int read = stream.read(buffer);
            String readString = new String(buffer, 0, read);
            for (String string : readString.split(NEW_LINE_PATTERN)) {
                builder.append(string).append(SystemUtils.getLineSeparator());
            }
        }
        return builder.toString();
    }

    public static String parseAscii(String string) {
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(("key=" + string).getBytes()));
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Cannot parse string", e);
            return string;
        }
        return (String)properties.get("key");
    }

    public static String asPath(Class clazz) {
        return clazz.getPackage().getName().replace('.', '/');
    }

    public static Locale parseLocale(String string) {
        String[] parts = string.split("_");
        switch (parts.length) {
            case 1: {
                return new Locale(parts[0]);
            }
            case 2: {
                return new Locale(parts[0], parts[1]);
            }
        }
        return new Locale(parts[0], parts[1], parts[2]);
    }

    public static URL parseUrl(String string) throws ParseException {
        try {
            return new URL(string);
        }
        catch (MalformedURLException e) {
            throw new ParseException("Cannot parse URL", e);
        }
    }

    public static Platform parsePlatform(String string) throws ParseException {
        for (Platform platform : Platform.values()) {
            if (!platform.getName().equals(string)) continue;
            return platform;
        }
        throw new ParseException("Platform \"" + string + "\" is not recognized.");
    }

    public static List<Platform> parsePlatforms(String string) throws ParseException {
        ArrayList<Platform> platforms = new ArrayList<Platform>();
        for (String name : StringUtils.asList(string, SPACE)) {
            Platform platform = StringUtils.parsePlatform(name);
            if (platforms.contains((Object)platform)) continue;
            platforms.add(platform);
        }
        return platforms;
    }

    public static Status parseStatus(String string) throws ParseException {
        for (Status status : Status.values()) {
            if (!status.getName().equals(string)) continue;
            return status;
        }
        throw new ParseException("Cannot parse status: " + string);
    }

    public static DependencyType parseDependencyType(String string) throws ParseException {
        for (DependencyType type : DependencyType.values()) {
            if (!type.getName().equals(string)) continue;
            return type;
        }
        throw new ParseException("Cannot parse dependency type: " + string);
    }
}

