/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.desktopintegration;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.provider.conf.oor.OORAddRemoveEntry;
import org.openinstaller.provider.conf.oor.OORPathType;
import org.openinstaller.provider.conf.oor.OORRelativeType;
import org.openinstaller.provider.conf.oor.OORShortcut;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ExecuteCommand;
import org.openinstaller.util.desktopintegration.BaseDesktopIntegrator;
import org.openinstaller.util.desktopintegration.DesktopIntegrator;
import org.openinstaller.util.desktopintegration.GnomeDesktopItem;
import org.openinstaller.util.desktopintegration.MenuEditor;
import org.openinstaller.util.desktopintegration.VFolderEditor;

public class GnomeDesktopIntegrator
extends BaseDesktopIntegrator {
    private static final Logger LOGGER;
    private static DesktopIntegrator gInstance;
    public static final String USER_HOME;
    public static final String USER_NAME;
    private static final boolean IS_ROOT_USER;

    private GnomeDesktopIntegrator() {
    }

    public static DesktopIntegrator getInstance() {
        return gInstance;
    }

    @Override
    public final void createShortcut(OORShortcut aShortcut) throws EnhancedException {
        String theName = aShortcut.getName();
        String theLocation = this.convertLocationPath(aShortcut.getLocation());
        String theTarget = this.convertPath(aShortcut.getTarget());
        String theIcon = this.convertPath(aShortcut.getIcon());
        String theType = "";
        switch (aShortcut.getType()) {
            case OOR_APPLICATION: {
                theType = "Application";
                break;
            }
            case OOR_LINK: {
                theType = "Link";
                if (!new File(theTarget).isDirectory()) break;
                theType = "Application";
                theTarget = "nautilus " + theTarget;
                break;
            }
            case OOR_URL: {
                theType = "Application";
                theTarget = "gnome-open " + theTarget;
                break;
            }
            default: {
                theType = "Application";
            }
        }
        if (aShortcut.getTarget().getArgs() != null) {
            theTarget = theTarget + " " + aShortcut.getTarget().getArgs();
        }
        GnomeDesktopItem theGDI = new GnomeDesktopItem(theName, theType);
        theGDI.setIcon(theIcon);
        theGDI.setExec(theTarget);
        theGDI.setTerminal(aShortcut.isRunInTerminal());
        theGDI.setPath(GnomeDesktopIntegrator.getInstallHome());
        theGDI.setStartupNotify(true);
        String theFileStr = theLocation + "/" + this.generateUniqueFileName(theName) + ".desktop";
        LOGGER.fine("File: " + theFileStr);
        File theNewFile = new File(theFileStr);
        if (this.isStartMenuOrProgramsFolder(aShortcut.getLocation().getRelative())) {
            String theLocPath = aShortcut.getLocation().getPath();
            String[] theFolderHierarchy = this.getFolderNames(theLocPath);
            String theTail = theLocPath;
            int theLength = theFolderHierarchy.length;
            if (theLength >= 2) {
                this.createFolderHierarchy(this.getAltDirectoryFilesFolder(), theFolderHierarchy);
                theTail = theFolderHierarchy[theLength - 1];
            }
            String theCategories = "Application;" + theLocPath + ";";
            theGDI.setCategories(theCategories);
            String theDirFileName = theLocation + "/" + this.generateUniqueFileName(theTail) + ".directory";
            String theDirName = theTail + ": " + GnomeDesktopIntegrator.getInstallHome().replace('/', '|');
            String theTopLevelMenuFilePath = theLocation + "/" + theTail + ".directory";
            if (theTail != null && !"".equalsIgnoreCase(theTail)) {
                this.createDirectory(theTail, theTopLevelMenuFilePath);
                this.createDirectory(theDirName, theDirFileName);
            }
            String theAltDirFileName = this.getAltDirectoryFilesFolder() + "/" + this.generateUniqueFileName(theTail) + ".directory";
            String theAltTopLevelMenuFilePath = this.getAltDirectoryFilesFolder() + "/" + theTail + ".directory";
            if (theLocPath != null && !"".equalsIgnoreCase(theLocPath)) {
                this.createDirectory(theTail, theAltTopLevelMenuFilePath);
                this.createDirectory(theDirName, theAltDirFileName);
            }
            if (!IS_ROOT_USER) {
                String theAltFileStr = USER_HOME + "/.local/share/applications/" + this.generateUniqueFileName(theName) + ".desktop";
                File theAltFile = new File(theAltFileStr);
                this.createFileOnDisk(theAltFile, theGDI.toString());
                this.editVFolders(aShortcut, theNewFile.getAbsolutePath());
            }
            this.editMenus(aShortcut);
        }
        this.createFileOnDisk(theNewFile, theGDI.toString());
        this.refreshDesktop();
    }

    private void createFolderHierarchy(String aLocation, String[] aHierarchy) throws EnhancedException {
        for (int theIndex = 0; theIndex < aHierarchy.length - 1; ++theIndex) {
            LOGGER.finest("MENU: " + aHierarchy[theIndex]);
            String theFolderName = aHierarchy[theIndex].replace(' ', '-').toLowerCase();
            String theFilePath = aLocation + "/" + theFolderName + ".directory";
            this.createDirectory(theFolderName, theFilePath);
        }
    }

    private void deleteFolderHierarchy(String aLocation, String[] aHierarchy) throws EnhancedException {
        for (int theIndex = 0; theIndex < aHierarchy.length - 1; ++theIndex) {
            LOGGER.finest("MENU: " + aHierarchy[theIndex]);
            String theFolderName = aHierarchy[theIndex].replace(' ', '-').toLowerCase();
            String theFilePath = aLocation + "/" + theFolderName + ".directory";
            File theFile = new File(theFilePath);
            if (!theFile.exists()) continue;
            theFile.delete();
        }
    }

    private void refreshDesktop() throws EnhancedException {
        ExecuteCommand theCommand = new ExecuteCommand(new String[]{"/usr/bin/pkill", "-HUP", "gnome-panel"});
        theCommand.setWaitFor(false);
        theCommand.execute();
    }

    @Override
    public void createAddRemoveEntry(OORAddRemoveEntry aOORAddRemoveEntry) throws EnhancedException {
    }

    @Override
    public void removeAddRemoveEntry(OORAddRemoveEntry aAddRemoveEntry) throws EnhancedException {
    }

    @Override
    public final void removeShortcut(OORShortcut aShortcut) throws EnhancedException {
        try {
            String theName = aShortcut.getName();
            String theLocation = this.convertLocationPath(aShortcut.getLocation());
            String theFileStr = theLocation + "/" + this.generateUniqueFileName(theName) + ".desktop";
            LOGGER.log(Level.FINE, "About to delete file: " + theFileStr);
            File theNewFile = new File(theFileStr);
            if (theNewFile.exists()) {
                theNewFile.delete();
            }
            if (this.isStartMenuOrProgramsFolder(aShortcut.getLocation().getRelative())) {
                String theLocPath = aShortcut.getLocation().getPath();
                String[] theFolderHierarchy = this.getFolderNames(theLocPath);
                String theTail = theLocPath;
                int theLength = theFolderHierarchy.length;
                if (theLength >= 2) {
                    this.deleteFolderHierarchy(this.getAltDirectoryFilesFolder(), theFolderHierarchy);
                    theTail = theFolderHierarchy[theLength - 1];
                }
                String theFolderName = theLocPath + ": " + GnomeDesktopIntegrator.getInstallHome().replace('/', '|');
                int theStatus = 0;
                if (!IS_ROOT_USER) {
                    String theAltFileStr = USER_HOME + "/.local/share/applications/" + this.generateUniqueFileName(theName) + ".desktop";
                    File theAltFile = new File(theAltFileStr);
                    if (theAltFile.exists()) {
                        theAltFile.delete();
                    }
                    File theFile = new File(USER_HOME + "/.gnome2/vfolders/applications.vfolder-info");
                    VFolderEditor theEditor = new VFolderEditor(theFile);
                    theStatus = theEditor.removeShortcutEntry(theLocPath, theFolderName, theNewFile.getAbsolutePath());
                }
                if (theLocPath != null && !"".equalsIgnoreCase(theLocPath) && theStatus >= 1) {
                    String theDirStr = theLocation + "/" + this.generateUniqueFileName(theLocPath) + ".directory";
                    String theAltDirStr = this.getAltDirectoryFilesFolder() + "/" + this.generateUniqueFileName(theLocPath) + ".directory";
                    LOGGER.fine("Deleting Directory: " + theDirStr);
                    File theDirFile = new File(theDirStr);
                    if (theDirFile.exists()) {
                        theDirFile.delete();
                    }
                    LOGGER.fine("Deleting Directory: " + theAltDirStr);
                    theDirFile = new File(theAltDirStr);
                    if (theDirFile.exists()) {
                        theDirFile.delete();
                    }
                    if (theStatus == 2) {
                        theDirStr = theLocation + "/" + theLocPath + ".directory";
                        theAltDirStr = this.getAltDirectoryFilesFolder() + "/" + theLocPath + ".directory";
                        LOGGER.fine("Deleting Top level Directory: " + theDirStr);
                        theDirFile = new File(theDirStr);
                        if (theDirFile.exists()) {
                            theDirFile.delete();
                        }
                        LOGGER.fine("Deleting Top level Directory: " + theAltDirStr);
                        theDirFile = new File(theAltDirStr);
                        if (theDirFile.exists()) {
                            theDirFile.delete();
                        }
                    }
                }
                String theMenuFileStr = this.getMenuFilesFolder() + "/" + theLocPath + ".menu";
                File theMenuFile = new File(theMenuFileStr);
                MenuEditor theMenuEd = new MenuEditor(theMenuFile);
                theMenuEd.removeShortcutEntry(theLocPath, theFolderName, theNewFile.getName());
            }
        }
        catch (Exception e) {
            throw new EnhancedException(e);
        }
        this.refreshDesktop();
    }

    @Override
    public String getDesktopFolder() throws EnhancedException {
        return USER_HOME + "/Desktop";
    }

    @Override
    public String getAllUsersDesktopFolder() throws EnhancedException {
        return "";
    }

    @Override
    public String getStartMenuFolder() throws EnhancedException {
        if (IS_ROOT_USER) {
            return "/usr/share/applications";
        }
        return USER_HOME + "/.gnome2/vfolders/applications";
    }

    @Override
    public String getAllUsersStartMenuFolder() throws EnhancedException {
        if (IS_ROOT_USER) {
            return "/usr/share/applications";
        }
        return "";
    }

    @Override
    public String getProgramMenuFolder() throws EnhancedException {
        if (IS_ROOT_USER) {
            return "/usr/share/applications";
        }
        return USER_HOME + "/.gnome2/vfolders/applications";
    }

    @Override
    public String getAllUsersProgramMenuFolder() throws EnhancedException {
        if (IS_ROOT_USER) {
            return "/usr/share/applications";
        }
        return "";
    }

    public String convertLocationPath(OORPathType aPathType) throws EnhancedException {
        String theFilePath = aPathType.getPath();
        OORRelativeType theLocationRelative = aPathType.getRelative();
        if (theFilePath == null) {
            if (theLocationRelative != null) {
                theFilePath = "";
            } else {
                throw new EnhancedException("INVALID_SHORTCUT_DESCRIPTION", new String[0]);
            }
        }
        LOGGER.fine("The relative type is " + theLocationRelative);
        String theConvertedPath = "";
        if (theLocationRelative == null) {
            theConvertedPath = new File(theFilePath).getAbsolutePath();
        }
        switch (theLocationRelative) {
            case OOR_USER_DESKTOP_FOLDER: {
                theConvertedPath = new File(this.getDesktopFolder()).getAbsolutePath();
                break;
            }
            case OOR_ALL_DESKTOP_FOLDER: {
                theConvertedPath = new File(this.getAllUsersDesktopFolder()).getAbsolutePath();
                break;
            }
            case OOR_USER_PROGRAM_MENU: {
                theConvertedPath = new File(this.getProgramMenuFolder()).getAbsolutePath();
                break;
            }
            case OOR_ALL_PROGRAM_MENU: {
                theConvertedPath = new File(this.getAllUsersProgramMenuFolder()).getAbsolutePath();
                break;
            }
            case OOR_USER_START_MENU: {
                theConvertedPath = new File(this.getStartMenuFolder()).getAbsolutePath();
                break;
            }
            case OOR_ALL_START_MENU: {
                theConvertedPath = new File(this.getAllUsersStartMenuFolder()).getAbsolutePath();
                break;
            }
            case OOR_INSTALL_HOME: {
                theConvertedPath = new File(GnomeDesktopIntegrator.getInstallHome(), theFilePath).getAbsolutePath();
                break;
            }
            case OOR_NONE: {
                theConvertedPath = new File(theFilePath).getAbsolutePath();
                break;
            }
        }
        return theConvertedPath;
    }

    private String getAltDirectoryFilesFolder() {
        if (IS_ROOT_USER) {
            return "/usr/share/desktop-directories";
        }
        return USER_HOME + "/.local/share/desktop-directories";
    }

    private String getMenuFilesFolder() {
        if (IS_ROOT_USER) {
            return "/etc/xdg/menus/applications-merged";
        }
        return USER_HOME + "/.config/menus/applications-merged";
    }

    private boolean isStartMenuOrProgramsFolder(OORRelativeType aLoc) {
        return OORRelativeType.OOR_USER_START_MENU.equals((Object)aLoc) || OORRelativeType.OOR_ALL_START_MENU.equals((Object)aLoc) || OORRelativeType.OOR_USER_PROGRAM_MENU.equals((Object)aLoc) || OORRelativeType.OOR_ALL_PROGRAM_MENU.equals((Object)aLoc);
    }

    private String[] getFolderNames(String aFolders) {
        String[] theFolders = null;
        StringTokenizer theTokenizer = new StringTokenizer(aFolders, "/");
        theFolders = new String[theTokenizer.countTokens()];
        int theIndex = 0;
        while (theTokenizer.hasMoreTokens()) {
            theFolders[theIndex] = theTokenizer.nextToken();
            ++theIndex;
        }
        return theFolders;
    }

    private void createDirectory(String aDirName, String aFileName) throws EnhancedException {
        LOGGER.fine("Directory: " + aFileName);
        File theNewFile = new File(aFileName);
        if (!theNewFile.getParentFile().exists()) {
            theNewFile.getParentFile().mkdirs();
        }
        if (!theNewFile.exists()) {
            GnomeDesktopItem theGDI = new GnomeDesktopItem(aDirName, "Directory");
            this.createFileOnDisk(theNewFile, theGDI.toString());
            LOGGER.log(Level.FINE, "Created " + theNewFile.getAbsolutePath());
        }
    }

    private void createFileOnDisk(File aFile, String aFileContents) throws EnhancedException {
        try {
            if (aFile.exists()) {
                aFile.delete();
            }
            if (!aFile.getParentFile().exists()) {
                aFile.getParentFile().mkdirs();
            }
            aFile.createNewFile();
            FileWriter theFileWriter = new FileWriter(aFile);
            theFileWriter.write(aFileContents);
            theFileWriter.close();
            ArrayList<String> theCommand = new ArrayList<String>();
            theCommand.add("chmod");
            theCommand.add("755");
            theCommand.add(aFile.getAbsolutePath());
            ExecuteCommand theExec = new ExecuteCommand(theCommand.toArray(new String[0]));
            theExec.execute();
        }
        catch (IOException e) {
            throw new EnhancedException(e);
        }
    }

    private String generateUniqueFileName(String aName) throws EnhancedException {
        StringBuilder theFileName = new StringBuilder("");
        String theShortcutName = aName.replace(' ', '-').toLowerCase();
        String theInstallHome = GnomeDesktopIntegrator.getInstallHome().replace('/', '-').toLowerCase();
        theFileName.append(theShortcutName).append(theInstallHome);
        LOGGER.log(Level.FINEST, "Unique File Name: " + theFileName.toString());
        return theFileName.toString();
    }

    private void editVFolders(OORShortcut aShortcut, String aFilePath) throws EnhancedException {
        String theLocPath = aShortcut.getLocation().getPath();
        String theDirName = theLocPath + ": " + GnomeDesktopIntegrator.getInstallHome().replace('/', '|');
        File theFile = new File(USER_HOME + "/.gnome2/vfolders/applications.vfolder-info");
        LOGGER.log(Level.FINE, "Vfolder file: " + theFile.getAbsolutePath());
        VFolderEditor theEditor = new VFolderEditor(theFile);
        try {
            if (!theFile.exists()) {
                theFile.createNewFile();
                theEditor.createNewVfolderInfoFile(USER_HOME);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "Could not create new vfolder-info file.");
            LOGGER.log(Level.WARNING, "SHORTCUT_CREATION_FAILED", "shortcut=" + aShortcut.getName());
        }
        theEditor.addShortcutEntry(theLocPath, theDirName, aFilePath);
    }

    private void editMenus(OORShortcut aShortcut) throws EnhancedException {
        String theHead;
        String theLocPath = aShortcut.getLocation().getPath();
        String[] theMenuHierarchy = this.getFolderNames(theLocPath);
        String theTail = theHead = theMenuHierarchy[0];
        int theLength = theMenuHierarchy.length;
        if (theLength >= 2) {
            this.createFolderHierarchy(this.getAltDirectoryFilesFolder(), theMenuHierarchy);
            theTail = theMenuHierarchy[theLength - 1];
        }
        String[] theMenuPaths = new String[theLength];
        for (int theIndex = 0; theIndex < theLength; ++theIndex) {
            String theNewName = theMenuHierarchy[theIndex].replace(' ', '-').toLowerCase();
            theMenuPaths[theIndex] = this.getAltDirectoryFilesFolder() + "/" + theNewName + ".directory";
        }
        String theDirFileName = this.getAltDirectoryFilesFolder() + "/" + this.generateUniqueFileName(theTail) + ".directory";
        String theDirName = theTail + ": " + GnomeDesktopIntegrator.getInstallHome().replace('/', '|');
        String theFilename = this.generateUniqueFileName(aShortcut.getName()) + ".desktop";
        String theMenuName = theHead.replace(' ', '-');
        String theTailMenuName = theTail.replace(' ', '-');
        theMenuHierarchy[theLength - 1] = theDirName;
        theMenuPaths[theLength - 1] = theDirFileName;
        String theFileStr = this.getMenuFilesFolder() + "/" + theMenuName + ".menu";
        File theFile = new File(theFileStr);
        if (!theFile.getParentFile().exists()) {
            theFile.getParentFile().mkdirs();
        }
        LOGGER.log(Level.FINE, "Menu file: " + theFile.getAbsolutePath());
        MenuEditor theEditor = new MenuEditor(theFile);
        try {
            if (!theFile.exists()) {
                theFile.createNewFile();
                theEditor.createNewMenuFile(theMenuHierarchy, theMenuPaths);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "Could not create new menu file.");
            LOGGER.log(Level.WARNING, "SHORTCUT_CREATION_FAILED", "shortcut=" + aShortcut.getName());
        }
        theEditor.addShortcutEntry(theMenuHierarchy, theMenuPaths, theFilename);
    }

    static {
        gInstance = new GnomeDesktopIntegrator();
        LOGGER = Logger.getLogger(ClassUtils.getClassName());
        USER_HOME = System.getProperty("user.home");
        USER_NAME = System.getProperty("user.name");
        IS_ROOT_USER = "/".equalsIgnoreCase(USER_HOME);
    }
}

