/*
 * Decompiled with CFR 0.152.
 */
package org.chaxml;

import charva.awt.Color;
import charva.awt.Component;
import charva.awt.Dimension;
import charva.awt.Insets;
import charva.awt.LayoutManager;
import charva.awt.Point;
import charva.awt.Rectangle;
import charvax.swing.Action;
import charvax.swing.border.Border;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.chaxml.Converter;
import org.chaxml.converters.ActionConverter;
import org.chaxml.converters.BorderConverter;
import org.chaxml.converters.ColorConverter;
import org.chaxml.converters.ComponentConverter;
import org.chaxml.converters.DimensionConverter;
import org.chaxml.converters.InsetsConverter;
import org.chaxml.converters.LayoutConverter;
import org.chaxml.converters.LocaleConverter;
import org.chaxml.converters.PointConverter;
import org.chaxml.converters.PrimitiveConverter;
import org.chaxml.converters.RectangleConverter;
import org.chaxml.converters.StringConverter;

public class ConverterLibrary {
    private static ConverterLibrary instance = new ConverterLibrary();
    private Map converters = new HashMap();

    private ConverterLibrary() {
        this.registerConverters();
    }

    public static synchronized ConverterLibrary getInstance() {
        return instance;
    }

    public Map getConverters() {
        return this.converters;
    }

    private void registerConverters() {
        this.register(Action.class, new ActionConverter());
        this.register(Border.class, new BorderConverter());
        this.register(Color.class, new ColorConverter());
        this.register(Component.class, new ComponentConverter());
        this.register(Dimension.class, new DimensionConverter());
        this.register(Insets.class, new InsetsConverter());
        this.register(LayoutManager.class, new LayoutConverter());
        this.register(Locale.class, new LocaleConverter());
        this.register(Point.class, new PointConverter());
        this.register(Rectangle.class, new RectangleConverter());
        this.register(String.class, new StringConverter());
        this.register(Boolean.TYPE, new PrimitiveConverter());
        this.register(Integer.TYPE, new PrimitiveConverter());
        this.register(Long.TYPE, new PrimitiveConverter());
        this.register(Float.TYPE, new PrimitiveConverter());
        this.register(Double.TYPE, new PrimitiveConverter());
    }

    public void register(Class template, Converter converter) {
        this.converters.put(template, converter);
    }

    public boolean hasConverter(Class template) {
        boolean found = this.converters.keySet().contains(template);
        Iterator it = this.converters.keySet().iterator();
        while (!found && it != null && it.hasNext()) {
            found = template.isAssignableFrom(((Converter)this.converters.get(it.next())).convertsTo());
        }
        return found;
    }

    public Converter getConverter(Class template) {
        return (Converter)this.converters.get(template);
    }
}

