/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.conf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.NoSuchMemberException;
import org.openinstaller.provider.conf.ConfigControl;
import org.openinstaller.provider.conf.apoc.APOCCategory;
import org.openinstaller.provider.conf.apoc.APOCPage;
import org.openinstaller.provider.conf.apoc.APOCProperty;
import org.openinstaller.provider.conf.apoc.APOCSection;
import org.openinstaller.provider.conf.apoc.APOCTemplate;
import org.openinstaller.provider.conf.oor.ConfigType;
import org.openinstaller.provider.conf.oor.Constraint;
import org.openinstaller.provider.conf.oor.OORComponent;
import org.openinstaller.provider.conf.oor.OORGroup;
import org.openinstaller.provider.conf.oor.OORProp;
import org.openinstaller.provider.operation.OperationImpossibleException;
import org.openinstaller.sims.SIMSException;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.VersionRange;
import org.openinstaller.util.substitution.SubstitutionEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigHelper {
    private static final String FREEZE_THAW_SEPARATOR = ";";
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    private ConfigHelper() {
    }

    public static Object getValue(String aName) throws EnhancedException {
        return ConfigHelper.getProperty(aName).getValue();
    }

    public static boolean getBooleanValue(String aName) throws EnhancedException {
        try {
            return (Boolean)ConfigHelper.getProperty(aName).getValue();
        }
        catch (ClassCastException theEx) {
            throw new EnhancedException("TYPE_OF_VALUE_INCORRECT", (Throwable)theEx, new String[]{"name=" + aName});
        }
    }

    public static String getStringValue(String aName) throws EnhancedException {
        try {
            return (String)ConfigHelper.getProperty(aName).getValue();
        }
        catch (ClassCastException theEx) {
            throw new EnhancedException("TYPE_OF_VALUE_INCORRECT", (Throwable)theEx, new String[]{"name=" + aName});
        }
    }

    public static short getShortValue(String aName) throws EnhancedException {
        try {
            return (Short)ConfigHelper.getProperty(aName).getValue();
        }
        catch (ClassCastException theEx) {
            throw new EnhancedException("TYPE_OF_VALUE_INCORRECT", (Throwable)theEx, new String[]{"name=" + aName});
        }
    }

    public static int getIntValue(String aName) throws EnhancedException {
        try {
            return (Integer)ConfigHelper.getProperty(aName).getValue();
        }
        catch (ClassCastException theEx) {
            throw new EnhancedException("TYPE_OF_VALUE_INCORRECT", (Throwable)theEx, new String[]{"name=" + aName});
        }
    }

    public static long getLongValue(String aName) throws EnhancedException {
        try {
            return (Long)ConfigHelper.getProperty(aName).getValue();
        }
        catch (ClassCastException theEx) {
            throw new EnhancedException("TYPE_OF_VALUE_INCORRECT", (Throwable)theEx, new String[]{"name=" + aName});
        }
    }

    public static double getDoubleValue(String aName) throws EnhancedException {
        try {
            return (Double)ConfigHelper.getProperty(aName).getValue();
        }
        catch (ClassCastException theEx) {
            throw new EnhancedException("TYPE_OF_VALUE_INCORRECT", (Throwable)theEx, new String[]{"name=" + aName});
        }
    }

    public static String getHexBinaryValue(String aName) throws EnhancedException {
        try {
            return (String)ConfigHelper.getProperty(aName).getValue();
        }
        catch (ClassCastException theEx) {
            throw new EnhancedException("TYPE_OF_VALUE_INCORRECT", (Throwable)theEx, new String[]{"name=" + aName});
        }
    }

    public static List<String> getStringListType(String aName) throws EnhancedException {
        try {
            ConfigHelper.getProperty(aName);
            String[] theParts = ((String)ConfigHelper.getProperty(aName).getValue()).split(" ");
            return Arrays.asList(theParts);
        }
        catch (ClassCastException theEx) {
            throw new EnhancedException("TYPE_OF_VALUE_INCORRECT", (Throwable)theEx, new String[]{"name=" + aName});
        }
    }

    public static VersionRange[] getEncodedVersionRangesListType(String aPropName) throws EnhancedException {
        try {
            String theCompactedSeries = (String)ConfigHelper.getProperty(aPropName).getValue();
            return VersionRange.decodeVersionRanges((String)theCompactedSeries, (char)',');
        }
        catch (ClassCastException theEx) {
            throw new EnhancedException("TYPE_OF_VALUE_INCORRECT", (Throwable)theEx, new String[]{"name=" + aPropName});
        }
        catch (SIMSException theEx) {
            throw theEx;
        }
    }

    public static Object getUnconfirmedValue(String aName) throws EnhancedException {
        return ConfigHelper.getProperty(aName).getUnconfirmedValue();
    }

    public static boolean hasUnconfirmedValue(String aName) throws EnhancedException {
        return ConfigHelper.getProperty(aName).hasUnconfirmedValue();
    }

    public static String getSeparator(String aName) throws EnhancedException {
        return ConfigHelper.getProperty(aName).getSeparator();
    }

    public static Constraint setValue(String aName, Object aValue) throws EnhancedException {
        if (aValue instanceof String) {
            return ConfigHelper.getProperty(aName).setValue(ConfigHelper.thaw((String)aValue, ConfigHelper.getProperty(aName).getType()));
        }
        return ConfigHelper.getProperty(aName).setValue(aValue);
    }

    public static ConfigType getType(String aName) throws EnhancedException {
        return ConfigHelper.getProperty(aName).getType();
    }

    public static BusResponse doTrigger(String aProductName) throws EnhancedException {
        List<OORProp> theProperties = ConfigHelper.getProperties(aProductName);
        for (OORProp theProp : theProperties) {
            if (!"ONLOAD".equals(theProp.getName())) continue;
            return theProp.doAction();
        }
        return null;
    }

    public static OORProp getProperty(String aName) throws EnhancedException {
        StringTokenizer theTokenizer = new StringTokenizer(aName, ".");
        if (theTokenizer.countTokens() < 2) {
            throw new EnhancedException("NO_SUCH_PRODUCT_CONFIG", new String[]{"datapath=" + aName});
        }
        String theProduct = theTokenizer.nextToken();
        StringBuffer theGroupBuf = new StringBuffer();
        String theVarName = null;
        while (theTokenizer.hasMoreTokens()) {
            String theNextTok = theTokenizer.nextToken();
            if (theTokenizer.hasMoreTokens()) {
                theGroupBuf.append(theNextTok);
                if (theTokenizer.countTokens() <= 1) continue;
                theGroupBuf.append(".");
                continue;
            }
            theVarName = theNextTok;
        }
        String theGroupName = theGroupBuf.toString();
        OORComponent theComp = ConfigHelper.getProductFromProvider(theProduct);
        for (OORGroup theGroup : theComp.getGroups()) {
            if (!theGroup.getName().equals(theGroupName)) continue;
            for (OORProp theProp : theGroup.getProperties()) {
                if (!theProp.getName().equals(theVarName)) continue;
                return theProp;
            }
        }
        throw new EnhancedException("NO_SUCH_PRODUCT_CONFIG_ITEM", new String[]{"product=" + theProduct, "name=" + aName});
    }

    public static List<OORProp> getProperties(String aProduct) throws EnhancedException {
        OORComponent theComp = ConfigHelper.getProductFromProvider(aProduct);
        if (theComp == null) {
            throw new EnhancedException("NO_SUCH_PRODUCT_CONFIG", new String[]{"product=" + aProduct});
        }
        ArrayList<OORProp> theProps = new ArrayList<OORProp>();
        for (OORGroup theGroup : theComp.getGroups()) {
            theProps.addAll(theGroup.getProperties());
        }
        return theProps;
    }

    public static List<APOCProperty> getUIProperties(String aProduct) throws EnhancedException {
        APOCTemplate theComp = ConfigHelper.getUIProductFromProvider(aProduct);
        if (theComp == null) {
            throw new EnhancedException("NO_SUCH_PRODUCT_CONFIG", new String[]{"product=" + aProduct});
        }
        ArrayList<APOCProperty> theProps = new ArrayList<APOCProperty>();
        APOCCategory theCat = theComp.getCategory();
        if (theCat == null) {
            throw new EnhancedException("UI_MODEL_CORRUPT", new String[]{"product=" + aProduct});
        }
        APOCPage thePage = theCat.getPage();
        for (APOCSection theSection : thePage.getSections()) {
            theProps.addAll(theSection.getProperties());
        }
        return theProps;
    }

    private static OORComponent getProductFromProvider(String aProduct) throws EnhancedException {
        BusRequest theRequest = new BusRequest("CC_CONFIG", (Object)new ConfigControl(ConfigControl.ConfigCommand.GET_CONFIG_MODEL, aProduct));
        BusResponse theResponse = ControlBus.getInstance().publishRequest(theRequest, "svc://general/conf");
        if (theResponse.getResult() == null) {
            throw new EnhancedException("CONFIG_PROVIDER_CALL_FAILED", (Throwable)theResponse.getException(), new String[]{"method-failed=" + ClassUtils.getMethodName(), "product=" + aProduct});
        }
        return (OORComponent)theResponse.getResult();
    }

    private static APOCTemplate getUIProductFromProvider(String aProduct) throws EnhancedException {
        BusRequest theRequest = new BusRequest("CC_CONFIG", (Object)new ConfigControl(ConfigControl.ConfigCommand.GET_CONFIG_UI_MODEL, aProduct));
        BusResponse theResponse = ControlBus.getInstance().publishRequest(theRequest, "svc://general/conf");
        if (theResponse.getResult() == null) {
            throw new EnhancedException("CANNOT_FIND_UI_SCHEMA", (Throwable)theResponse.getException(), new String[]{"product=" + aProduct});
        }
        return (APOCTemplate)theResponse.getResult();
    }

    public static String freeze(Object aData, ConfigType aType) throws EnhancedException {
        switch (aType) {
            case OORBOOLEAN: {
                if (!(aData instanceof Boolean)) {
                    throw new EnhancedException("INVALID_OOR_TYPE", new String[]{"not-boolean=" + aData.getClass().getName()});
                }
                return ((Boolean)aData).toString();
            }
            case OORSTRING: {
                if (!(aData instanceof String)) {
                    throw new EnhancedException("INVALID_OOR_TYPE", new String[]{"not-string=" + aData.getClass().getName()});
                }
                return (String)aData;
            }
            case OORDOUBLE: {
                if (!(aData instanceof Double)) {
                    throw new EnhancedException("INVALID_OOR_TYPE", new String[]{"not-double=" + aData.getClass().getName()});
                }
                return ((Double)aData).toString();
            }
            case OORHEXBINARY: {
                throw new EnhancedException("OOR_TYPE_NOT_IMPLEMENTED", new String[]{"oor-type=OORHEXBINARY"});
            }
            case OORINT: {
                if (!(aData instanceof Integer)) {
                    throw new EnhancedException("INVALID_OOR_TYPE", new String[]{"not-integer=" + aData.getClass().getName()});
                }
                return ((Integer)aData).toString();
            }
            case OORLONG: {
                if (!(aData instanceof Long)) {
                    throw new EnhancedException("INVALID_OOR_TYPE", new String[]{"not-long=" + aData.getClass().getName()});
                }
                return ((Long)aData).toString();
            }
            case OORSHORT: {
                if (!(aData instanceof Short)) {
                    throw new EnhancedException("INVALID_OOR_TYPE", new String[]{"not-short=" + aData.getClass().getName()});
                }
                return ((Short)aData).toString();
            }
            case OORSTRINGLIST: {
                if (!(aData instanceof List)) {
                    throw new EnhancedException("INVALID_OOR_TYPE", new String[]{"not-string=" + aData.getClass().getName()});
                }
                List theTempList = (List)aData;
                StringBuffer theResult = new StringBuffer();
                for (String theEl : theTempList) {
                    theResult.append(theEl);
                    theResult.append(FREEZE_THAW_SEPARATOR);
                }
                return theResult.toString();
            }
        }
        throw new EnhancedException("OOR_TYPE_NOT_RECOGNIZED", new String[]{"oor-type=" + aType.name()});
    }

    public static Object thaw(String aFrozenData, ConfigType aType) throws EnhancedException {
        ArrayList<String> theResult;
        LOGGER.finest("Frozen: [" + aFrozenData + "]");
        LOGGER.finest("Type: [" + aType.getTypeSpecifier() + "]");
        if (aFrozenData == null) {
            return null;
        }
        try {
            switch (aType) {
                case OORBOOLEAN: {
                    theResult = Boolean.valueOf(aFrozenData);
                    break;
                }
                case OORSTRING: {
                    theResult = aFrozenData;
                    break;
                }
                case OORDOUBLE: {
                    theResult = Double.valueOf(aFrozenData);
                    break;
                }
                case OORHEXBINARY: {
                    throw new EnhancedException("OOR_TYPE_NOT_IMPLEMENTED", new String[]{"oor-type=OORHEXBINARY"});
                }
                case OORINT: {
                    theResult = Integer.valueOf(aFrozenData);
                    break;
                }
                case OORLONG: {
                    theResult = Long.valueOf(aFrozenData);
                    break;
                }
                case OORSHORT: {
                    theResult = Short.valueOf(aFrozenData);
                    break;
                }
                case OORSTRINGLIST: {
                    String[] theEls;
                    ArrayList<String> theStringList = new ArrayList<String>();
                    for (String theEl : theEls = aFrozenData.split(FREEZE_THAW_SEPARATOR)) {
                        if (theEl.trim().length() == 0) continue;
                        theStringList.add(theEl);
                    }
                    theResult = theStringList;
                    break;
                }
                default: {
                    LOGGER.finest("Error: OOR type not recognized");
                    throw new EnhancedException("OOR_TYPE_NOT_RECOGNIZED", new String[]{"oor-type=" + aType.name()});
                }
            }
        }
        catch (Exception theException) {
            LOGGER.finest("Error: Could not convert types");
            throw new EnhancedException("CANT_CONVERT_STRING_TO_CONFIG_TYPE", (Throwable)theException, new String[0]);
        }
        LOGGER.finest("Returning type " + theResult.getClass());
        return theResult;
    }

    public static Constraint setValue(String aName, String aValue) throws EnhancedException {
        OORProp theProperty = ConfigHelper.getProperty(aName);
        Constraint theConstraints = theProperty.setValue(ConfigHelper.thaw(SubstitutionEngine.resolve((String)aValue), theProperty.getType()));
        theProperty.setEval(null);
        theProperty.setEvalEngine(null);
        return theConstraints;
    }

    public static boolean canConfigure(String aName) throws EnhancedException {
        ConfigControl theControl = new ConfigControl(ConfigControl.ConfigCommand.CAN_CONFIGURE_COMPONENT, aName);
        BusRequest theReq = new BusRequest("CAN_CONFIGURE?", (Object)theControl);
        try {
            BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/conf");
            return (Boolean)theResp.getResult();
        }
        catch (NoSuchMemberException theEx) {
            throw new OperationImpossibleException("CANNOT_CONFIGURE_COMP", "component=" + aName);
        }
    }
}

