/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.conf.apoc;

import java.util.List;
import java.util.Vector;
import org.openinstaller.provider.conf.apoc.APOCCategory;
import org.openinstaller.provider.conf.apoc.APOCProperty;
import org.openinstaller.provider.conf.apoc.APOCResImport;
import org.openinstaller.provider.conf.apoc.APOCScriptHandler;
import org.openinstaller.provider.conf.apoc.APOCSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APOCTemplate {
    private final List<APOCResImport> gResImport;
    private String gName;
    private APOCCategory gCategory;

    public APOCTemplate(APOCCategory aCategory) {
        this.gCategory = aCategory;
        this.gResImport = new Vector<APOCResImport>();
    }

    public List<APOCResImport> getResImports() {
        return this.gResImport;
    }

    public APOCTemplate addResImport(APOCResImport aResImport) {
        this.gResImport.add(aResImport);
        return this;
    }

    public APOCCategory getCategory() {
        return this.gCategory;
    }

    public APOCTemplate setName(String aName) {
        this.gName = aName;
        return this;
    }

    public String getName() {
        return this.gName;
    }

    public APOCScriptHandler getHandlerForProperty(String aPropertyName) {
        if (aPropertyName == null) {
            return null;
        }
        List<APOCSection> theSections = this.getCategory().getPage().getSections();
        for (APOCSection theSection : theSections) {
            List<APOCProperty> theProperties = theSection.getProperties();
            for (APOCProperty theProperty : theProperties) {
                if (!aPropertyName.equals(theProperty.getName())) continue;
                return theProperty.getScriptHandler();
            }
        }
        return null;
    }
}

