/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.dependency;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.provider.dependency.ComponentDescriptor;
import org.openinstaller.provider.dependency.DependencyGraph;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedDependencyGraph
extends DependencyGraph {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private Map<String, List<String>> gHMapHierarchy = new HashMap<String, List<String>>();
    private boolean gBVerboseMode = false;
    private Map<String, URL> gHMapDescriptorLocations = new HashMap<String, URL>();
    private Map<String, ComponentDescriptor> gHMapDescriptors = new HashMap<String, ComponentDescriptor>();
    private final Map<String, Set<String>> gHMapCapabilitiesToProviders = new HashMap<String, Set<String>>();

    public final void inventoryDescriptors(URL[] aDescriptorsLocations) throws EnhancedException {
        ComponentDescriptor theComponentDescriptor;
        String theStrDescriptorIdentifier = "";
        String theStrDescriptorDescription = "";
        ArrayList<URL> theListOfDescriptorsLocations = new ArrayList<URL>();
        int theLastOverwritablePosition = 0;
        this.gHMapDescriptorLocations = new HashMap<String, URL>();
        this.gHMapDescriptors = new HashMap<String, ComponentDescriptor>();
        this.gHMapHierarchy = new HashMap<String, List<String>>();
        URL theIndexURL = aDescriptorsLocations[0];
        BufferedReader theIntake = null;
        try {
            theIntake = new BufferedReader(new InputStreamReader(theIndexURL.openStream()));
            String theInputLine = theIntake.readLine();
            try {
                theComponentDescriptor = new ComponentDescriptor(aDescriptorsLocations[0]);
                theListOfDescriptorsLocations.add(aDescriptorsLocations[0]);
            }
            catch (EnhancedException theEe) {
                while (theInputLine != null) {
                    if (theInputLine.matches("^(\\s*#.*|\\s*)$")) {
                        LOGGER.log(Level.FINE, "Ignored line [" + theInputLine + "]");
                    } else {
                        LOGGER.log(Level.FINE, "Descriptor line [" + theInputLine.trim() + "]");
                        theListOfDescriptorsLocations.add(new URL(theIndexURL, theInputLine.trim()));
                    }
                    theInputLine = theIntake.readLine();
                }
                theLastOverwritablePosition = theListOfDescriptorsLocations.size();
            }
            for (int theI = 1; theI < aDescriptorsLocations.length; ++theI) {
                URL theReference = aDescriptorsLocations[theI];
                if (theReference == null) continue;
                theListOfDescriptorsLocations.add(theReference);
            }
        }
        catch (IOException theException) {
            LOGGER.log(Level.SEVERE, "CANT_OPEN_INDEX_FILE", theIndexURL.toString());
            throw new EnhancedException("CANT_OPEN_INDEX_FILE", (Throwable)theException, new String[]{"file=" + theIndexURL.toString()});
        }
        finally {
            try {
                if (theIntake != null) {
                    theIntake.close();
                }
            }
            catch (IOException theIOEx) {
                LOGGER.log(Level.FINE, "CANNOT_CLOSE_STREAM", theIOEx);
            }
        }
        for (int theI = 0; theI < theListOfDescriptorsLocations.size(); ++theI) {
            boolean thePreserve = theI >= theLastOverwritablePosition;
            URL theURLDescriptorLocation = (URL)theListOfDescriptorsLocations.get(theI);
            try {
                theComponentDescriptor = new ComponentDescriptor(theURLDescriptorLocation);
                try {
                    theStrDescriptorIdentifier = theComponentDescriptor.getIdentityIdentifier();
                    theStrDescriptorDescription = theComponentDescriptor.getIdentityDescription(Locale.getDefault());
                }
                catch (Exception theE) {
                    LOGGER.log(Level.FINE, "Cannot get identity for descriptor : " + theURLDescriptorLocation);
                }
                if (thePreserve && this.gHMapDescriptorLocations.containsKey(theStrDescriptorIdentifier)) {
                    if (this.getVerbose()) {
                        LOGGER.log(Level.FINE, "Skipping  : ");
                    }
                } else {
                    if (this.getVerbose()) {
                        LOGGER.log(Level.FINE, "Inserting : ");
                    }
                    this.gHMapDescriptorLocations.put(theStrDescriptorIdentifier, theURLDescriptorLocation);
                    this.gHMapDescriptors.put(theStrDescriptorIdentifier, theComponentDescriptor);
                }
                if (!this.getVerbose()) continue;
                LOGGER.log(Level.FINE, theStrDescriptorIdentifier + " from : " + theURLDescriptorLocation.toString());
                LOGGER.log(Level.FINE, "          : " + theStrDescriptorDescription);
                continue;
            }
            catch (EnhancedException theEe) {
                LogUtils.log((Logger)LOGGER, (Level)Level.SEVERE, (String)"UNUSABLE_DESCRIPTOR", (Throwable)theEe, (String[])new String[]{"file=" + theURLDescriptorLocation.toString()});
                throw new EnhancedException("UNUSABLE_DESCRIPTOR", (Throwable)theEe, new String[]{"file=" + theURLDescriptorLocation.toString()});
            }
        }
        this.inventoryDirectConnections();
        this.resolveCircularDependencies();
    }

    public final URL getDescriptorLocation(String aComponentName) {
        return this.gHMapDescriptorLocations.get(aComponentName);
    }

    private void inventoryDirectConnections() {
        if (this.gHMapDescriptors.isEmpty()) {
            if (this.getVerbose()) {
                LOGGER.log(Level.FINE, "!! No descriptors have been inventoried yet.");
                LOGGER.log(Level.FINE, "   Have you tried the inventory method first ?");
            }
        } else {
            for (String theDescriptorName : this.gHMapDescriptors.keySet()) {
                this.updateAllMaps(theDescriptorName);
            }
        }
    }

    private void updateAllMaps(String aDescriptorIdentityName) {
        ArrayList<String> theSubordinateEntries = new ArrayList<String>();
        ComponentDescriptor theComponentDescriptor = this.gHMapDescriptors.get(aDescriptorIdentityName);
        String theMainEntry = theComponentDescriptor.getIdentityIdentifier();
        Set<String> theRequiredComponentsID = theComponentDescriptor.getRequirementsComponentIdentifiers();
        Set<String> theRequiredCapabilitiesID = theComponentDescriptor.getRequirementsCapabilityIdentifiers();
        List<String> theFeaturesID = theComponentDescriptor.getFeaturesID();
        this.updateHierarchyMap(theMainEntry, theFeaturesID);
        theSubordinateEntries.addAll(theRequiredComponentsID);
        theSubordinateEntries.addAll(theRequiredCapabilitiesID);
        this.updateDependenciesMap(theMainEntry, theSubordinateEntries);
        this.updateCapabilitiesMap(theMainEntry, theComponentDescriptor.getIdentityStandards());
    }

    private void updateHierarchyMap(String aMainEntry, List<String> aSecondaryEntries) {
        this.gHMapHierarchy.put(aMainEntry, aSecondaryEntries);
    }

    private void updateDependenciesMap(String aEntry, List<String> aDirectDependencies) {
        this.gHMapDirectDependencies.put(aEntry, aDirectDependencies);
    }

    private void updateCapabilitiesMap(String aProviderID, List<String> aStandards) {
        for (String theStandardName : aStandards) {
            if (!this.gHMapCapabilitiesToProviders.containsKey(theStandardName)) {
                this.gHMapCapabilitiesToProviders.put(theStandardName, new HashSet());
            }
            Set<String> theKnownProviders = this.gHMapCapabilitiesToProviders.get(theStandardName);
            theKnownProviders.add(aProviderID);
            this.gHMapCapabilitiesToProviders.put(theStandardName, theKnownProviders);
        }
    }

    @Override
    public final List<String> getDependencies(String aRequest) {
        ArrayList<String> theResult = new ArrayList<String>();
        List theTempResult = (List)this.gHMapDirectDependencies.get(aRequest);
        if (theTempResult != null) {
            theResult.addAll(theTempResult);
        }
        return theResult;
    }

    public final ComponentDescriptor getDescriptor(String aDescriptorID) {
        ComponentDescriptor theResult = null;
        if (this.gHMapDescriptors.containsKey(aDescriptorID)) {
            theResult = this.gHMapDescriptors.get(aDescriptorID);
        }
        return theResult;
    }

    @Override
    public final boolean sequenceStatus(List<String> aSequence) {
        boolean theStatus = true;
        if (!"".equals(this.getKnotName())) {
            LOGGER.log(Level.FINE, "The submitted graph contains a circular dependency around component : " + this.getKnotName() + ".");
            theStatus = false;
        }
        if (!"".equals(this.getMissingName())) {
            LOGGER.log(Level.FINE, "The submitted graph is missing entry : " + this.getMissingName() + ".");
            theStatus = false;
        }
        if (this.getDependenciesSafe()) {
            LOGGER.log(Level.FINE, "     -= Breakdown of the sequence =-");
            for (String theComponentName : aSequence) {
                LOGGER.log(Level.FINE, "-> " + theComponentName);
            }
        }
        return theStatus;
    }

    public List<String> getSequencedSelection(List<String> aListOfRequiredItemsIDs) {
        this.setmHSetAllTrails(aListOfRequiredItemsIDs);
        this.loadGraph();
        return this.exportSequence();
    }

    public List<String> getReverseSequencedSelection(List<String> aListOfRequiredItemsIDs) {
        ArrayList<String> theResult = new ArrayList<String>();
        for (String theComponentName : this.getSequencedSelection(aListOfRequiredItemsIDs)) {
            theResult.add(0, theComponentName);
        }
        return theResult;
    }

    public final List<ComponentDescriptor> exportComponentDescriptorSequence(List<String> aListOfRequiredItemsIDs) {
        ArrayList<ComponentDescriptor> theSequenceOfDescriptors = new ArrayList<ComponentDescriptor>();
        for (String theComponentID : this.getSequencedSelection(aListOfRequiredItemsIDs)) {
            theSequenceOfDescriptors.add(this.gHMapDescriptors.get(theComponentID));
        }
        return theSequenceOfDescriptors;
    }

    public final List<ComponentDescriptor> exportComponentDescriptorReverseSequence(List<String> aListOfRequiredItemsIDs) {
        ArrayList<ComponentDescriptor> theSequenceOfDescriptors = new ArrayList<ComponentDescriptor>();
        for (ComponentDescriptor theComponentDescriptor : this.exportComponentDescriptorSequence(aListOfRequiredItemsIDs)) {
            theSequenceOfDescriptors.add(0, theComponentDescriptor);
        }
        return theSequenceOfDescriptors;
    }

    private List<String> exportSequence() {
        return this.extractSequence();
    }

    @Override
    public final boolean isLegitimateGroup(String aRequest) {
        return this.gHMapCapabilitiesToProviders.containsKey(aRequest);
    }

    @Override
    public boolean isLegitimateComponent(String aRequest) {
        return this.gHMapDirectDependencies.containsKey(aRequest);
    }

    @Override
    public final void setSelection(List<String> aHeadsOfTrails) {
        this.setmHSetAllTrails(aHeadsOfTrails);
    }

    @Override
    public final void setVerbose(boolean aVerboseMode) {
        this.gBVerboseMode = aVerboseMode;
    }

    @Override
    public final boolean getVerbose() {
        return this.gBVerboseMode;
    }

    public final Map<String, URL> exportDescriptorsLocations() {
        HashMap<String, URL> theDisposableMap = new HashMap<String, URL>();
        theDisposableMap.putAll(this.gHMapDescriptorLocations);
        return theDisposableMap;
    }

    public final Map<String, List<String>> exportHierarchy() {
        HashMap<String, List<String>> theDisposableMap = new HashMap<String, List<String>>();
        theDisposableMap.putAll(this.gHMapHierarchy);
        return theDisposableMap;
    }

    public final Map<String, Set<String>> exportCapabilities() {
        HashMap<String, Set<String>> theDisposableMap = new HashMap<String, Set<String>>();
        theDisposableMap.putAll(this.gHMapCapabilitiesToProviders);
        return theDisposableMap;
    }
}

