/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui;

import java.net.URL;
import org.openinstaller.bus.BusEvent;
import org.openinstaller.bus.BusException;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.ServiceProvider;
import org.openinstaller.provider.ui.UserInterfaceWizard;
import org.openinstaller.provider.ui.WizardFactory;
import org.openinstaller.provider.ui.sequencer.GlobalPageSequence;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.install.Common;

public class UIProvider
implements ServiceProvider {
    private URL gMetadataLocation;
    private UserInterfaceWizard gWizard = null;

    public final void init(ControlBus aBus) throws BusException {
        this.gMetadataLocation = Common.getMediaLocationURL();
        try {
            this.gWizard = WizardFactory.getWizard();
        }
        catch (EnhancedException theException) {
            throw new BusException("COULD_NOT_CREATE_A_WIZARD", (Throwable)theException, new String[0]);
        }
    }

    public final void receiveEvent(ControlBus aBus, BusEvent aEvt) {
    }

    public final void receiveRequest(ControlBus aBus, BusRequest aReq, BusResponse aResp) {
        if ("START".equals(aReq.getName())) {
            try {
                GlobalPageSequence.loadPageSequence(this.gMetadataLocation, Common.getProcessingMode());
            }
            catch (EnhancedException theException) {
                aResp.setException((Exception)((Object)new BusException("ERROR_LOADING_PAGEGROUP_SEQUENCE", (Throwable)theException, new String[]{"method=" + ClassUtils.getMethodName()})));
                return;
            }
            try {
                this.gWizard.start();
            }
            catch (EnhancedException theException) {
                aResp.setException((Exception)((Object)new BusException("STARTING_WIZARD_FAILED", (Throwable)theException, new String[0])));
            }
        }
    }

    public final void shutdown() {
    }

    public final String getName() {
        return "svc://general/ui";
    }
}

