/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.custom;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openinstaller.util.BrowserLauncher;
import org.openinstaller.util.ClassUtils;

public class HTMLPanel
extends JEditorPane {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private boolean gInternal = false;

    public HTMLPanel() {
        this.setContentType("text/html");
        this.setDoubleBuffered(true);
        this.setEditable(false);
        this.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        URL theURL = new URL(e.getDescription());
                        BrowserLauncher.openURL((URL)theURL, (boolean)HTMLPanel.this.gInternal);
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.FINE, "Could not find supported web browser.", t);
                    }
                }
            }
        });
    }

    public void setInternalFlag(boolean aFlag) {
        this.gInternal = aFlag;
    }

    public HTMLPanel(String aText) {
        this();
        super.setText(aText);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g);
    }
}

