/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.sequencer;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.openinstaller.bindings.ui.pagesequence.Flow;
import org.openinstaller.bindings.ui.pagesequence.Page;
import org.openinstaller.bindings.ui.pagesequence.Sequence;
import org.openinstaller.provider.conf.ConfigHelper;
import org.openinstaller.provider.conf.oor.OORProp;
import org.openinstaller.provider.ui.sequencer.OrderedStringPair;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.LocaleUtils;
import org.openinstaller.util.substitution.ComponentToken;
import org.openinstaller.util.substitution.SubstitutionParser;
import org.openinstaller.util.substitution.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalPageSequence {
    private static final Map<String, Page> gPageByNameMap;
    private static final List<String> gPageIdList;
    public static final String PAGE_SEQUENCE_SCHEMA_PACKAGE = "org.openinstaller.bindings.ui.pagesequence";
    private static Properties gPageNamesBundle;
    private static final Logger LOGGER;
    private static List<Page> gPages;
    private static int gPageIndex;

    private GlobalPageSequence() {
    }

    public static void loadPageSequence(URL aPageSequenceURL, String aProcMode) throws EnhancedException {
        LOGGER.fine("Loading definitions from media location " + aPageSequenceURL);
        gPageByNameMap.clear();
        gPageIdList.clear();
        try {
            URL theURL = new URL(aPageSequenceURL, "pagesequence.xml");
            JAXBContext theJAXBContext = JAXBContext.newInstance((String)PAGE_SEQUENCE_SCHEMA_PACKAGE);
            Unmarshaller theUnmarshaller = theJAXBContext.createUnmarshaller();
            LOGGER.log(Level.FINE, "About to unmarshal template=" + theURL);
            Object thePageSequenceObject = theUnmarshaller.unmarshal(theURL);
            LOGGER.log(Level.FINE, "Unmarshalling done");
            Sequence thePageSequence = thePageSequenceObject instanceof Sequence ? (Sequence)thePageSequenceObject : (Sequence)((JAXBElement)thePageSequenceObject).getValue();
            List theFlows = thePageSequence.getFlow();
            for (Flow theFlow : theFlows) {
                if (!aProcMode.equals(theFlow.getName())) continue;
                gPages = theFlow.getPage();
                break;
            }
            if (null == gPages || 0 == gPages.size()) {
                throw new EnhancedException("No/Empty " + aProcMode + " flow defined in pagesequence", new String[0]);
            }
            LOGGER.fine("Page count=" + gPages.size());
            gPageNamesBundle = new Properties();
            URL thePropertiesBaseURL = new URL(aPageSequenceURL, "pagesequence.properties");
            for (String theCandidate : LocaleUtils.getCandidateResourceNames((String)thePropertiesBaseURL.toExternalForm(), (Locale)Locale.getDefault())) {
                try {
                    LOGGER.fine("Looking for " + theCandidate);
                    InputStream theIn = new URL(theCandidate).openStream();
                    if (theIn == null) continue;
                    LOGGER.fine("Will attempt to load " + theIn);
                    gPageNamesBundle.load(theIn);
                    theIn.close();
                    break;
                }
                catch (IOException theEx) {
                    LOGGER.fine("Attempt to load " + theCandidate + " failed");
                }
            }
            if (gPageNamesBundle.isEmpty()) {
                LOGGER.log(Level.FINE, "Missing pagesequence.properties");
            }
            for (Page thePage : gPages) {
                String thePGId = thePage.getName();
                if (gPageIdList.contains(thePGId)) {
                    throw new EnhancedException("DUPLICATE_PAGE_ADDITION_ATTEMPT", new String[]{"Page ID=" + thePGId});
                }
                gPageIdList.add(thePGId);
                String thePGLabel = thePage.getLabel();
                LOGGER.fine("Adding page=" + thePGId);
                LOGGER.finer("Page ID is: [" + thePGId + "]");
                if ((thePGLabel == null || "".equals(thePGLabel)) && null != gPageNamesBundle) {
                    thePage.setLabel(gPageNamesBundle.getProperty(thePGId, thePGId));
                } else {
                    thePage.setLabel(thePGId);
                }
                LOGGER.finer("Page label is: [" + thePage.getLabel() + "]");
                gPageByNameMap.put(thePGId, thePage);
            }
        }
        catch (JAXBException theException) {
            throw new EnhancedException("Error initializing JAXB", (Throwable)theException, new String[0]);
        }
        catch (MalformedURLException theException) {
            throw new EnhancedException("Error loading page sequence", (Throwable)theException, new String[0]);
        }
    }

    public static boolean hasPage(String aPageName) throws EnhancedException {
        if (null == aPageName) {
            throw new EnhancedException("NULL_OBJECT", new String[0]);
        }
        return gPageByNameMap.containsKey(aPageName);
    }

    public static int getIndex(String aPageName) {
        return gPageIdList.indexOf(aPageName);
    }

    public static List<Page> getPages() {
        return gPages;
    }

    public static void reanalyzePageSequence(String aCurrentPageName) {
        LOGGER.finer("reanalyzePageSequence(" + aCurrentPageName + ")");
        try {
            ArrayList<OrderedStringPair> theMoveList = new ArrayList<OrderedStringPair>();
            int theOldCurrentPageIndex = GlobalPageSequence.getIndex(aCurrentPageName);
            while (theOldCurrentPageIndex != gPageIdList.size() - 1) {
                Page theCurrentPage = gPages.get(theOldCurrentPageIndex);
                String theCurrentPageName = theCurrentPage.getName();
                LOGGER.finest("Analyzing " + theCurrentPageName);
                List<OORProp> theVarnames = ConfigHelper.getProperties(theCurrentPageName);
                boolean theSwappedFlag = false;
                for (OORProp theProp : theVarnames) {
                    String thePropref = null;
                    LOGGER.finest(theCurrentPageName + " prop: " + theProp.getName());
                    String theEval = theProp.getEval();
                    List theTokens = null;
                    try {
                        if (theEval != null) {
                            theTokens = new SubstitutionParser((Reader)new StringReader(theEval)).getTokens();
                        }
                    }
                    catch (IOException theException) {
                        LOGGER.fine("SILENTLY IGNORED: " + theException.getMessage());
                    }
                    if (null != theTokens && theTokens.size() == 1 && theTokens.get(0) instanceof ComponentToken) {
                        thePropref = ((Token)theTokens.get(0)).get().replace(':', '.');
                    }
                    if (null == thePropref) continue;
                    LOGGER.finest(theCurrentPageName + " propref: " + theEval);
                    String thePageNameOfVariable = GlobalPageSequence.getAPOCPageName(thePropref);
                    if (null == thePageNameOfVariable || theCurrentPageName.equals(thePageNameOfVariable)) continue;
                    int theCurrentIndex = gPageIdList.indexOf(theCurrentPageName);
                    int theVariableIndex = gPageIdList.indexOf(thePageNameOfVariable);
                    if (theVariableIndex <= theCurrentIndex) continue;
                    LOGGER.fine(theCurrentPageName + " swapping with " + thePageNameOfVariable);
                    OrderedStringPair thePair = new OrderedStringPair(theCurrentPageName, thePageNameOfVariable);
                    if (theMoveList.contains(thePair)) {
                        throw new EnhancedException("propref [" + thePropref + "] required by " + theCurrentPageName + " has a cyclic dependency with [" + thePageNameOfVariable + "]. Skipping rearranging.", new String[0]);
                    }
                    gPageIdList.remove(theCurrentPageName);
                    gPageIdList.add(theVariableIndex, theCurrentPageName);
                    gPages.remove(theCurrentPage);
                    gPages.add(theVariableIndex, theCurrentPage);
                    theMoveList.add(new OrderedStringPair(thePageNameOfVariable, theCurrentPageName));
                    theSwappedFlag = true;
                    break;
                }
                if (theSwappedFlag) continue;
                LOGGER.finest("No change. Increasing index");
                ++theOldCurrentPageIndex;
            }
        }
        catch (EnhancedException theException) {
            LOGGER.fine("SILENTLY IGNORED: " + theException.getMessage());
        }
    }

    public static Page getPageAtIndex(int aIndex) throws IndexOutOfBoundsException {
        return gPageByNameMap.get(gPageIdList.get(aIndex));
    }

    public static int getPageCount() {
        return gPageIdList.size();
    }

    public static synchronized void setPageIndex(int aIndex) throws IndexOutOfBoundsException {
        if (aIndex >= GlobalPageSequence.getPageCount() || aIndex < 0) {
            throw new IndexOutOfBoundsException("Page index out of range");
        }
        LOGGER.fine("Setting page index to " + aIndex);
        gPageIndex = aIndex;
    }

    public static synchronized int getPageIndex() {
        return gPageIndex;
    }

    public static synchronized String getCurrentPageName() {
        String theName = GlobalPageSequence.getPageAtIndex(gPageIndex).getName();
        LOGGER.fine("Getting page name for index " + gPageIndex + " as " + theName);
        return theName;
    }

    private static String getAPOCPageName(String aOORVariableName) {
        if (aOORVariableName == null) {
            LOGGER.fine("CAUTION: " + ClassUtils.getMethodName() + ": was passed a null argument");
            return null;
        }
        StringTokenizer theTokenizer = new StringTokenizer(aOORVariableName, ".");
        if (theTokenizer.countTokens() < 2) {
            LOGGER.fine("CAUTION: " + ClassUtils.getMethodName() + ": was passed [" + aOORVariableName + "] as an argument");
            return null;
        }
        return theTokenizer.nextToken();
    }

    static {
        LOGGER = Logger.getLogger(ClassUtils.getClassName());
        gPageIndex = -1;
        gPageByNameMap = new HashMap<String, Page>();
        gPageIdList = new ArrayList<String>();
    }
}

