/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.wizard;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.openinstaller.bindings.ui.pagesequence.Page;
import org.openinstaller.bus.BusEvent;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.provider.conf.ConfigHelper;
import org.openinstaller.provider.conf.apoc.APOCProperty;
import org.openinstaller.provider.conf.oor.ConfigType;
import org.openinstaller.provider.ui.UserInterfaceWizard;
import org.openinstaller.provider.ui.ViewMode;
import org.openinstaller.provider.ui.sequencer.GlobalPageSequence;
import org.openinstaller.provider.ui.swixgen.SwiXMLBuilder;
import org.openinstaller.provider.ui.wizard.AbstractWizard;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.Msg;
import org.openinstaller.util.Scripting;

public class SilentWizard
extends AbstractWizard {
    private static UserInterfaceWizard gWizard;
    private static Properties gAnswerfileProps;

    public static UserInterfaceWizard getInstance(URL[] aAnswerFileURLs) throws EnhancedException {
        if (null != gWizard) {
            return gWizard;
        }
        gAnswerfileProps = new Properties();
        for (URL theAnswerFileURL : aAnswerFileURLs) {
            try {
                gAnswerfileProps.load(theAnswerFileURL.openStream());
            }
            catch (IOException theException) {
                throw new EnhancedException("COULD_NOT_LOAD_ANSWER_FILE", (Throwable)theException, new String[0]);
            }
        }
        gWizard = new SilentWizard();
        return gWizard;
    }

    private SilentWizard() throws EnhancedException {
    }

    private void setAvailableOrDefault(String aProductPlusDataPathName, String aType) throws EnhancedException {
        if (gAnswerfileProps.containsKey(aProductPlusDataPathName)) {
            Object theValue = ConfigHelper.thaw(gAnswerfileProps.getProperty(aProductPlusDataPathName), ConfigType.getTypeForString(aType));
            LOGGER.fine("About to setValue(" + aProductPlusDataPathName + ", " + gAnswerfileProps.getProperty(aProductPlusDataPathName) + ")");
            ConfigHelper.setValue(aProductPlusDataPathName, theValue);
        } else {
            Object theValue = ConfigHelper.getValue(aProductPlusDataPathName);
            LOGGER.fine("About to setValue(" + aProductPlusDataPathName + ", " + ConfigHelper.getValue(aProductPlusDataPathName) + ") [default]");
            ConfigHelper.setValue(aProductPlusDataPathName, theValue);
        }
    }

    public void start() throws EnhancedException {
        this.gSwiXMLBuilder = new SwiXMLBuilder(this.getViewMode());
        if (gAnswerfileProps != null) {
            try {
                SilentWizard.setInitialProperties(gAnswerfileProps);
            }
            catch (EnhancedException theEx) {
                String theMsg = Msg.get((String)"CANT_SET_INIT_PROPERTIES", (Object[])new Object[]{EnhancedException.getLastCause((Throwable)theEx).getLocalizedMessage()});
                System.out.println(theMsg);
                this.gBus.publishEvent(new BusEvent("shutdown"));
            }
        }
        this.runSilentLoop();
    }

    private Interpreter getInterpreter() throws EnhancedException {
        Interpreter theInterpreter;
        try {
            theInterpreter = Scripting.getInterpreter();
            theInterpreter.set("wizard", (Object)this);
        }
        catch (EvalError theException) {
            EnhancedException theRethrown = new EnhancedException("INTERPRETER_INIT_FAILED", (Throwable)theException, new String[]{"class=" + ClassUtils.getClassName()});
            LOGGER.throwing(ClassUtils.getClassName(), ClassUtils.getMethodName(), theRethrown);
            throw theRethrown;
        }
        catch (Exception theException) {
            EnhancedException theRethrown = new EnhancedException("INTERPRETER_INIT_FAILED", (Throwable)theException, new String[]{"class=" + ClassUtils.getClassName()});
            LOGGER.throwing(ClassUtils.getClassName(), ClassUtils.getMethodName(), theRethrown);
            throw theRethrown;
        }
        return theInterpreter;
    }

    private void runSilentLoop() throws EnhancedException {
        LOGGER.log(Level.FINE, "SilentWizard.start()");
        int theCount = GlobalPageSequence.getPageCount();
        int theIndex = 0;
        block8: while (theIndex < theCount) {
            BusResponse theResponse;
            GlobalPageSequence.reanalyzePageSequence(GlobalPageSequence.getPageAtIndex(theIndex).getName());
            Page thePage = GlobalPageSequence.getPageAtIndex(theIndex);
            if (this.isSkippable(thePage)) {
                LOGGER.fine("Skipping page " + thePage.getName());
                ++theIndex;
                theCount = GlobalPageSequence.getPageCount();
                continue;
            }
            String theProductName = thePage.getName();
            LOGGER.fine("About to trigger ONLOAD of  [" + theProductName + "]");
            try {
                ConfigHelper.doTrigger(theProductName);
            }
            catch (EnhancedException theEx) {
                String theMsg = Msg.get((String)"SILENT_CANNOT_TRIGGER_ONLOAD", (Object[])new Object[]{theProductName, EnhancedException.getLastCause((Throwable)theEx).getLocalizedMessage()});
                System.out.println(theMsg);
                break;
            }
            LOGGER.fine("Triggered ONLOAD of  [" + theProductName + "]");
            try {
                theResponse = (BusResponse)this.getInterpreter().get("theTaskResponse");
            }
            catch (EvalError theEvalError) {
                String theMsg = Msg.get((String)"SILENT_BEANSHELL_EVAL_ERROR", (Object[])new Object[]{theProductName, theEvalError.getErrorSourceFile(), theEvalError.getErrorLineNumber(), theEvalError.getMessage()});
                System.out.println(theMsg);
                break;
            }
            String theLastUpdate = null;
            while (null != theResponse && theResponse.isMore()) {
                String theThisUpdate;
                Object theResult = theResponse.getResult();
                if (null != theResult && !(theThisUpdate = theResult.toString()).equals(theLastUpdate)) {
                    LOGGER.fine("Task result: " + theThisUpdate);
                    theLastUpdate = theThisUpdate;
                }
                Thread.yield();
            }
            LOGGER.fine("The trigger for [" + theProductName + "] is over.");
            List<APOCProperty> theProperties = null;
            try {
                theProperties = ConfigHelper.getUIProperties(theProductName);
            }
            catch (EnhancedException theEx) {
                String theMsg = Msg.get((String)"SILENT_CANNOT_GET_UI_PROPERTIES", (Object[])new Object[]{theProductName, EnhancedException.getLastCause((Throwable)theEx).getLocalizedMessage()});
                System.out.println(theMsg);
                break;
            }
            LOGGER.fine(thePage.getName() + " has " + theProperties.size() + " properties");
            for (APOCProperty theVar : theProperties) {
                String theVarName = theVar.getDataPath();
                if ("".equals(theVarName)) {
                    LOGGER.fine("Skipping variable with no datapath.");
                    continue;
                }
                theVarName = theProductName + "." + theVarName;
                LOGGER.fine("About to deal with variable " + theVarName);
                try {
                    this.setAvailableOrDefault(theVarName, ConfigHelper.getType(theVarName).getTypeSpecifier());
                }
                catch (EnhancedException theEx) {
                    String theMsg = Msg.get((String)"SILENT_CANNOT_SET_PROPERTY", (Object[])new Object[]{theProductName, gAnswerfileProps.get(theVarName), EnhancedException.getLastCause((Throwable)theEx).getLocalizedMessage()});
                    System.out.println(theMsg);
                    break block8;
                }
            }
            ++theIndex;
            theCount = GlobalPageSequence.getPageCount();
        }
        ControlBus.getInstance().publishEvent(new BusEvent("shutdown"));
    }

    public void clickNext() throws EnhancedException {
    }

    public void enableNext(boolean aEnabled) {
    }

    public void enableBack(boolean aEnabled) {
    }

    public void enableCancel(boolean aEnabled) {
    }

    public void enableHelp(boolean aEnabled) {
    }

    public void clickBack() throws EnhancedException {
    }

    public ViewMode getViewMode() {
        return ViewMode.SILENT;
    }
}

