/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.pkg;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.pkg.PackageException;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ExecuteCommand;
import org.openinstaller.util.InvalidArgumentException;

public final class SolarisPatchUtils {
    private static final String PFEXEC_CMD = "/usr/bin/pfexec";
    private static final String ALTROOT_OPTION = "-R";
    private static final String CURR_ZONE_ONLY_OPTION = "-G";
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public static void installPatch(URL aSrcPath, List<String> aPatchIdList, String aDomain, String aAltRoot, boolean aCurrZoneOnly) throws PackageException {
        ExecuteCommand theCmd;
        ArrayList<String> thePatchAddCmd = new ArrayList<String>();
        thePatchAddCmd.add(PFEXEC_CMD);
        thePatchAddCmd.add(PatchCommand.PATCHADD.getPatchCmd());
        thePatchAddCmd.add("-M");
        thePatchAddCmd.add(aSrcPath.getPath());
        if (aCurrZoneOnly) {
            thePatchAddCmd.add(CURR_ZONE_ONLY_OPTION);
        }
        if (aAltRoot != null && !"".equals(aAltRoot)) {
            thePatchAddCmd.add(ALTROOT_OPTION);
            thePatchAddCmd.add(aAltRoot);
        }
        thePatchAddCmd.addAll(aPatchIdList);
        try {
            theCmd = new ExecuteCommand(thePatchAddCmd.toArray(new String[0]));
        }
        catch (InvalidArgumentException theEx) {
            throw new PackageException(theEx, "PATCH_INSTALL_FAILED", new String[0]);
        }
        theCmd.setCollectOutput(true);
        theCmd.setOutputType(3);
        try {
            theCmd.execute();
        }
        catch (EnhancedException theEEx) {
            throw new PackageException(theEEx, "EXEC_CMD_FAILED", "command=" + theCmd.toString());
        }
        int theResult = theCmd.getResult();
        switch (theResult) {
            case 0: {
                LOGGER.log(Level.INFO, "PATCH_INSTALL_SUCCESSFUL");
                break;
            }
            default: {
                LOGGER.log(Level.SEVERE, "PATCH_INSTALL_FAILED", "exit-code=[" + theResult + "]");
            }
        }
    }

    public static void removePatch(List<String> aPatchIdList, String aDomain, String aAltRoot, boolean aCurrZoneOnly) throws PackageException {
        ExecuteCommand theCmd;
        ArrayList<String> thePatchRmCmd = new ArrayList<String>();
        thePatchRmCmd.add(PFEXEC_CMD);
        thePatchRmCmd.add(PatchCommand.PATCHRM.getPatchCmd());
        if (aCurrZoneOnly) {
            thePatchRmCmd.add(CURR_ZONE_ONLY_OPTION);
        }
        if (aAltRoot != null && !"".equals(aAltRoot)) {
            thePatchRmCmd.add(ALTROOT_OPTION);
            thePatchRmCmd.add(aAltRoot);
        }
        thePatchRmCmd.addAll(aPatchIdList);
        try {
            theCmd = new ExecuteCommand(thePatchRmCmd.toArray(new String[0]));
        }
        catch (InvalidArgumentException theEx) {
            throw new PackageException(theEx, "PATCH_INSTALL_FAILED", new String[0]);
        }
        theCmd.setCollectOutput(true);
        theCmd.setOutputType(3);
        try {
            theCmd.execute();
        }
        catch (EnhancedException theEEx) {
            throw new PackageException(theEEx, "EXEC_CMD_FAILED", "command=" + theCmd.toString());
        }
        int theResult = theCmd.getResult();
        switch (theResult) {
            case 0: {
                LOGGER.log(Level.INFO, "PATCH_REMOVE_SUCCESSFUL", "patch=" + aPatchIdList.toString());
                break;
            }
            default: {
                LOGGER.log(Level.SEVERE, "PATCH_REMOVAL_FAILED", "exit-code=[" + theResult + "]");
            }
        }
    }

    private static enum PatchCommand {
        PATCHADD("/usr/sbin/patchadd"),
        PATCHRM("/usr/sbin/patchrm");

        private final String gCmd;

        private PatchCommand(String aCmd) {
            this.gCmd = aCmd;
        }

        private String getPatchCmd() {
            return this.gCmd;
        }
    }
}

