/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.MQAuthenticator;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.MetricManager;
import com.sun.messaging.jmq.net.IPAddress;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Reason;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.security.auth.login.LoginException;

public class IMQDirectConnection
extends IMQConnection {
    private Object timerLock = new Object();
    public boolean METRICS_ON = MetricManager.isEnabled();
    Object ctrlEL = null;
    private MQAuthenticator authenticator = null;
    String remoteHostString = null;
    String remoteConString = null;
    String localsvcstring = null;
    int destroyRecurse = 0;

    public IMQDirectConnection(Service service) throws BrokerException {
        super(service);
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            if (inetAddress != null) {
                this.setRemoteIP(inetAddress.getAddress());
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new BrokerException(Globals.getBrokerResources().getString("B3152"));
        }
        this.setConnectionState(0);
        try {
            this.authenticator = new MQAuthenticator(service.getName(), service.getServiceType());
        }
        catch (Exception exception) {
            String string = "Authenticator initialization failed for IMQDirectService: " + exception;
            this.logger.log(16, string);
            throw new BrokerException(string);
        }
        if (this.authenticator != null) {
            this.accessController = this.authenticator.getAccessController();
            if (inetAddress != null) {
                this.accessController.setClientIP(inetAddress.getHostAddress());
            }
        }
        this.setConnectionState(1);
    }

    public void authenticate(String string, String string2) throws BrokerException, LoginException {
        if (this.authenticator != null) {
            this.setConnectionState(2);
            this.authenticator.authenticate(string, string2, false);
            this.accessController = this.authenticator.getAccessController();
            this.setConnectionState(3);
            this.setConnectionState(4);
        }
    }

    public boolean isBlocking() {
        return false;
    }

    public int getLocalPort() {
        return 0;
    }

    public boolean useDirectBuffers() {
        return false;
    }

    public String toString() {
        return "IMQDirectConn[" + IMQDirectConnection.getConnectionStateString(this.state) + "," + this.getRemoteConnectionString() + "," + this.localServiceString() + "]";
    }

    public String remoteHostString() {
        if (this.remoteHostString == null) {
            try {
                InetAddress inetAddress = InetAddress.getByAddress(this.remoteIP);
                this.remoteHostString = inetAddress.getHostName();
            }
            catch (Exception exception) {
                this.remoteHostString = IPAddress.rawIPToString(this.remoteIP, true, true);
            }
        }
        return this.remoteHostString;
    }

    public String getRemoteConnectionString() {
        Object object;
        String string;
        String string2;
        boolean bl;
        block6: {
            if (this.remoteConString != null) {
                return this.remoteConString;
            }
            bl = false;
            string2 = "0";
            string = "???";
            if (this.state >= 4) {
                try {
                    object = this.getAuthenticatedName();
                    if (object != null) {
                        string = object.getName();
                        bl = true;
                    }
                }
                catch (BrokerException brokerException) {
                    if (!DEBUG) break block6;
                    this.logger.log(4, "Exception getting authentication name " + this.conId, brokerException);
                }
            }
        }
        object = string + "@" + IPAddress.rawIPToString(this.remoteIP, true, true) + ":" + string2;
        if (bl) {
            this.remoteConString = object;
        }
        return object;
    }

    protected String localServiceString() {
        if (this.localsvcstring != null) {
            return this.localsvcstring;
        }
        String string = "0";
        this.localsvcstring = this.service.getName() + ":" + string;
        return this.localsvcstring;
    }

    public synchronized void closeConnection(boolean bl, int n, String string) {
        if (this.state >= 6) {
            this.logger.log(4, "Requested close of already closed connection:" + this);
            return;
        }
        this.state = 6;
        this.notifyConnectionClosed();
        this.stopConnection();
        this.cleanup(n == 1);
        if (n == 1) {
            this.cleanupConnection();
        } else {
            this.cleanup(false);
        }
    }

    protected void cleanupControlPackets(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroyConnection(boolean bl, int n, String string) {
        boolean bl2;
        int n2;
        block17: {
            block15: {
                block16: {
                    n2 = 0;
                    bl2 = false;
                    try {
                        Object object = this;
                        synchronized (object) {
                            n2 = this.state;
                            if (this.state >= 7) {
                                // MONITOREXIT @DISABLED, blocks:[0, 3, 14] lbl8 : MonitorExitStatement: MONITOREXIT : var6_6
                                Object var9_7 = null;
                                if (bl2 || n == 1) break block15;
                                break block16;
                            }
                            if (this.state < 6) {
                                this.closeConnection(bl, n, string);
                            }
                            this.setConnectionState(7);
                        }
                        Globals.getConnectionManager().removeConnection(this.getConnectionUID(), bl, n, string);
                        if (this.accessController.isAuthenticated()) {
                            this.authenticator.logout();
                        }
                        if ((object = Globals.getMetricManager()) != null) {
                            ((MetricManager)object).depositTotals(this.service.getName(), this.counters);
                        }
                        this.counters.reset();
                        this.logConnectionInfo(true, string);
                        this.setConnectionState(8);
                        bl2 = true;
                        this.wakeup();
                        break block17;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        if (!(bl2 || n == 1 || Globals.getMemManager() != null && Globals.getMemManager().getCurrentLevel() <= 0)) {
                            this.state = n2;
                            if (this.destroyRecurse < 2) {
                                ++this.destroyRecurse;
                                this.destroyConnection(bl, n, string);
                            }
                        }
                        Globals.getClusterBroadcast().connectionClosed(this.getConnectionUID(), this.isAdminConnection());
                        throw throwable;
                    }
                }
                if (Globals.getMemManager() == null || Globals.getMemManager().getCurrentLevel() > 0) {
                    this.state = n2;
                    if (this.destroyRecurse < 2) {
                        ++this.destroyRecurse;
                        this.destroyConnection(bl, n, string);
                    }
                }
            }
            Globals.getClusterBroadcast().connectionClosed(this.getConnectionUID(), this.isAdminConnection());
            return;
        }
        Object var9_8 = null;
        if (!(bl2 || n == 1 || Globals.getMemManager() != null && Globals.getMemManager().getCurrentLevel() <= 0)) {
            this.state = n2;
            if (this.destroyRecurse < 2) {
                ++this.destroyRecurse;
                this.destroyConnection(bl, n, string);
            }
        }
        Globals.getClusterBroadcast().connectionClosed(this.getConnectionUID(), this.isAdminConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConnectionState(int n) {
        Object object = this.timerLock;
        synchronized (object) {
            this.state = n;
            if (this.state >= 6) {
                this.wakeup();
                return false;
            }
            if (n != 0) {
                if (n == 1 || n == 2 || n == 3) {
                    if (n == 1) {
                        return true;
                    }
                    if (n == 3) {
                        return true;
                    }
                } else if ((n >= 4 || n == -1) && n == 4) {
                    this.logConnectionInfo(false);
                }
            }
        }
        return true;
    }

    public void logConnectionInfo(boolean bl) {
        this.logConnectionInfo(bl, "Unknown");
    }

    public void logConnectionInfo(boolean bl, String string) {
        Object[] objectArray = new String[]{this.getRemoteConnectionString(), this.localServiceString(), Integer.toString(Globals.getConnectionManager().size()), string, "0", Integer.toString(this.service.size())};
        if (!bl) {
            this.logger.log(8, "B1065", objectArray);
        } else {
            this.logger.log(8, "B1066", objectArray);
        }
    }

    public void sendControlMessage(Packet packet) {
    }

    void dumpConnectionInfo() {
    }

    protected void sayGoodbye(int n, String string) {
    }

    protected void sendConsumerInfo(int n, String string, int n2, int n3) {
    }

    protected void checkState() {
        assert (Thread.holdsLock(this.stateLock));
    }

    protected void sayGoodbye(boolean bl, int n, String string) {
    }

    protected void checkConnection() {
    }

    protected void flushConnection(long l) {
    }

    public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
    }
}

