/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.javax.crypto;

import java.io.CharConversionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenRuntimeException;
import org.mozilla.jss.crypto.TokenSupplierManager;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Password;

class JSSSecretKeyFactorySpi
extends SecretKeyFactorySpi {
    private KeyGenAlgorithm alg = null;
    private CryptoToken token = null;
    static /* synthetic */ Class class$javax$crypto$spec$DESedeKeySpec;
    static /* synthetic */ Class class$javax$crypto$spec$DESKeySpec;
    static /* synthetic */ Class class$javax$crypto$spec$SecretKeySpec;

    private JSSSecretKeyFactorySpi() {
    }

    protected JSSSecretKeyFactorySpi(KeyGenAlgorithm keyGenAlgorithm) {
        this.alg = keyGenAlgorithm;
        this.token = TokenSupplierManager.getTokenSupplier().getThreadToken();
    }

    private SecretKey generateKeyFromBits(byte[] byArray, SymmetricKey.Type type) throws NoSuchAlgorithmException, TokenException, InvalidKeySpecException, InvalidAlgorithmParameterException {
        try {
            KeyWrapper keyWrapper = this.token.getKeyWrapper(KeyWrapAlgorithm.PLAINTEXT);
            keyWrapper.initUnwrap();
            SymmetricKey symmetricKey = keyWrapper.unwrapSymmetric(byArray, type, 0);
            return new SecretKeyFacade(symmetricKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException.getMessage());
        }
    }

    private static PBEKeyGenParams makePBEKeyGenParams(PBEKeySpec pBEKeySpec) throws InvalidKeySpecException {
        Class<?> clazz = pBEKeySpec.getClass();
        try {
            Method method = clazz.getMethod("getSalt", null);
            Method method2 = clazz.getMethod("getIterationCount", null);
            byte[] byArray = (byte[])method.invoke((Object)pBEKeySpec, null);
            Integer n = (Integer)method2.invoke((Object)pBEKeySpec, null);
            int n2 = n;
            Password password = new Password(pBEKeySpec.getPassword());
            PBEKeyGenParams pBEKeyGenParams = new PBEKeyGenParams(password, byArray, n2);
            password.clear();
            return pBEKeyGenParams;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            throw new InvalidKeySpecException("SecurityException calling getMethod() on the key spec's class: " + securityException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidKeySpecException("IllegalAccessException invoking method on PBEKeySpec: " + illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = "";
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable != null) {
                string = throwable.getMessage();
            }
            throw new InvalidKeySpecException("InvocationTargetException invoking method on PBEKeySpec: " + string);
        }
        throw new InvalidKeySpecException("This version of PBEKeySpec is unsupported. It must implement getSalt() and getIterationCount(). The PBEKeySpec in JDK 1.4 works, as does org.mozilla.jss.crypto.PBEKeyGenParams. The PBEKeySpec in JCE 1.2.1 and earlier does NOT work.");
    }

    public SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof PBEKeySpec || keySpec instanceof PBEKeyGenParams) {
                PBEKeyGenParams pBEKeyGenParams = keySpec instanceof PBEKeySpec ? JSSSecretKeyFactorySpi.makePBEKeyGenParams((PBEKeySpec)keySpec) : (PBEKeyGenParams)keySpec;
                KeyGenerator keyGenerator = this.token.getKeyGenerator(this.alg);
                keyGenerator.initialize(pBEKeyGenParams);
                SymmetricKey symmetricKey = keyGenerator.generate();
                pBEKeyGenParams.clear();
                return new SecretKeyFacade(symmetricKey);
            }
            if (keySpec instanceof DESedeKeySpec) {
                if (this.alg != KeyGenAlgorithm.DES3) {
                    throw new InvalidKeySpecException("Incorrect KeySpec type (" + keySpec.getClass().getName() + ") for algorithm (" + this.alg.toString() + ")");
                }
                return this.generateKeyFromBits(((DESedeKeySpec)keySpec).getKey(), SymmetricKey.Type.DES3);
            }
            if (keySpec instanceof DESKeySpec) {
                if (this.alg != KeyGenAlgorithm.DES) {
                    throw new InvalidKeySpecException("Incorrect KeySpec type (" + keySpec.getClass().getName() + ") for algorithm (" + this.alg.toString() + ")");
                }
                return this.generateKeyFromBits(((DESKeySpec)keySpec).getKey(), SymmetricKey.Type.DES);
            }
            if (keySpec instanceof SecretKeySpec) {
                SecretKeySpec secretKeySpec = (SecretKeySpec)keySpec;
                SymmetricKey.Type type = SymmetricKey.Type.fromName(secretKeySpec.getAlgorithm());
                return this.generateKeyFromBits(secretKeySpec.getEncoded(), type);
            }
            throw new InvalidKeySpecException("Unsupported KeySpec: " + keySpec.getClass().getName());
        }
        catch (TokenException tokenException) {
            throw new TokenRuntimeException(tokenException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeySpecException("InvalidAlgorithmParameterException: " + invalidAlgorithmParameterException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            Assert.notReached("IllegalStateException");
            throw new TokenRuntimeException("IllegalStateException: " + illegalStateException.getMessage());
        }
        catch (CharConversionException charConversionException) {
            throw new InvalidKeySpecException("CharConversionException: " + charConversionException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeySpecException("NoSuchAlgorithmException: " + noSuchAlgorithmException.getMessage());
        }
    }

    public KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        try {
            if (!(secretKey instanceof SecretKeyFacade)) {
                throw new InvalidKeySpecException("key is not a JSS key");
            }
            SymmetricKey symmetricKey = ((SecretKeyFacade)secretKey).key;
            byte[] byArray = symmetricKey.getKeyData();
            SymmetricKey.Type type = symmetricKey.getType();
            if (clazz.equals(class$javax$crypto$spec$DESedeKeySpec == null ? (class$javax$crypto$spec$DESedeKeySpec = JSSSecretKeyFactorySpi.class$("javax.crypto.spec.DESedeKeySpec")) : class$javax$crypto$spec$DESedeKeySpec)) {
                if (type != SymmetricKey.Type.DES3) {
                    throw new InvalidKeySpecException("key/spec mismatch: " + type + " key, DESede spec");
                }
                return new DESedeKeySpec(byArray);
            }
            if (clazz.equals(class$javax$crypto$spec$DESKeySpec == null ? (class$javax$crypto$spec$DESKeySpec = JSSSecretKeyFactorySpi.class$("javax.crypto.spec.DESKeySpec")) : class$javax$crypto$spec$DESKeySpec)) {
                if (type != SymmetricKey.Type.DES) {
                    throw new InvalidKeySpecException("key/spec mismatch: " + type + " key, DES spec");
                }
                return new DESKeySpec(byArray);
            }
            if (clazz.equals(class$javax$crypto$spec$SecretKeySpec == null ? (class$javax$crypto$spec$SecretKeySpec = JSSSecretKeyFactorySpi.class$("javax.crypto.spec.SecretKeySpec")) : class$javax$crypto$spec$SecretKeySpec)) {
                return new SecretKeySpec(byArray, type.toString());
            }
            throw new InvalidKeySpecException("Unsupported key spec: " + clazz.getName());
        }
        catch (SymmetricKey.NotExtractableException notExtractableException) {
            throw new InvalidKeySpecException("key is not extractable");
        }
        catch (InvalidKeyException invalidKeyException) {
            Assert.notReached("Invalid key: " + invalidKeyException.getMessage());
            throw new InvalidKeySpecException("Invalid key: " + invalidKeyException.getMessage());
        }
    }

    public SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (secretKey instanceof SecretKeyFacade) {
            try {
                SymmetricKey symmetricKey = ((SecretKeyFacade)secretKey).key;
                CryptoToken cryptoToken = symmetricKey.getOwningToken();
                KeyGenerator keyGenerator = this.token.getKeyGenerator(symmetricKey.getType().getKeyGenAlg());
                SymmetricKey symmetricKey2 = keyGenerator.clone(symmetricKey);
                return new SecretKeyFacade(symmetricKey2);
            }
            catch (SymmetricKey.NotExtractableException notExtractableException) {
                throw new InvalidKeyException("key is not extractable");
            }
            catch (TokenException tokenException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidKeyException("Unsupported algorithm: " + noSuchAlgorithmException.getMessage());
            }
        }
        try {
            byte[] byArray = secretKey.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Key is not extractable");
            }
            SymmetricKey.Type type = SymmetricKey.Type.fromName(secretKey.getAlgorithm());
            return this.generateKeyFromBits(byArray, type);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException("Unsupported algorithm: " + secretKey.getAlgorithm());
        }
        catch (TokenException tokenException) {
            throw new InvalidKeyException("Token failed to process key: " + tokenException.getMessage());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Invalid key spec: " + invalidKeySpecException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("Invalid algorithm parameters: " + invalidAlgorithmParameterException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        try {
            CryptoManager.initialize(".");
            CryptoManager cryptoManager = CryptoManager.getInstance();
            CryptoToken cryptoToken = cryptoManager.getInternalCryptoToken();
            cryptoManager.setThreadToken(cryptoToken);
            KeyGenerator keyGenerator = cryptoToken.getKeyGenerator(KeyGenAlgorithm.DES3);
            SymmetricKey symmetricKey = keyGenerator.generate();
            SecretKeyFacade secretKeyFacade = new SecretKeyFacade(symmetricKey);
            JSSSecretKeyFactorySpi jSSSecretKeyFactorySpi = new JSSSecretKeyFactorySpi(KeyGenAlgorithm.DES3);
            DESedeKeySpec dESedeKeySpec = (DESedeKeySpec)jSSSecretKeyFactorySpi.engineGetKeySpec((SecretKey)secretKeyFacade, class$javax$crypto$spec$DESedeKeySpec == null ? (class$javax$crypto$spec$DESedeKeySpec = JSSSecretKeyFactorySpi.class$("javax.crypto.spec.DESedeKeySpec")) : class$javax$crypto$spec$DESedeKeySpec);
            SecretKeyFacade secretKeyFacade2 = (SecretKeyFacade)jSSSecretKeyFactorySpi.engineGenerateSecret(dESedeKeySpec);
            Cipher cipher2 = cryptoToken.getCipherContext(EncryptionAlgorithm.DES3_ECB);
            cipher2.initEncrypt(secretKeyFacade.key);
            String string = "Hello, World!!!!";
            byte[] byArray = cipher2.doFinal(string.getBytes("UTF-8"));
            System.out.println("ciphertext is " + byArray.length + " bytes");
            cipher2.initDecrypt(secretKeyFacade2.key);
            byte[] byArray2 = cipher2.doFinal(byArray);
            System.out.println("recovered plaintext is " + byArray2.length + " bytes");
            String string2 = new String(byArray2, "UTF-8");
            System.out.println("Recovered '" + string2 + "'");
            if (!string2.equals(string)) {
                throw new Exception("recovered string is different from original");
            }
            char[] cArray = "foobarpw".toCharArray();
            byte[] byArray3 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            int n = 2;
            keyGenerator = cryptoToken.getKeyGenerator(PBEAlgorithm.PBE_SHA1_DES3_CBC);
            PBEKeyGenParams pBEKeyGenParams = new PBEKeyGenParams(cArray, byArray3, n);
            keyGenerator.initialize(pBEKeyGenParams);
            symmetricKey = keyGenerator.generate();
            byte[] byArray4 = symmetricKey.getKeyData();
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBEWithSHA1AndDESede", "Mozilla-JSS");
            secretKeyFacade2 = (SecretKeyFacade)secretKeyFactory.generateSecret(pBEKeyGenParams);
            byte[] byArray5 = secretKeyFacade2.key.getKeyData();
            if (!Arrays.equals(byArray4, byArray5)) {
                throw new Exception("generated PBE keys are different");
            }
            System.out.println("generated PBE keys are the same");
            System.exit(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(-1);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class PBAHmacSHA1
    extends JSSSecretKeyFactorySpi {
        public PBAHmacSHA1() {
            super(KeyGenAlgorithm.PBA_SHA1_HMAC);
        }
    }

    public static class HmacSHA1
    extends JSSSecretKeyFactorySpi {
        public HmacSHA1() {
            super(KeyGenAlgorithm.PBA_SHA1_HMAC);
        }
    }

    public static class PBE_SHA1_RC4_128
    extends JSSSecretKeyFactorySpi {
        public PBE_SHA1_RC4_128() {
            super(PBEAlgorithm.PBE_SHA1_RC4_128);
        }
    }

    public static class PBE_SHA1_DES3_CBC
    extends JSSSecretKeyFactorySpi {
        public PBE_SHA1_DES3_CBC() {
            super(PBEAlgorithm.PBE_SHA1_DES3_CBC);
        }
    }

    public static class PBE_SHA1_DES_CBC
    extends JSSSecretKeyFactorySpi {
        public PBE_SHA1_DES_CBC() {
            super(PBEAlgorithm.PBE_SHA1_DES_CBC);
        }
    }

    public static class PBE_MD5_DES_CBC
    extends JSSSecretKeyFactorySpi {
        public PBE_MD5_DES_CBC() {
            super(PBEAlgorithm.PBE_MD5_DES_CBC);
        }
    }

    public static class RC2
    extends JSSSecretKeyFactorySpi {
        public RC2() {
            super(KeyGenAlgorithm.RC2);
        }
    }

    public static class RC4
    extends JSSSecretKeyFactorySpi {
        public RC4() {
            super(KeyGenAlgorithm.RC4);
        }
    }

    public static class AES
    extends JSSSecretKeyFactorySpi {
        public AES() {
            super(KeyGenAlgorithm.AES);
        }
    }

    public static class DESede
    extends JSSSecretKeyFactorySpi {
        public DESede() {
            super(KeyGenAlgorithm.DESede);
        }
    }

    public static class DES
    extends JSSSecretKeyFactorySpi {
        public DES() {
            super(KeyGenAlgorithm.DES);
        }
    }
}

