/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigRecordStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private ArrayList timeList = new ArrayList(32);
    private ArrayList recordList = new ArrayList(32);

    ConfigRecordStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeConfigChangeRecord(long l, byte[] byArray, boolean bl) throws BrokerException {
        ArrayList arrayList = this.timeList;
        synchronized (arrayList) {
            this.timeList.add(new Long(l));
            this.recordList.add(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ChangeRecordInfo> getConfigChangeRecordsSince(long l) {
        ArrayList<ChangeRecordInfo> arrayList = new ArrayList<ChangeRecordInfo>();
        ArrayList arrayList2 = this.timeList;
        synchronized (arrayList2) {
            Long l2;
            int n;
            int n2 = this.timeList.size();
            for (n = 0; n < n2 && (l2 = (Long)this.timeList.get(n)) <= l; ++n) {
            }
            while (n < n2) {
                arrayList.add(new ChangeRecordInfo((byte[])this.recordList.get(n), (Long)this.timeList.get(n)));
                ++n;
            }
            return arrayList;
        }
    }

    public List<ChangeRecordInfo> getAllConfigRecords() throws BrokerException {
        ArrayList<ChangeRecordInfo> arrayList = new ArrayList<ChangeRecordInfo>();
        for (int i = 0; i < this.timeList.size(); ++i) {
            arrayList.add(new ChangeRecordInfo((byte[])this.recordList.get(i), (Long)this.timeList.get(i)));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAll() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(1, "ConfigRecordStore.clearAll() called");
        }
        ArrayList arrayList = this.timeList;
        synchronized (arrayList) {
            this.timeList.clear();
            this.recordList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean bl) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "ConfigRecordStore: closing, " + this.timeList.size() + " in-memory records");
        }
        ArrayList arrayList = this.timeList;
        synchronized (arrayList) {
            this.timeList.clear();
            this.recordList.clear();
        }
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Config change records", String.valueOf(this.timeList.size()));
        return hashtable;
    }

    void printInfo(PrintStream printStream) {
        printStream.println("\nConfiguration Change Record");
        printStream.println("---------------------------");
        printStream.println("number of records: " + this.timeList.size());
    }
}

