/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQEmbeddedService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;

public class IMQEmbeddedServiceFactory
extends ServiceFactory {
    protected static boolean DEBUG = false;
    protected static final Logger logger = Globals.getLogger();
    public static final String SERVICE_PREFIX = "imq.";
    protected BrokerConfig props = Globals.getConfig();
    protected int DEFAULT_DESTROY_TIMEOUT = 30;

    public void updateService(Service service) throws BrokerException {
        IMQService iMQService = (IMQService)service;
        String string = service.getName();
        int n = this.getThreadMin(string);
        int n2 = this.getThreadMax(string);
        try {
            iMQService.setMinMaxThreadpool(n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4115", String.valueOf(n), String.valueOf(n2)), illegalArgumentException);
        }
        Globals.getPortMapper().addService(string, "none", this.props.getProperty(SERVICE_PREFIX + string + ".servicetype"), 0, iMQService.getServiceProperties());
    }

    public void startMonitoringService(Service service) throws BrokerException {
        String string = service.getName();
        String string2 = SERVICE_PREFIX + string + ".min_threads";
        this.props.addListener(string2, this);
        string2 = SERVICE_PREFIX + string + ".max_threads";
        this.props.addListener(string2, this);
    }

    public void stopMonitoringService(Service service) throws BrokerException {
        String string = service.getName();
        String string2 = SERVICE_PREFIX + string + ".min";
        this.props.removeListener(string2, this);
        string2 = SERVICE_PREFIX + string + ".max";
        this.props.removeListener(string2, this);
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
    }

    public boolean update(String string, String string2) {
        return true;
    }

    protected int getThreadMin(String string) {
        String string2 = SERVICE_PREFIX + string + ".min_threads";
        return this.props.getIntProperty(string2);
    }

    protected int getPoolTimeout(String string) {
        String string2 = SERVICE_PREFIX + string + ".destroy_timeout";
        return this.props.getIntProperty(string2, this.DEFAULT_DESTROY_TIMEOUT) * 1000;
    }

    protected int getThreadMax(String string) {
        String string2 = SERVICE_PREFIX + string + ".max_threads";
        return this.props.getIntProperty(string2);
    }

    public Service createService(String string, int n) throws BrokerException {
        if (DEBUG) {
            logger.log(4, " Creating new Service(" + string + ": Embedded )");
        }
        IMQEmbeddedService iMQEmbeddedService = new IMQEmbeddedService(string, n, Globals.getPacketRouter(n), this.getThreadMin(string), this.getThreadMax(string));
        long l = this.getPoolTimeout(string);
        if (l > 0L) {
            ((IMQService)iMQEmbeddedService).setDestroyWaitTime(l);
        }
        return iMQEmbeddedService;
    }
}

