/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.log;

import com.sun.messaging.jmq.io.RollingFileOutputStream;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.LogHandler;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class FileLogHandler
extends LogHandler {
    private RollingFileOutputStream rfos = null;
    private String logFile = null;
    private long roll_bytes = 0L;
    private long roll_secs = 0L;

    public void configure(Properties properties, String string) throws IllegalArgumentException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        long l = 0L;
        long l2 = 0L;
        string3 = (string = string + ".") + "rolloverbytes";
        string2 = properties.getProperty(string3);
        if (string2 != null) {
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string4 = rb.getString("S2000", string3, string2);
            }
        }
        if ((string2 = properties.getProperty(string3 = string + "rolloversecs")) != null) {
            try {
                l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string4 = (string4 != null ? string4 + "\n" : "") + rb.getString("S2000", string3, string2);
            }
        }
        if (l == -1L) {
            l = 0L;
        }
        if (l2 == -1L) {
            l2 = 0L;
        }
        this.setRolloverLimits(l, l2);
        string3 = string + "dirpath";
        string2 = properties.getProperty(string3);
        String string5 = string2 != null ? (string2 = StringUtil.expandVariables(string2, properties)) : "log";
        if (!new File(string5).isAbsolute()) {
            string5 = this.logger.logHome + File.separator + string5;
        }
        String string6 = (string2 = properties.getProperty(string3 = string + "filename")) != null ? string2 : "logfile";
        try {
            this.setLogFile(string5, string6);
        }
        catch (IOException iOException) {
            string4 = (string4 != null ? string4 + "\n" : "") + rb.getString("S3000", string5 + File.separator + string6, iOException);
        }
        string3 = string + "output";
        string2 = properties.getProperty(string3);
        if (string2 != null) {
            try {
                this.setLevels(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string4 = (string4 != null ? string4 + "\n" : "") + string3 + ": " + illegalArgumentException.getMessage();
            }
        }
        if (string4 != null) {
            throw new IllegalArgumentException(string4);
        }
    }

    public void setLogFile(String string, String string2) throws IOException {
        boolean bl;
        this.close();
        this.logFile = string + File.separator + string2;
        File file = new File(string);
        if (!file.exists() && !(bl = file.mkdirs())) {
            throw new IOException(rb.getString("S4000", string));
        }
        File file2 = new File(this.logFile);
        file2.createNewFile();
        if (!file2.canWrite()) {
            throw new IOException(rb.getString("S4001", this.logFile));
        }
    }

    public void setRolloverLimits(long l, long l2) {
        if (l >= 0L) {
            this.roll_bytes = l;
            if (this.rfos != null) {
                this.rfos.setRolloverBytes(this.roll_bytes);
            }
        }
        if (l2 >= 0L) {
            this.roll_secs = l2;
            if (this.rfos != null) {
                this.rfos.setRolloverSecs(this.roll_secs);
            }
        }
    }

    public void publish(int n, String string) throws IOException {
        if (n == 64 && !this.isAllowForceMessage()) {
            return;
        }
        if (this.rfos != null) {
            this.rfos.write(string.getBytes());
        }
    }

    public void open() throws IOException {
        if (this.rfos != null) {
            return;
        }
        this.rfos = new RollingFileOutputStream(new File(this.logFile), this.roll_bytes, this.roll_secs);
    }

    public void close() {
        if (this.rfos != null) {
            try {
                this.rfos.flush();
                this.rfos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.rfos = null;
    }

    public void flush() {
        if (this.rfos != null) {
            try {
                this.rfos.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.logFile;
    }
}

