/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.log;

import com.sun.messaging.jmq.resources.SharedResources;
import com.sun.messaging.jmq.util.MQResourceBundle;
import com.sun.messaging.jmq.util.log.FileLogHandler;
import com.sun.messaging.jmq.util.log.LogHandler;
import com.sun.messaging.jmq.util.log.LogRecord;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class Logger {
    private MQResourceBundle rb = null;
    private LogHandler[] handlers = null;
    private Vector deferBuffer = null;
    private boolean closed = true;
    String logHome = null;
    String propPrefix = "";
    public int level = 8;
    public static final int FORCE = 64;
    public static final int ERROR = 32;
    public static final int WARNING = 16;
    public static final int INFO = 8;
    public static final int DEBUG = 4;
    public static final int DEBUGMED = 2;
    public static final int DEBUGHIGH = 1;
    public static final int OFF = Integer.MAX_VALUE;
    private static final String LOGLEVEL_PROP = "log.level";
    private static final String TIMEZONE_PROP = "log.timezone";
    private static final String ROLLOVERSECS_PROP = "log.file.rolloversecs";
    private static final String ROLLOVERBYTES_PROP = "log.file.rolloverbytes";
    private static SharedResources myrb = SharedResources.getResources();
    private SimpleDateFormat df = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss z");

    public Logger(String string) {
        this.logHome = string;
        this.handlers = new LogHandler[1];
    }

    public void useMilliseconds() {
        this.df = new SimpleDateFormat("dd/MM/yyyy:HH:mm:ss:SS z");
    }

    public int getLevel() {
        return this.level;
    }

    public String[] getUpdateableProperties() {
        String[] stringArray = new String[]{this.propPrefix + "." + LOGLEVEL_PROP, this.propPrefix + "." + ROLLOVERSECS_PROP, this.propPrefix + "." + ROLLOVERBYTES_PROP, this.propPrefix + "." + TIMEZONE_PROP};
        return stringArray;
    }

    public synchronized void updateProperty(String string, String string2) throws IllegalArgumentException {
        if (string == null || string2 == null || string2.equals("")) {
            return;
        }
        string = string.substring(this.propPrefix.length() + 1);
        long l = -1L;
        if (string.equals(LOGLEVEL_PROP)) {
            this.level = Logger.levelStrToInt(string2);
        } else if (string.equals(TIMEZONE_PROP)) {
            if (string2.length() > 0) {
                this.df.setTimeZone(TimeZone.getTimeZone(string2));
            }
        } else if (string.equals(ROLLOVERSECS_PROP) || string.equals(ROLLOVERBYTES_PROP)) {
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(myrb.getString("S2000", string, string2));
            }
            FileLogHandler fileLogHandler = (FileLogHandler)this.findHandler("file");
            if (fileLogHandler == null) {
                return;
            }
            if (l == -1L) {
                l = 0L;
            }
            if (string.equals(ROLLOVERSECS_PROP)) {
                fileLogHandler.setRolloverLimits(-1L, l);
            } else {
                fileLogHandler.setRolloverLimits(l, -1L);
            }
        } else {
            throw new IllegalArgumentException(myrb.getString("S4005", string));
        }
    }

    private synchronized LogHandler findHandler(String string) {
        if (this.handlers == null) {
            return null;
        }
        for (int i = 0; i < this.handlers.length; ++i) {
            if (this.handlers[i] == null || !string.equals(this.handlers[i].getName())) continue;
            return this.handlers[i];
        }
        return null;
    }

    public synchronized void configure(Properties properties, String string) {
        this.propPrefix = string;
        if (properties == null) {
            return;
        }
        this.close();
        string = string + ".log.";
        String string2 = string + "level";
        String string3 = properties.getProperty(string2);
        if (string3 != null && !string3.equals("")) {
            try {
                this.level = Logger.levelStrToInt(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log(16, myrb.getKString("S2001", string2, string3));
            }
        }
        if ((string3 = properties.getProperty(string2 = string + "timezone")) != null && !string3.equals("")) {
            this.df.setTimeZone(TimeZone.getTimeZone(string3));
        }
        if ((string3 = properties.getProperty(string2 = string + "handlers")) == null || string3.equals("")) {
            this.log(32, myrb.getKString("S3003", string2));
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",", false);
        int n = stringTokenizer.countTokens();
        LogHandler[] logHandlerArray = new LogHandler[n];
        for (int i = 0; i < n; ++i) {
            String string4 = stringTokenizer.nextToken();
            string2 = string + string4 + ".class";
            String string5 = properties.getProperty(string2);
            if (string5 == null || string5.equals("")) {
                this.log(32, myrb.getKString("S3004", string2));
                continue;
            }
            try {
                Class<?> clazz = Class.forName(string5);
                logHandlerArray[i] = (LogHandler)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log(32, myrb.getKString("S3005", classNotFoundException.toString()));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.log(32, myrb.getKString("S3005", illegalAccessException.toString()));
                continue;
            }
            catch (InstantiationException instantiationException) {
                this.log(32, myrb.getKString("S3005", instantiationException.toString()));
                continue;
            }
            logHandlerArray[i].init(this);
            logHandlerArray[i].setName(string4);
            try {
                logHandlerArray[i].configure(properties, string + string4);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log(16, myrb.getKString("S2003", illegalArgumentException.toString()));
                continue;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.log(16, myrb.getKString("S2004", string4, unsatisfiedLinkError.getMessage()));
                logHandlerArray[i] = null;
                continue;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.log(16, myrb.getKString("S2004", string4, noClassDefFoundError.getMessage()));
                logHandlerArray[i] = null;
            }
        }
        try {
            this.setLogHandlers(logHandlerArray);
        }
        catch (IOException iOException) {
            System.err.println("Could not set handlers: " + iOException);
        }
    }

    public static int levelStrToInt(String string) throws IllegalArgumentException {
        if (string.equals("FORCE")) {
            return 64;
        }
        if (string.equals("ERROR")) {
            return 32;
        }
        if (string.equals("WARNING")) {
            return 16;
        }
        if (string.equals("INFO")) {
            return 8;
        }
        if (string.equals("DEBUG")) {
            return 4;
        }
        if (string.equals("DEBUGMED")) {
            return 2;
        }
        if (string.equals("DEBUGHIGH")) {
            return 1;
        }
        if (string.equals("NONE")) {
            return Integer.MAX_VALUE;
        }
        throw new IllegalArgumentException(myrb.getString("S2001", string));
    }

    public static String levelIntToStr(int n) throws IllegalArgumentException {
        switch (n) {
            case 64: {
                return "FORCE";
            }
            case 32: {
                return "ERROR";
            }
            case 16: {
                return "WARNING";
            }
            case 8: {
                return "INFO";
            }
            case 4: {
                return "DEBUG";
            }
            case 2: {
                return "DEBUGMED";
            }
            case 1: {
                return "DEBUGHIGH";
            }
        }
        throw new IllegalArgumentException();
    }

    public void setResourceBundle(MQResourceBundle mQResourceBundle) {
        this.rb = mQResourceBundle;
    }

    private synchronized void setLogHandlers(LogHandler[] logHandlerArray) throws IOException {
        if (!this.closed) {
            throw new IOException("Logger must be closed before setting handlers");
        }
        this.handlers = logHandlerArray;
    }

    public synchronized void close() {
        if (this.handlers != null) {
            for (int i = 0; i < this.handlers.length; ++i) {
                if (this.handlers[i] == null) continue;
                this.handlers[i].close();
            }
        }
        this.closed = true;
    }

    public synchronized void open() {
        for (int i = 0; i < this.handlers.length; ++i) {
            if (this.handlers[i] == null) continue;
            try {
                this.handlers[i].open();
                continue;
            }
            catch (IOException iOException) {
                this.log(32, myrb.getKString("S3001", this.handlers[i].toString(), iOException));
                this.handlers[i] = null;
            }
        }
        this.closed = false;
        this.flushDeferBuffer();
    }

    public void flush() {
        if (this.handlers != null) {
            for (int i = 0; i < this.handlers.length; ++i) {
                if (this.handlers[i] == null) continue;
                this.handlers[i].flush();
            }
        }
    }

    public void publish(int n, String string) {
        if (this.closed) {
            this.defer(n, string);
            return;
        }
        boolean bl = false;
        LogHandler logHandler = null;
        for (int i = 0; i < this.handlers.length; ++i) {
            try {
                logHandler = this.handlers[i];
            }
            catch (Exception exception) {
                logHandler = null;
            }
            if (logHandler == null || logHandler.levels == 0 || (n != 64 || !logHandler.isAllowForceMessage()) && (n == 64 || (n & logHandler.levels) == 0)) continue;
            try {
                logHandler.publish(n, string);
                bl = true;
                continue;
            }
            catch (IOException iOException) {
                System.err.println(myrb.getKString("S3002", logHandler.toString(), iOException));
            }
        }
        if (!bl) {
            System.err.println(string);
        }
    }

    private synchronized void defer(int n, String string) {
        if (this.deferBuffer == null) {
            this.deferBuffer = new Vector(32);
        }
        LogRecord logRecord = new LogRecord(n, string);
        this.deferBuffer.addElement(logRecord);
    }

    private synchronized void flushDeferBuffer() {
        if (this.deferBuffer == null) {
            return;
        }
        LogRecord logRecord = null;
        Enumeration enumeration = this.deferBuffer.elements();
        while (enumeration.hasMoreElements()) {
            logRecord = (LogRecord)enumeration.nextElement();
            this.publish(logRecord.level, logRecord.message);
        }
        this.deferBuffer.clear();
        this.deferBuffer = null;
    }

    public String format(int n, String string, Object[] objectArray, Throwable throwable, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("[");
        stringBuffer.append(this.df.format(new Date()));
        stringBuffer.append("] ");
        switch (n) {
            case 32: {
                stringBuffer.append(myrb.getString("S0000"));
                break;
            }
            case 16: {
                stringBuffer.append(myrb.getString("S0001"));
                break;
            }
        }
        String string2 = null;
        if (string == null) {
            string = "";
        }
        if (this.rb != null) {
            try {
                string2 = objectArray == null ? this.rb.getKString(string) : this.rb.getKString(string, objectArray);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = null;
            }
        }
        if (string2 == null) {
            string2 = objectArray == null ? string : MessageFormat.format(string, objectArray);
        }
        stringBuffer.append(string2);
        if (throwable != null) {
            stringBuffer.append(":" + SharedResources.NL);
            if (bl) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
                PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                printWriter.close();
                stringBuffer.append(byteArrayOutputStream.toString());
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            } else {
                stringBuffer.append(throwable + SharedResources.NL);
            }
        } else {
            stringBuffer.append(SharedResources.NL);
        }
        return stringBuffer.toString();
    }

    public void log(int n, String string) {
        if (n < this.level) {
            return;
        }
        this.publish(n, this.format(n, string, null, null, false));
    }

    public void log(int n, String string, Object object) {
        if (n < this.level) {
            return;
        }
        if (object instanceof Object[]) {
            this.publish(n, this.format(n, string, (Object[])object, null, false));
        } else {
            Object[] objectArray = new Object[]{object};
            this.publish(n, this.format(n, string, objectArray, null, false));
        }
    }

    public void log(int n, String string, Object object, Object object2) {
        if (n < this.level) {
            return;
        }
        Object[] objectArray = new Object[]{object, object2};
        this.publish(n, this.format(n, string, objectArray, null, false));
    }

    public void log(int n, String string, Object[] objectArray) {
        if (n < this.level) {
            return;
        }
        this.publish(n, this.format(n, string, objectArray, null, false));
    }

    public void log(int n, String string, Throwable throwable) {
        if (n < this.level) {
            return;
        }
        boolean bl = this.level <= 4;
        this.publish(n, this.format(n, string, null, throwable, bl));
    }

    public void log(int n, String string, Object object, Throwable throwable) {
        boolean bl;
        if (n < this.level) {
            return;
        }
        boolean bl2 = bl = this.level <= 4;
        if (object instanceof Object[]) {
            this.publish(n, this.format(n, string, (Object[])object, throwable, bl));
        } else {
            Object[] objectArray = new Object[]{object};
            this.publish(n, this.format(n, string, objectArray, throwable, bl));
        }
    }

    public void log(int n, String string, Object object, Object object2, Throwable throwable) {
        if (n < this.level) {
            return;
        }
        boolean bl = this.level <= 4;
        Object[] objectArray = new Object[]{object, object2};
        this.publish(n, this.format(n, string, objectArray, throwable, bl));
    }

    public void log(int n, String string, Object[] objectArray, Throwable throwable) {
        if (n < this.level) {
            return;
        }
        boolean bl = this.level <= 4;
        this.publish(n, this.format(n, string, objectArray, throwable, bl));
    }

    public void logStack(int n, String string, Throwable throwable) {
        if (n < this.level) {
            return;
        }
        this.publish(n, this.format(n, string, null, throwable, true));
    }

    public void logStack(int n, String string, Object object, Throwable throwable) {
        if (n < this.level) {
            return;
        }
        if (object instanceof Object[]) {
            this.publish(n, this.format(n, string, (Object[])object, throwable, true));
        } else {
            Object[] objectArray = new Object[]{object};
            this.publish(n, this.format(n, string, objectArray, throwable, true));
        }
    }

    public void logStack(int n, String string, Object object, Object object2, Throwable throwable) {
        if (n < this.level) {
            return;
        }
        Object[] objectArray = new Object[]{object, object2};
        this.publish(n, this.format(n, string, objectArray, throwable, true));
    }

    public void logStack(int n, String string, Object[] objectArray, Throwable throwable) {
        if (n < this.level) {
            return;
        }
        this.publish(n, this.format(n, string, objectArray, throwable, true));
    }

    public void logToAll(int n, String string, Object[] objectArray) {
        this.publish(64, this.format(n, string, objectArray, null, false));
    }

    public void logToAll(int n, String string) {
        this.publish(64, this.format(n, string, null, null, false));
    }

    public void logToAll(int n, String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        this.publish(64, this.format(n, string, objectArray, null, false));
    }

    public void logToAll(int n, String string, Object object) {
        if (object instanceof Object[]) {
            this.publish(64, this.format(n, string, (Object[])object, null, false));
        } else {
            Object[] objectArray = new Object[]{object};
            this.publish(64, this.format(n, string, objectArray, null, false));
        }
    }
}

