/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.TemplateElement;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

final class BlockAssignment
extends TemplateElement {
    private final String varName;
    private final Expression namespaceExp;
    private final int scope;

    BlockAssignment(TemplateElement nestedBlock, String varName, int scope, Expression namespaceExp) {
        this.nestedBlock = nestedBlock;
        this.varName = varName;
        this.namespaceExp = namespaceExp;
        this.scope = scope;
    }

    void accept(Environment env) throws TemplateException, IOException {
        if (this.nestedBlock != null) {
            env.visit(this.nestedBlock, new CaptureOutput(env), null);
        }
    }

    public String getCanonicalForm() {
        String key;
        switch (this.scope) {
            case 2: {
                key = "local";
                break;
            }
            case 3: {
                key = "global";
                break;
            }
            default: {
                key = "assign";
            }
        }
        return "<#" + key + " " + this.varName + (this.namespaceExp != null ? " in " + this.namespaceExp.getCanonicalForm() : "") + ">" + this.nestedBlock.getCanonicalForm() + "</#" + key + ">";
    }

    public String getDescription() {
        return "block assignment to variable: " + this.varName;
    }

    boolean isIgnorable() {
        return false;
    }

    static /* synthetic */ int access$200(BlockAssignment x0) {
        return x0.scope;
    }

    static /* synthetic */ String access$400(BlockAssignment x0) {
        return x0.varName;
    }

    private class CaptureOutput
    implements TemplateTransformModel {
        private final Environment env;
        private final Environment.Namespace fnsModel;

        CaptureOutput(Environment env) throws TemplateException {
            this.env = env;
            TemplateModel nsModel = null;
            if (BlockAssignment.this.namespaceExp != null && !((nsModel = BlockAssignment.this.namespaceExp.getAsTemplateModel(env)) instanceof Environment.Namespace)) {
                throw new TemplateException("namespace parameter does not specify a namespace. It is a " + nsModel.getClass().getName(), env);
            }
            this.fnsModel = (Environment.Namespace)nsModel;
        }

        public Writer getWriter(Writer out, Map args) {
            return new StringWriter(this){
                private final /* synthetic */ CaptureOutput this$1;
                {
                    this.this$1 = this$1;
                }

                public void close() {
                    SimpleScalar result = new SimpleScalar(this.toString());
                    switch (BlockAssignment.access$200(CaptureOutput.access$100(this.this$1))) {
                        case 1: {
                            if (CaptureOutput.access$300(this.this$1) != null) {
                                CaptureOutput.access$300(this.this$1).put(BlockAssignment.access$400(CaptureOutput.access$100(this.this$1)), result);
                                break;
                            }
                            CaptureOutput.access$500(this.this$1).setVariable(BlockAssignment.access$400(CaptureOutput.access$100(this.this$1)), result);
                            break;
                        }
                        case 2: {
                            CaptureOutput.access$500(this.this$1).setLocalVariable(BlockAssignment.access$400(CaptureOutput.access$100(this.this$1)), result);
                            break;
                        }
                        case 3: {
                            CaptureOutput.access$500(this.this$1).setGlobalVariable(BlockAssignment.access$400(CaptureOutput.access$100(this.this$1)), result);
                        }
                    }
                }
            };
        }

        static /* synthetic */ BlockAssignment access$100(CaptureOutput x0) {
            return x0.BlockAssignment.this;
        }

        static /* synthetic */ Environment.Namespace access$300(CaptureOutput x0) {
            return x0.fnsModel;
        }

        static /* synthetic */ Environment access$500(CaptureOutput x0) {
            return x0.env;
        }
    }
}

