/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Msg {
    private static Hashtable<String, ResourceBundle> gBundles = new Hashtable();
    private static final String USER_BUNDLENAME = "org.openinstaller.resources.user.ResourceMsgs";
    private static final String DEFAULT_BUNDLENAME = "org.openinstaller.resources.ResourceMsgs";
    private static ResourceBundle gUserBundle;
    private static ResourceBundle gDefaultBundle;

    private Msg() {
    }

    public static String get(Class aCallerClass, String aKey, Object ... aArgs) {
        String theFmt = Msg.getFromResourceMsgs(aCallerClass.getPackage().getName(), aKey);
        try {
            return MessageFormat.format(theFmt, aArgs);
        }
        catch (IllegalArgumentException theEx) {
            return "?" + theFmt + "?" + Arrays.toString(aArgs) + "?";
        }
    }

    protected static String getFromResourceMsgs(String aPkgName, String aKey) {
        String theBasename = aPkgName == null || aPkgName.equals("") ? "ResourceMsgs" : aPkgName + ".ResourceMsgs";
        return Msg.get(theBasename, aKey);
    }

    public static String get(String aKey, Object ... aArgs) {
        String theFmt = Msg.getMsgFormat(USER_BUNDLENAME, aKey, Locale.getDefault());
        try {
            return MessageFormat.format(theFmt, aArgs);
        }
        catch (IllegalArgumentException theEx) {
            return "?" + theFmt + "?" + Arrays.toString(aArgs) + "?";
        }
    }

    public static String getWithBundleName(String aBundleName, String aKey, Object ... aArgs) {
        String theFmt = Msg.getMsgFormat(aBundleName, aKey, Locale.getDefault());
        try {
            return MessageFormat.format(theFmt, aArgs);
        }
        catch (IllegalArgumentException theEx) {
            return "?" + theFmt + "?" + Arrays.toString(aArgs) + "?";
        }
    }

    public static String getWithLocaleName(String aBundleName, String aKey, Locale aLocale, Object ... aArgs) {
        String theFmt = Msg.getMsgFormat(aBundleName, aKey, aLocale);
        try {
            return MessageFormat.format(theFmt, aArgs);
        }
        catch (IllegalArgumentException theEx) {
            return "?" + theFmt + "?" + Arrays.toString(aArgs) + "?";
        }
    }

    public static String getMsgFormat(String aBasename, String aKey, Locale aLocale) {
        ResourceBundle theCallerBundle = gBundles.get(aBasename);
        if (theCallerBundle == null) {
            try {
                theCallerBundle = ResourceBundle.getBundle(aBasename, aLocale);
            }
            catch (MissingResourceException theMRE) {
                if (gDefaultBundle == null) {
                    return "Default resource bundle and [" + aBasename + "] bundle" + "cannot be found, cannot translate [" + aKey + "] for locale [" + aLocale + "]";
                }
                theCallerBundle = gDefaultBundle;
            }
            catch (Exception theEx) {
                return "cannot find resource bundle [ " + aBasename + "] for locale [ " + aLocale + "]";
            }
            gBundles.put(aBasename, theCallerBundle);
        }
        try {
            return theCallerBundle.getString(aKey);
        }
        catch (Exception e1) {
            try {
                if (gDefaultBundle == null) {
                    return "Default resource bundle and [" + aBasename + "] bundle" + "cannot be found, cannot translate [" + aKey + "] for locale [" + aLocale + "]";
                }
                return gDefaultBundle.getString(aKey);
            }
            catch (Exception e2) {
                StringBuffer theErr = new StringBuffer();
                theErr.append("[");
                theErr.append(aKey);
                theErr.append("]*[{0} {1}]");
                return theErr.toString();
            }
        }
    }

    static {
        try {
            gDefaultBundle = ResourceBundle.getBundle(DEFAULT_BUNDLENAME, Locale.getDefault());
            gBundles.put(DEFAULT_BUNDLENAME, gDefaultBundle);
        }
        catch (MissingResourceException theMRE) {
            System.err.println("WARNING: cannot load default resource bundle org.openinstaller.resources.ResourceMsgs: " + theMRE.getMessage());
        }
        catch (Exception theEx) {
            System.err.println("WARNING: cannot load default resource bundle org.openinstaller.resources.ResourceMsgs: " + theEx.getMessage());
        }
        try {
            gUserBundle = ResourceBundle.getBundle(USER_BUNDLENAME, Locale.getDefault());
            gBundles.put(USER_BUNDLENAME, gUserBundle);
        }
        catch (MissingResourceException theMRE) {
        }
        catch (Exception theEx) {
            System.err.println("WARNING: cannot load user resource bundle org.openinstaller.resources.user.ResourceMsgs: " + theEx.getMessage());
        }
    }
}

