/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.ui;

import charva.awt.BorderLayout;
import charva.awt.Color;
import charva.awt.Component;
import charva.awt.Container;
import charva.awt.GridBagConstraints;
import charva.awt.GridBagLayout;
import charva.awt.Insets;
import charva.awt.LayoutManager;
import charvax.swing.JFrame;
import charvax.swing.JLabel;
import charvax.swing.JPanel;
import charvax.swing.JProgressBar;
import charvax.swing.JTextField;
import charvax.swing.SwingUtilities;
import charvax.swing.border.Border;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChaxStandaloneSplash
extends JFrame {
    private JPanel gPanel = new JPanel();
    private JLabel gDynText = new JLabel();
    private JProgressBar gProgBar = new JProgressBar();
    private File gTextFile;
    private static Logger gLogger;
    private Properties gResourceBundle;

    private ChaxStandaloneSplash() {
        gLogger = Logger.getLogger(ChaxStandaloneSplash.class.getName());
    }

    public ChaxStandaloneSplash(File aTextFile, Properties aProperties) {
        gLogger = Logger.getLogger(ChaxStandaloneSplash.class.getName());
        this.gTextFile = aTextFile;
        this.gResourceBundle = aProperties;
        try {
            this.splash();
        }
        catch (Exception ex) {
            gLogger.log(Level.FINE, "An error occurred during initialization !");
        }
    }

    final void splash() throws Exception {
        Container theContentPane = this.getContentPane();
        theContentPane.setLayout((LayoutManager)new BorderLayout());
        theContentPane.add((Component)this.gPanel, (Object)"South");
        this.setSize(80, 24);
        this.gPanel.setLayout((LayoutManager)new GridBagLayout());
        String theHeader = this.gResourceBundle.getProperty("SPLASH_HEADER", "");
        String theSubHeader = this.gResourceBundle.getProperty("SPLASH_SUB_HEADER", "");
        String theFooter = this.gResourceBundle.getProperty("SPLASH_FOOTER", "");
        String theSubFooter = this.gResourceBundle.getProperty("SPLASH_SUB_FOOTER", "");
        this.gPanel.add((Component)new JLabel(theHeader), (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 107, 200, new Insets(0, 15, 1, 0), 0, 0));
        this.gPanel.add((Component)new JLabel(theSubHeader), (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 107, 200, new Insets(0, 15, 4, 0), 0, 0));
        this.gPanel.add((Component)this.gDynText, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 107, 200, new Insets(0, 15, 0, 0), 0, 0));
        this.gPanel.add((Component)this.gProgBar, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 107, 200, new Insets(0, 15, 0, 0), 0, 0));
        this.gPanel.add((Component)new JLabel(theFooter), (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 106, 200, new Insets(3, 15, 1, 0), 0, 0));
        this.gPanel.add((Component)new JLabel(theSubFooter), (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 106, 200, new Insets(0, 15, 1, 0), 0, 0));
        JTextField jt = new JTextField(0);
        this.gPanel.add((Component)jt, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 100, 200, new Insets(0, 0, 4, 0), 0, 0));
        this.setFocus((Component)this.gDynText);
        this.setIndeterminateProgress(true);
        this.setProgressBackground(Color.blue);
        this.setProgressMax(100);
        this.validate();
        this.show();
    }

    public final void setDynamicText(String text) {
        String dText = text;
        this.gDynText.setText(dText);
    }

    public final void setDynamicTextColor(Color c) {
        this.gDynText.setForeground(c);
    }

    public final void setProgressBackground(Color c) {
        this.gProgBar.setBackground(c);
    }

    public final void setProgressForeground(Color c) {
        this.gProgBar.setForeground(c);
    }

    public final void setProgressMax(int maxProgress) {
        this.gProgBar.setMaximum(maxProgress);
    }

    public final void setProgressBorder(Border aBorder) {
        this.gProgBar.setBorder(aBorder);
    }

    public final void setIndeterminateProgress(boolean aBoolean) {
        this.gProgBar.setIndeterminate(aBoolean);
    }

    public final void setProgress(int progress) {
        final int theProgress = progress;
        SwingUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ChaxStandaloneSplash.this.gProgBar.setValue(theProgress);
            }
        });
    }

    public final void setProgress(String message, int progress) {
        int theProgress = progress;
        String theMessage = message;
        this.setProgress(progress);
        this.gProgBar.setValue(theProgress);
        this.setMessage(theMessage);
    }

    private void setMessage(String message) {
        String fMsg = message;
        if (fMsg == null) {
            fMsg = "";
            this.gProgBar.setStringPainted(false);
        } else {
            this.gProgBar.setStringPainted(true);
        }
        this.gProgBar.setString(fMsg);
    }

    public final void setScreenVisible(boolean b) {
        this.setVisible(b);
    }
}

