/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui;

import java.awt.GraphicsEnvironment;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.core.EngineConfigCommand;
import org.openinstaller.core.EngineConfigItem;
import org.openinstaller.provider.ui.UserInterfaceWizard;
import org.openinstaller.provider.ui.wizard.CUIWizard;
import org.openinstaller.provider.ui.wizard.GUIWizard;
import org.openinstaller.provider.ui.wizard.SilentWizard;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;

public class WizardFactory {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    private WizardFactory() {
    }

    public static UserInterfaceWizard getWizard() throws EnhancedException {
        BusRequest theDryReq = new BusRequest("DryRunRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.DRY_RUN_FILE));
        BusResponse theDryResp = ControlBus.getInstance().publishRequest(theDryReq, "svc://general/EngineConfig");
        boolean theDryRunFlag = theDryResp.getResult() != null;
        BusRequest theReq = new BusRequest("ConfigRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.DISPLAY_MODE));
        BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/EngineConfig");
        String theDisplayMode = (String)theResp.getResult();
        BusRequest theAnswerReq = new BusRequest("AnswerFileRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.ANSWER_FILES));
        BusResponse theAnswerResp = ControlBus.getInstance().publishRequest(theAnswerReq, "svc://general/EngineConfig");
        ArrayList<URL> theURLs = new ArrayList<URL>();
        if (theAnswerResp.getResult() != null) {
            String[] theAnswerFiles;
            String theAnswerFileSpec = (String)theAnswerResp.getResult();
            for (String theURL : theAnswerFiles = theAnswerFileSpec.split(",")) {
                try {
                    theURLs.add(new URL(theURL));
                }
                catch (MalformedURLException theEx) {
                    throw new EnhancedException("INVALID_ANSWER_FILE_URL", (Throwable)theEx, new String[]{"url=" + theURL});
                }
            }
        }
        URL[] theAnswerURLs = theURLs.toArray(new URL[0]);
        if (theDryRunFlag) {
            if ("CUI".equalsIgnoreCase(theDisplayMode) || GraphicsEnvironment.isHeadless()) {
                LOGGER.fine("Starting CUI mode");
                return CUIWizard.getInstance(theAnswerURLs);
            }
            LOGGER.fine("Starting GUI mode");
            return GUIWizard.getInstance(theAnswerURLs);
        }
        if ("Silent".equalsIgnoreCase(theDisplayMode)) {
            LOGGER.fine("Starting Silent mode");
            return SilentWizard.getInstance(theAnswerURLs);
        }
        if ("CUI".equalsIgnoreCase(theDisplayMode) || GraphicsEnvironment.isHeadless()) {
            LOGGER.fine("Starting CUI mode");
            return CUIWizard.getInstance(theAnswerURLs);
        }
        LOGGER.fine("Starting GUI mode");
        return GUIWizard.getInstance(theAnswerURLs);
    }
}

