/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.pkg;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.pkg.PackageException;
import org.openinstaller.sims.util.TempFileManager;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ExecuteCommand;

public final class RPMPackageUtils {
    public static final String RPM_COMMAND = "/bin/rpm";
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public static void installPkg(URL aSrcPath, String aProdName, String aAltRoot, String aDomain, File aFinalAltRoot, Map<String, String> aResponseMap, boolean aDryRun) throws PackageException {
        ExecuteCommand theCmd;
        List<String> theOthers;
        File theAltRpm;
        String theAltToolPath;
        String theRPMName = aSrcPath.getFile();
        ArrayList<String> theInstallCommand = new ArrayList<String>();
        boolean theAltToolFlag = false;
        File theTempFile = null;
        theInstallCommand.add(RPM_COMMAND);
        if (aResponseMap != null && !aResponseMap.isEmpty()) {
            String theInstallDir = "";
            if (aResponseMap.containsKey("PREFIX")) {
                theInstallDir = aResponseMap.get("PREFIX");
            } else if (aResponseMap.containsKey("BASEDIR")) {
                theInstallDir = aResponseMap.get("BASEDIR");
            }
            if (theInstallDir != null && !theInstallDir.equals("")) {
                theInstallCommand.add("--prefix");
                theInstallCommand.add(theInstallDir);
            }
        }
        if ((theAltToolPath = System.getenv("INSTALL_OSTOOLS")) != null && (theAltRpm = new File(new File(theAltToolPath), RPM_COMMAND)).exists()) {
            theInstallCommand.clear();
            theInstallCommand.add(theAltRpm.getAbsolutePath());
            theAltToolFlag = true;
        }
        if (aDryRun) {
            theInstallCommand.add("--test");
        }
        theInstallCommand.add("--install");
        String theInstallHome = aFinalAltRoot.getAbsolutePath();
        try {
            theOthers = RPMPackageUtils.findAltTags("INSTALL", aSrcPath, aProdName);
        }
        catch (EnhancedException theEx) {
            throw new PackageException(theEx, "RPM_INSTALLATION_FAILED", "package=" + aSrcPath.getPath());
        }
        LOGGER.fine("RPM Flags for " + theRPMName + ": [" + theOthers + "]");
        if (theOthers == null) {
            theInstallCommand.add("--root");
            theInstallCommand.add(theInstallHome);
        } else {
            HashMap<String, String> theSubst = new HashMap<String, String>();
            theSubst.put("INSTALL_HOME", theInstallHome);
            theSubst.put("ALT_ROOT", aAltRoot);
            theSubst.put("DOMAIN", aDomain);
            theSubst.put("TMPDIR", System.getProperty("java.io.tmpdir"));
            try {
                theTempFile = File.createTempFile("rpm", "userlock");
                theSubst.put("TMPFILE", theTempFile.getAbsolutePath());
            }
            catch (IOException theEx) {
                LOGGER.log(Level.WARNING, "CANNOT_CREATE_TMPFILE", theEx);
            }
            Iterator<String> i$ = theOthers.iterator();
            while (i$.hasNext()) {
                String theFlag;
                String theNewFlag = theFlag = i$.next();
                for (String theKey : theSubst.keySet()) {
                    String theSubstVal = (String)theSubst.get(theKey);
                    if (theSubstVal == null) continue;
                    theNewFlag = theNewFlag.replace("%" + theKey + "%", theSubstVal);
                }
                theInstallCommand.add(theNewFlag);
            }
        }
        if ("file".equals(aSrcPath.getProtocol())) {
            theInstallCommand.add(aSrcPath.getPath());
        } else {
            theInstallCommand.add(aSrcPath.toExternalForm());
        }
        try {
            theCmd = new ExecuteCommand(theInstallCommand.toArray(new String[0]));
            if (theAltToolFlag) {
                File theAltLibDir = new File(new File(theAltToolPath), "usr/lib");
                File theAltLibSfwDir = new File(new File(theAltToolPath), "usr/sfw/lib");
                theCmd.putEnvironmentSetting("LD_LIBRARY_PATH", theAltLibDir.getAbsolutePath() + ":" + theAltLibSfwDir.getAbsolutePath());
            }
        }
        catch (EnhancedException theEx) {
            if (theTempFile != null) {
                theTempFile.delete();
            }
            throw new PackageException(theEx, "RPM_INSTALLATION_FAILED", "package=" + aSrcPath.getPath());
        }
        theCmd.setCollectOutput(true);
        theCmd.setOutputType(3);
        try {
            LOGGER.log(Level.INFO, "INSTALLING_RPM", new String[]{"prod=" + aProdName, "command=" + Arrays.toString(theCmd.getCommand())});
            theCmd.execute();
        }
        catch (EnhancedException theEE) {
            throw new PackageException(theEE, "RPM_INSTALLATION_FAILED", "package=" + aSrcPath.getPath(), "output=" + theCmd.getAllOutput());
        }
        finally {
            if (theTempFile != null) {
                theTempFile.delete();
            }
        }
        int theResult = theCmd.getResult();
        if (theResult != 0) {
            throw new PackageException("RPM_INSTALLATION_FAILED", "package=" + aSrcPath.getPath(), "exit-code=" + theResult, "output=" + theCmd.getAllOutput());
        }
        LOGGER.log(Level.INFO, "PACKAGE_INSTALL_SUCCESSFUL", new String[]{"pkg=" + aSrcPath, "prod=" + aProdName});
    }

    private static List<String> findAltTags(String aMode, URL aSrcPath, String aProdName) throws EnhancedException {
        int theIndex;
        String theFullName = aSrcPath.getFile();
        int theSepIndex = theFullName.lastIndexOf(47);
        if (theSepIndex != -1 && theFullName.length() > theSepIndex + 1) {
            theFullName = theFullName.substring(theSepIndex + 1);
        }
        LOGGER.finest("Incoming full src file: " + theFullName);
        if (theFullName.endsWith(".rpm")) {
            theFullName = theFullName.substring(0, theFullName.length() - ".rpm".length());
        }
        InputStream theOptInput = null;
        URL theOptsURL = null;
        for (String theTrialName = theFullName; theTrialName != null; theTrialName = theTrialName.substring(0, theIndex)) {
            try {
                theOptsURL = new URL(aSrcPath, theTrialName + ".rpmoptions");
                LOGGER.fine("Looking for " + theOptsURL.toExternalForm());
                theOptInput = theOptsURL.openStream();
                break;
            }
            catch (IOException theEx) {
                LOGGER.log(Level.FINE, "Cannot find " + theOptsURL, theEx);
                theIndex = theTrialName.lastIndexOf(45);
                if (theIndex == -1) break;
                continue;
            }
        }
        if (theOptInput == null && aProdName != null) {
            try {
                theOptsURL = new URL(aSrcPath, aProdName + ".rpmoptions");
                LOGGER.fine("Looking for " + theOptsURL.toExternalForm());
                theOptInput = theOptsURL.openStream();
            }
            catch (IOException theEx) {
                LOGGER.log(Level.FINE, "Cannot find " + theOptsURL, theEx);
            }
        }
        if (theOptInput == null) {
            try {
                theOptsURL = new URL(aSrcPath, "default.rpmoptions");
                LOGGER.fine("Looking for " + theOptsURL.toExternalForm());
                theOptInput = theOptsURL.openStream();
            }
            catch (IOException theEx) {
                LOGGER.log(Level.FINE, "Cannot find " + theOptsURL, theEx);
            }
        }
        if (theOptInput != null) {
            try {
                if (theOptInput == null) {
                    return null;
                }
                List<String> theParsedOpts = RPMPackageUtils.parseOpts(aMode, theOptInput);
                LOGGER.finest("Parsed opts for " + aSrcPath + ": [" + theParsedOpts + "]");
                return theParsedOpts;
            }
            catch (IOException theEx) {
                throw new EnhancedException("CANNOT_READ_RPMOPTS", (Throwable)theEx, "rpm=" + aSrcPath);
            }
        }
        return null;
    }

    private static List<String> parseOpts(String aMode, InputStream aOptInput) throws IOException {
        BufferedReader theProcessStdin = new BufferedReader(new InputStreamReader(aOptInput));
        ArrayList<String> theUnparsedList = new ArrayList<String>();
        ArrayList<String> theParsedList = new ArrayList<String>();
        String theNextLine = theProcessStdin.readLine();
        while (theNextLine != null) {
            String theTrimmed = theNextLine.trim();
            if (theTrimmed.charAt(0) != '#' && theTrimmed.startsWith(aMode)) {
                String[] theParts = theTrimmed.split("\\s+");
                theUnparsedList.addAll(Arrays.asList(theParts));
                theUnparsedList.remove(0);
                Iterator theIterator = theUnparsedList.iterator();
                while (theIterator.hasNext()) {
                    String theNext = (String)theIterator.next();
                    if (theNext.charAt(0) != '\'') {
                        theParsedList.add(theNext);
                        continue;
                    }
                    StringBuffer theFinalTok = new StringBuffer(theNext.substring(1));
                    while (theIterator.hasNext()) {
                        String theNextNext = (String)theIterator.next();
                        theFinalTok.append(' ');
                        theFinalTok.append(theNextNext.substring(0, theNextNext.length() - 1));
                        if (!theNextNext.endsWith("'")) continue;
                        theParsedList.add(theFinalTok.toString());
                        theFinalTok.setLength(0);
                        break;
                    }
                    if (theFinalTok.length() <= 0) continue;
                    theParsedList.add(theFinalTok.toString());
                    LOGGER.log(Level.WARNING, "UNBALANCED_QUOTES_IN_RPMOPTIONS", "line=" + theParsedList);
                }
                break;
            }
            theNextLine = theProcessStdin.readLine();
        }
        theProcessStdin.close();
        return theParsedList;
    }

    public static void removePkg(String aRPMName, String aAltRoot, String aDomain, File aFinalAltRoot, boolean aDryRun) throws PackageException {
        ExecuteCommand theCmd;
        File theTmp;
        File theAltRpm;
        boolean theAltToolFlag = false;
        ArrayList<String> theUninstallCommand = new ArrayList<String>();
        theUninstallCommand.add(RPM_COMMAND);
        String theAltToolPath = System.getenv("INSTALL_OSTOOLS");
        if (theAltToolPath != null && (theAltRpm = new File(new File(theAltToolPath), RPM_COMMAND)).exists()) {
            theUninstallCommand.clear();
            theUninstallCommand.add(theAltRpm.getAbsolutePath());
            theAltToolFlag = true;
        }
        if (aDryRun) {
            theUninstallCommand.add("--test");
        }
        theUninstallCommand.add("--erase");
        theUninstallCommand.add("--allmatches");
        theUninstallCommand.add("--nodeps");
        theUninstallCommand.add("--noscripts");
        try {
            theTmp = File.createTempFile("rpm", "userlock");
            TempFileManager.registerTempFile((File)theTmp);
        }
        catch (IOException theEx) {
            throw new PackageException(theEx, "CANNOT_CREATE_TMPFILE", new String[0]);
        }
        theUninstallCommand.add("--define");
        theUninstallCommand.add("_rpmlock_path " + theTmp.getAbsolutePath());
        if (aAltRoot != null || aDomain != null) {
            theUninstallCommand.add("--define");
            File theRoot = new File(aFinalAltRoot.getAbsolutePath());
            File theDbPath = new File(theRoot, "var/lib/rpm");
            theUninstallCommand.add("_dbpath " + theDbPath.getAbsolutePath());
        }
        theUninstallCommand.add(aRPMName);
        try {
            theCmd = new ExecuteCommand(theUninstallCommand.toArray(new String[0]));
            if (theAltToolFlag) {
                File theAltLibDir = new File(new File(theAltToolPath), "usr/lib");
                File theAltLibSfwDir = new File(new File(theAltToolPath), "usr/sfw/lib");
                theCmd.putEnvironmentSetting("LD_LIBRARY_PATH", theAltLibDir.getAbsolutePath() + ":" + theAltLibSfwDir.getAbsolutePath());
            }
        }
        catch (EnhancedException theEx) {
            TempFileManager.deleteTempFiles();
            throw new PackageException(theEx, "RPM_UNINSTALLATION_FAILED", "package=" + aRPMName);
        }
        theCmd.setCollectOutput(true);
        theCmd.setOutputType(3);
        try {
            LOGGER.log(Level.INFO, "REMOVING_PKG", new String[]{"pkg=" + aRPMName, "command=" + Arrays.toString(theCmd.getCommand())});
            theCmd.execute();
        }
        catch (EnhancedException theEEx) {
            TempFileManager.deleteTempFiles();
            throw new PackageException(theEEx, "RPM_UNINSTALLATION_FAILED", "package=" + aRPMName);
        }
        TempFileManager.deleteTempFiles();
        int theResult = theCmd.getResult();
        if (theResult != 0) {
            throw new PackageException("RPM_UNINSTALLATION_FAILED", "package=" + aRPMName, "exit-code=" + theResult, "All Output=" + theCmd.getAllOutput());
        }
        LOGGER.log(Level.INFO, "PACKAGE_INSTALL_SUCCESSFUL", new String[]{"pkg=" + aRPMName});
    }

    private RPMPackageUtils() {
    }
}

