/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.substitution;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.openinstaller.util.substitution.ShorthandToken;
import org.openinstaller.util.substitution.SimpleToken;
import org.openinstaller.util.substitution.SubstitutionFactory;
import org.openinstaller.util.substitution.TextToken;
import org.openinstaller.util.substitution.Token;

public class SubstitutionParser {
    private final List<Token> gTokens;

    public SubstitutionParser(Reader aInputSource) throws IOException {
        this.gTokens = this.tokenize(new BufferedReader(aInputSource));
    }

    public Token getFirstToken() {
        return this.gTokens.size() > 0 ? this.gTokens.get(0) : null;
    }

    private List<Token> tokenize(Reader aInput) throws IOException {
        int theChar;
        ArrayList<Token> theTokens = new ArrayList<Token>();
        StringBuilder theBuf = new StringBuilder();
        while ((theChar = aInput.read()) != -1) {
            if (theChar == 58) {
                aInput.mark(1);
                theChar = aInput.read();
                if (theChar == 91) {
                    aInput.mark(1);
                    theChar = aInput.read();
                    if (theChar == 91) {
                        theBuf.append(":[");
                        continue;
                    }
                    aInput.reset();
                    this.addBufferedText(theBuf, theTokens);
                    theTokens.add(this.readVar(aInput));
                    continue;
                }
                aInput.reset();
                theBuf.append(':');
                continue;
            }
            theBuf.append((char)theChar);
        }
        this.addBufferedText(theBuf, theTokens);
        return theTokens;
    }

    private void addBufferedText(StringBuilder aBuf, List<Token> aTokens) {
        if (aBuf.length() > 0) {
            aTokens.add(new TextToken(aBuf));
            aBuf.setLength(0);
        }
    }

    private Token readVar(Reader aInput) throws IOException {
        StringBuilder theVarName = this.readIdentifier(aInput);
        Token theResult = SubstitutionFactory.createToken(theVarName.toString());
        StringBuilder theTokenVariable = this.getVarToken(aInput);
        if (aInput.read() == -1) {
            throw new IOException("Invalid String");
        }
        if (theResult instanceof SimpleToken || theResult instanceof ShorthandToken) {
            theResult.set(theVarName);
        } else {
            theResult.set(theTokenVariable);
        }
        return theResult;
    }

    private boolean isTheEnd(Reader aInput) throws IOException {
        boolean theReturnValue = false;
        if (aInput.read() == 93) {
            theReturnValue = true;
        }
        return theReturnValue;
    }

    private StringBuilder getVarToken(Reader aInput) throws IOException {
        StringBuilder theVarToken = new StringBuilder();
        int theChar = aInput.read();
        while (true) {
            if (theChar == 93 || theChar == -1) break;
            aInput.mark(1);
            theVarToken.append((char)theChar);
            theChar = aInput.read();
        }
        aInput.reset();
        return theVarToken;
    }

    private StringBuilder readIdentifier(Reader aInput) throws IOException {
        StringBuilder aResult = new StringBuilder();
        this.readIdentifier(aInput, "", aResult);
        return aResult;
    }

    private boolean readIdentifier(Reader aInput, String aExtraChars, StringBuilder aResult) throws IOException {
        boolean isIdentifier = true;
        int theCharacter = aInput.read();
        if (!this.isIdentifierStart(theCharacter) && theCharacter != 58 && theCharacter != 47) {
            throw new IOException();
        }
        aResult.append((char)theCharacter);
        while (true) {
            aInput.mark(1);
            theCharacter = aInput.read();
            if (this.isIdentifierChar(theCharacter)) {
                aResult.append((char)theCharacter);
                continue;
            }
            if (aExtraChars.indexOf(theCharacter) == -1) break;
            aResult.append((char)theCharacter);
            isIdentifier = false;
        }
        aInput.reset();
        return isIdentifier;
    }

    private boolean isIdentifierStart(int aCharacter) {
        return aCharacter == 95 || aCharacter != -1 && Character.isLetter((char)aCharacter);
    }

    private boolean isIdentifierChar(int aCharacter) {
        return this.isIdentifierStart(aCharacter) || this.isDigitChar((char)aCharacter);
    }

    private boolean isDigitChar(int aCharacter) {
        return aCharacter != -1 && Character.isDigit((char)aCharacter);
    }

    private boolean isAsciiDigitChar(int aCharacter) {
        return aCharacter >= 48 && aCharacter <= 57;
    }

    private int peek(Reader aInput) throws IOException {
        aInput.mark(1);
        int theCharacter = aInput.read();
        aInput.reset();
        return theCharacter;
    }

    public List<Token> getTokens() {
        return this.gTokens;
    }
}

