/*
 * Decompiled with CFR 0.152.
 */
package org.chaxml;

import charva.awt.Component;
import charva.awt.Container;
import charva.awt.LayoutManager;
import charvax.swing.AbstractButton;
import charvax.swing.Action;
import charvax.swing.ButtonGroup;
import charvax.swing.JComponent;
import charvax.swing.JLabel;
import charvax.swing.JMenu;
import charvax.swing.JMenuBar;
import charvax.swing.JMenuItem;
import charvax.swing.JScrollPane;
import charvax.swing.JSeparator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.chaxml.Converter;
import org.chaxml.ConverterLibrary;
import org.chaxml.Factory;
import org.chaxml.SwingEngine;
import org.chaxml.converters.ConstraintsConverter;
import org.chaxml.converters.LocaleConverter;
import org.chaxml.converters.PrimitiveConverter;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class Parser {
    public static final String ATTR_CONSTRAINTS = "constraints";
    public static final String ATTR_PLAF = "plaf";
    public static final String ATTR_BUNDLE = "bundle";
    public static final String ATTR_LOCALE = "locale";
    public static final String ATTR_ID = "id";
    public static final String ATTR_REFID = "refid";
    public static final String ATTR_USE = "use";
    public static final String ATTR_INCLUDE = "include";
    public static final String ATTR_INITCLASS = "initclass";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_MACOS_PREFIX = "macos_";
    public static final String ATTR_MACOS_PREF = "macos_preferences";
    public static final String ATTR_MACOS_ABOUT = "macos_about";
    public static final String ATTR_MACOS_QUIT = "macos_quit";
    public static final String ATTR_MACOS_OPENAPP = "macos_openapp";
    public static final String ATTR_MACOS_OPENFILE = "macos_openfile";
    public static final String ATTR_MACOS_PRINT = "macos_print";
    public static final String ATTR_MACOS_REOPEN = "macos_reopen";
    public static final String GETINSTANCE = "getInstance";
    public static final Vector LOCALIZED_ATTRIBUTES = new Vector();
    private SwingEngine engine;
    private ConverterLibrary cvtlib = ConverterLibrary.getInstance();
    private Map lbl_map = new HashMap();
    private Map mac_map = new HashMap();
    private Document jdoc;

    public Parser(SwingEngine engine) {
        this.engine = engine;
    }

    public void parse(Document jdoc, Container container) throws Exception {
        this.jdoc = jdoc;
        this.lbl_map.clear();
        this.mac_map.clear();
        this.getSwing(this.processCustomAttributes(jdoc.getRootElement()), container);
        this.linkLabels();
        this.supportMacOS();
        this.lbl_map.clear();
        this.mac_map.clear();
    }

    public Object parse(Document jdoc) throws Exception {
        this.jdoc = jdoc;
        this.lbl_map.clear();
        Object obj = this.getSwing(this.processCustomAttributes(jdoc.getRootElement()), null);
        this.linkLabels();
        this.supportMacOS();
        this.lbl_map.clear();
        this.mac_map.clear();
        return obj;
    }

    private Element processCustomAttributes(Element element) throws Exception {
        Attribute bundle;
        Attribute locale = element.getAttribute(ATTR_LOCALE);
        if (locale != null && locale.getValue() != null) {
            this.engine.setLocale(LocaleConverter.conv(locale));
            element.removeAttribute(ATTR_LOCALE);
        }
        if ((bundle = element.getAttribute(ATTR_BUNDLE)) != null && bundle.getValue() != null) {
            this.engine.getLocalizer().setResourceBundle(bundle.getValue());
            element.removeAttribute(ATTR_BUNDLE);
        }
        return element;
    }

    private void linkLabels() {
        Iterator it = this.lbl_map.keySet().iterator();
        while (it != null && it.hasNext()) {
            JLabel lbl = (JLabel)it.next();
            String id = this.lbl_map.get(lbl).toString();
            lbl.setLabelFor((Component)this.engine.getIdMap().get(id));
        }
    }

    private void supportMacOS() {
        if (!SwingEngine.isMacOSXSupported() || SwingEngine.isMacOSX()) {
            // empty if block
        }
    }

    Object getSwing(Element element, Object obj) throws Exception {
        Attribute actionAttr;
        Factory factory = this.engine.getTaglib().getFactory(element.getName());
        String id = element.getAttribute(ATTR_ID) != null ? element.getAttribute(ATTR_ID).getValue().trim() : null;
        boolean unique = !this.engine.getIdMap().containsKey(id);
        boolean constructed = false;
        if (!unique) {
            throw new IllegalStateException("id already in use: " + id + " : " + this.engine.getIdMap().get(id).getClass().getName());
        }
        if (factory == null) {
            throw new Exception("Unknown TAG, implementation class not defined: " + element.getName());
        }
        if (element.getAttribute(ATTR_INCLUDE) != null) {
            StringTokenizer st = new StringTokenizer(element.getAttribute(ATTR_INCLUDE).getValue(), "#");
            element.removeAttribute(ATTR_INCLUDE);
            Document doc = new SAXBuilder().build(this.engine.getClassLoader().getResourceAsStream(st.nextToken()));
            Element xelem = Parser.find(doc.getRootElement(), st.nextToken());
            if (xelem != null) {
                Parser.moveContent(xelem, element);
            }
        }
        if (element.getAttribute(ATTR_REFID) != null) {
            element = (Element)element.clone();
            this.cloneAttributes(element);
            element.removeAttribute(ATTR_REFID);
        } else if (element.getAttribute(ATTR_USE) != null) {
            element = (Element)element.clone();
            this.cloneAttributes(element);
            element.removeAttribute(ATTR_USE);
        }
        if (obj == null) {
            Object initParameter;
            block40: {
                initParameter = null;
                if (element.getAttribute(ATTR_INITCLASS) != null) {
                    StringTokenizer st = new StringTokenizer(element.getAttributeValue(ATTR_INITCLASS), "( )");
                    element.removeAttribute(ATTR_INITCLASS);
                    try {
                        if (!st.hasMoreTokens()) break block40;
                        Class<?> initClass = Class.forName(st.nextToken());
                        try {
                            Method factoryMethod = initClass.getMethod(GETINSTANCE, new Class[]{null});
                            if (Modifier.isStatic(factoryMethod.getModifiers())) {
                                initParameter = factoryMethod.invoke(null, new Object[]{null});
                            }
                        }
                        catch (NoSuchMethodException nsme) {
                            // empty catch block
                        }
                        if (initParameter == null && st.hasMoreTokens()) {
                            try {
                                Constructor<?> ctor = initClass.getConstructor(String.class);
                                String pattern = st.nextToken();
                                initParameter = ctor.newInstance(pattern);
                            }
                            catch (NoSuchMethodException e) {
                            }
                            catch (SecurityException e) {
                            }
                            catch (InstantiationException e) {
                            }
                            catch (IllegalAccessException e) {
                            }
                            catch (IllegalArgumentException e) {
                            }
                            catch (InvocationTargetException e) {
                                // empty catch block
                            }
                        }
                        if (initParameter == null) {
                            initParameter = initClass.newInstance();
                        }
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("initclass not instantiated : " + e.getLocalizedMessage() + e);
                    }
                    catch (SecurityException e) {
                        System.err.println("initclass not instantiated : " + e.getLocalizedMessage() + e);
                    }
                    catch (IllegalAccessException e) {
                        System.err.println("initclass not instantiated : " + e.getLocalizedMessage() + e);
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println("initclass not instantiated : " + e.getLocalizedMessage() + e);
                    }
                    catch (InvocationTargetException e) {
                        System.err.println("initclass not instantiated : " + e.getLocalizedMessage() + e);
                    }
                    catch (InstantiationException e) {
                        System.err.println("initclass not instantiated : " + e.getLocalizedMessage() + e);
                    }
                    catch (RuntimeException re) {
                        throw re;
                    }
                    catch (Exception e) {
                        throw new Exception("initclass not instantiated : " + e.getLocalizedMessage(), e);
                    }
                }
            }
            obj = initParameter != null ? factory.newInstance(new Object[]{initParameter}) : factory.newInstance();
            constructed = true;
            if (id != null) {
                this.engine.getIdMap().put(id, obj);
            }
        }
        if ((actionAttr = element.getAttribute("Action")) != null) {
            element.removeAttribute(actionAttr);
            element.getAttributes().add(0, actionAttr);
        }
        if (element.getAttribute("Text") == null && 0 < element.getTextTrim().length()) {
            element.getAttributes().add(new Attribute("Text", element.getTextTrim()));
        }
        List remainingAttrs = this.applyAttributes(obj, factory, element.getAttributes());
        LayoutManager layoutMgr = obj instanceof Container ? ((Container)obj).getLayout() : null;
        Iterator it = element.getChildren().iterator();
        while (it != null && it.hasNext()) {
            Element grandchild;
            Element child = (Element)it.next();
            if ("buttongroup".equalsIgnoreCase(child.getName())) {
                int k = JMenu.class.isAssignableFrom(obj.getClass()) ? ((JMenu)obj).getItemCount() : ((Container)obj).getComponentCount();
                this.getSwing(child, obj);
                int n = JMenu.class.isAssignableFrom(obj.getClass()) ? ((JMenu)obj).getItemCount() : ((Container)obj).getComponentCount();
                ButtonGroup btnGroup = new ButtonGroup();
                while (k < n) {
                    Parser.putIntoBtnGrp(JMenu.class.isAssignableFrom(obj.getClass()) ? ((JMenu)obj).getItem(k++) : ((Container)obj).getComponent(k++), btnGroup);
                }
                continue;
            }
            Attribute constrnAttr = child.getAttribute(ATTR_CONSTRAINTS);
            Object constrains = null;
            if (constrnAttr != null && layoutMgr != null) {
                child.removeAttribute(ATTR_CONSTRAINTS);
                constrains = ConstraintsConverter.convert(layoutMgr.getClass(), constrnAttr);
            }
            if ((grandchild = child.getChild("gridbagconstraints")) != null) {
                Parser.addChild((Component)obj, (Component)this.getSwing(child, null), this.getSwing(grandchild, null));
                continue;
            }
            if (child.getName().equals("gridbagconstraints")) continue;
            Parser.addChild((Component)obj, (Component)this.getSwing(child, null), constrains);
        }
        if (remainingAttrs != null && 0 < remainingAttrs.size() && (remainingAttrs = this.applyAttributes(obj, factory, remainingAttrs)) != null) {
            it = remainingAttrs.iterator();
            while (it != null && it.hasNext()) {
                Attribute attr = (Attribute)it.next();
                if (!JComponent.class.isAssignableFrom(obj.getClass())) continue;
                ((JComponent)obj).putClientProperty((Object)attr.getName(), (Object)attr.getValue());
            }
        }
        return constructed ? obj : null;
    }

    private List applyAttributes(Object obj, Factory factory, List attributes) throws Exception {
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attr = (Attribute)attributes.get(i);
            if (!ATTR_ACTION.equalsIgnoreCase(attr.getName())) continue;
            attributes.remove(i);
            attributes.add(0, attr);
            break;
        }
        Iterator it = attributes.iterator();
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        Action action = null;
        while (it != null && it.hasNext()) {
            Converter converter;
            Attribute attr = (Attribute)it.next();
            if (ATTR_ID.equals(attr.getName()) || ATTR_REFID.equals(attr.getName()) || ATTR_USE.equals(attr.getName())) continue;
            if (JLabel.class.isAssignableFrom(obj.getClass()) && attr.getName().equalsIgnoreCase("LabelFor")) {
                this.lbl_map.put(obj, attr.getValue());
                continue;
            }
            Method method = factory.guessSetter(attr.getName());
            if (method != null) {
                Class<?> paraType = method.getParameterTypes()[0];
                converter = this.cvtlib.getConverter(paraType);
                if (converter != null) {
                    Object para = null;
                    try {
                        if (Action.class.equals(paraType)) {
                            para = this.engine.getClient().getClass().getField(attr.getValue()).get(this.engine.getClient());
                            action = (Action)para;
                        } else {
                            para = obj instanceof AbstractButton && paraType.getName().compareTo("int") == 0 && attr.getName().compareTo("mnemonic") == 0 ? new Integer(attr.getValue().charAt(0)) : converter.convert(paraType, attr, this.engine.getLocalizer());
                        }
                        method.invoke(obj, para);
                        continue;
                    }
                    catch (NoSuchFieldException e) {
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        list.add(attr);
                        continue;
                    }
                    catch (Exception e) {
                        throw new Exception(e + ":" + method.getName() + ":" + para, e);
                    }
                }
                if (paraType.equals(Object.class)) {
                    try {
                        String s = attr.getValue();
                        if (LOCALIZED_ATTRIBUTES.contains(attr.getName().toLowerCase()) && attr.getAttributeType() == 1) {
                            s = this.engine.getLocalizer().getString(s);
                        }
                        method.invoke(obj, s);
                    }
                    catch (Exception e) {
                        list.add(attr);
                    }
                    continue;
                }
                if (paraType.isPrimitive()) {
                    try {
                        method.invoke(obj, PrimitiveConverter.conv(paraType, attr, this.engine.getLocalizer()));
                    }
                    catch (Exception e) {
                        list.add(attr);
                    }
                    continue;
                }
                list.add(attr);
                continue;
            }
            try {
                Field field = obj.getClass().getField(attr.getName());
                if (field != null) {
                    converter = this.cvtlib.getConverter(field.getType());
                    if (converter != null) {
                        Object fieldValue = converter.convert(field.getType(), attr, null);
                        if (String.class.equals((Object)converter.convertsTo())) {
                            fieldValue = this.engine.getLocalizer().getString((String)fieldValue);
                        }
                        field.set(obj, fieldValue);
                        continue;
                    }
                    list.add(attr);
                    continue;
                }
                list.add(attr);
            }
            catch (Exception e) {
                list.add(attr);
            }
        }
        return list;
    }

    private void cloneAttributes(Element target) {
        Element source = null;
        if (target.getAttribute(ATTR_REFID) != null) {
            source = Parser.find(this.jdoc.getRootElement(), target.getAttribute(ATTR_REFID).getValue().trim());
        } else if (target.getAttribute(ATTR_USE) != null) {
            source = Parser.find(this.jdoc.getRootElement(), target.getAttribute(ATTR_USE).getValue().trim());
        }
        if (source != null) {
            Iterator it = source.getAttributes().iterator();
            while (it != null && it.hasNext()) {
                Attribute attr = (Attribute)it.next();
                String name = attr.getName().trim();
                if (ATTR_ID.equals(name) || target.getAttribute(name) != null) continue;
                Attribute attrcln = (Attribute)attr.clone();
                attrcln.detach();
                target.setAttribute(attrcln);
            }
        }
    }

    private static Component addChild(Component parent, Component component, Object constrains) {
        if (component == null) {
            return null;
        }
        if (component instanceof JMenuBar) {
            try {
                Method m = parent.getClass().getMethod("setJMenuBar", JMenuBar.class);
                if (m != null) {
                    m.invoke((Object)parent, component);
                } else if (parent instanceof Container) {
                    ((Container)parent).add(component);
                }
            }
            catch (Exception e) {}
        } else if (parent instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)parent;
            scrollPane.setViewportView(component);
        } else if (parent instanceof JMenuBar && component instanceof JMenu) {
            JMenuBar menuBar = (JMenuBar)parent;
            menuBar.add(component, constrains);
        } else if (JSeparator.class.isAssignableFrom(component.getClass())) {
            if (parent instanceof Container) {
                if (constrains != null) {
                    ((Container)parent).add(component, constrains);
                } else {
                    ((Container)parent).add(component);
                }
            } else if (parent instanceof JMenu) {
                ((JMenu)parent).addSeparator();
            }
        } else if (parent instanceof JMenu && component instanceof JMenuItem) {
            ((JMenu)parent).add((JMenuItem)component);
        } else if (parent instanceof Container) {
            if (constrains == null) {
                ((Container)parent).add(component);
            } else {
                ((Container)parent).add(component, constrains);
            }
        }
        return component;
    }

    private static void moveContent(Element source, Element target) {
        List list = source.getContent();
        while (!list.isEmpty()) {
            Object obj = list.remove(0);
            target.getContent().add(obj);
        }
    }

    private static Element find(Element element, String id) {
        Element elem = null;
        Attribute attr = element.getAttribute(ATTR_ID);
        if (attr != null && id.equals(attr.getValue().trim())) {
            elem = element;
        } else {
            Iterator it = element.getChildren().iterator();
            while (it != null && it.hasNext() && elem == null) {
                elem = Parser.find((Element)it.next(), id.trim());
            }
        }
        return elem;
    }

    private static void putIntoBtnGrp(Object obj, ButtonGroup grp) throws Exception {
        if (AbstractButton.class.isAssignableFrom(obj.getClass())) {
            grp.add((AbstractButton)obj);
        } else if (Container.class.isAssignableFrom(obj.getClass())) {
            Container jp = (Container)obj;
            for (int i = 0; i < jp.getComponentCount(); ++i) {
                Parser.putIntoBtnGrp(jp.getComponent(i), grp);
            }
        }
    }

    static {
        LOCALIZED_ATTRIBUTES.add("accelerator");
        LOCALIZED_ATTRIBUTES.add("icon");
        LOCALIZED_ATTRIBUTES.add("iconimage");
        LOCALIZED_ATTRIBUTES.add("label");
        LOCALIZED_ATTRIBUTES.add("mnemonic");
        LOCALIZED_ATTRIBUTES.add("name");
        LOCALIZED_ATTRIBUTES.add("text");
        LOCALIZED_ATTRIBUTES.add("title");
        LOCALIZED_ATTRIBUTES.add("titleat");
        LOCALIZED_ATTRIBUTES.add("titles");
        LOCALIZED_ATTRIBUTES.add("tooltiptext");
    }
}

