/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.config.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.openinstaller.bindings.config.oor.schema.ComponentSchema;
import org.openinstaller.config.PropertySheet;
import org.openinstaller.provider.conf.OORUtils;
import org.openinstaller.provider.conf.oor.OORComponent;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ExecuteCommand;
import org.openinstaller.util.GetOpt;
import org.openinstaller.util.Platform;

public final class WrapperHelper {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private String gXCS;
    private String gXCU;
    private boolean gReset;
    private String gAlternateRoot;

    private WrapperHelper() {
    }

    private WrapperHelper(String aXCS, String aXCU, boolean aReset, String aAlternateRoot) {
        this.gXCS = aXCS;
        this.gXCU = aXCU;
        this.gReset = aReset;
        this.gAlternateRoot = aAlternateRoot;
    }

    public static Object parseCmdLine(String[] aArg) throws EnhancedException {
        String theXCSFile = null;
        String theXCUFile = null;
        String theAltRoot = null;
        boolean theFlag = false;
        boolean theResetFlag = false;
        GetOpt theOptionParser = new GetOpt(aArg, "f:R:d:r;s;");
        int theOption = theOptionParser.getNextOption();
        while (theOption != -1) {
            LOGGER.log(Level.FINE, "OPTION=" + (char)theOption);
            switch ((char)theOption) {
                case 'f': {
                    theXCSFile = theOptionParser.getOptionArg();
                    LOGGER.log(Level.FINE, "OOR FILE :" + theXCSFile);
                    break;
                }
                case 'd': {
                    theFlag = true;
                    theXCUFile = theOptionParser.getOptionArg();
                    LOGGER.log(Level.FINE, "OOR UPDATE FILE :" + theXCUFile);
                    break;
                }
                case 'r': {
                    theResetFlag = true;
                    LOGGER.log(Level.FINE, "RESET FLAG :" + theResetFlag);
                    break;
                }
                case 'R': {
                    theAltRoot = theOptionParser.getOptionArg();
                    LOGGER.log(Level.FINE, "ALTERNATE ROOT :" + theAltRoot);
                    break;
                }
                case 's': {
                    break;
                }
                default: {
                    throw new EnhancedException("UNKNOWN_OPT", new String[]{"option=" + (char)theOption});
                }
            }
            theOption = theOptionParser.getNextOption();
        }
        if (theXCSFile == null && !theResetFlag || theFlag && theXCUFile == null && !theResetFlag || theXCSFile != null && theXCUFile != null && theResetFlag) {
            throw new EnhancedException("PARSE_CMD_LINE_USAGE", new String[0]);
        }
        return new WrapperHelper(theXCSFile, theXCUFile, theResetFlag, theAltRoot);
    }

    public String getXCS() {
        return this.gXCS;
    }

    public String getXCU() {
        return this.gXCU;
    }

    public boolean getResetFlag() {
        return this.gReset;
    }

    public String getAlternateRoot() {
        return this.gAlternateRoot;
    }

    public static PropertySheet getPropSheet(String aXCSFile, String aXCUFile) throws EnhancedException {
        LOGGER.log(Level.FINE, "OOR FILE PATH:" + aXCSFile);
        LOGGER.log(Level.FINE, "OOR UPDATE FILE PATH:" + aXCUFile);
        File theXCSFileHandler = new File(aXCSFile);
        String theXCSFilePath = theXCSFileHandler.getAbsolutePath();
        File theXCUFileHandler = null;
        String theXCUFilePath = null;
        if (aXCUFile != null) {
            theXCUFileHandler = new File(aXCUFile);
            theXCUFilePath = theXCUFileHandler.getAbsolutePath();
        }
        OORComponent theSchema = null;
        try {
            JAXBContext theContext = JAXBContext.newInstance((String)"org.openinstaller.bindings.config.oor.schema");
            Unmarshaller theUnMarshaller = theContext.createUnmarshaller();
            ComponentSchema theComponentSchema = (ComponentSchema)theUnMarshaller.unmarshal((InputStream)new FileInputStream(theXCSFilePath));
            theSchema = OORUtils.createOORComponent((ComponentSchema)theComponentSchema);
        }
        catch (JAXBException theEx) {
            throw new EnhancedException("FILE_FORMAT_INVALID", (Throwable)theEx, new String[]{"OORfile=" + theXCSFilePath});
        }
        catch (FileNotFoundException theEx) {
            throw new EnhancedException("FILE_NOT_FOUND", (Throwable)theEx, new String[]{"OORfile=" + theXCSFilePath});
        }
        catch (EnhancedException theEx) {
            theEx.addContext("INVALID_FILE", new String[]{"OORfile=" + theXCSFilePath});
            throw theEx;
        }
        PropertySheet thePS = new PropertySheet();
        if (aXCSFile != null && aXCUFile == null) {
            thePS.read(theSchema, null);
        } else if (aXCSFile != null && aXCUFile != null) {
            try {
                thePS.read(theSchema, new FileInputStream(theXCUFileHandler));
            }
            catch (FileNotFoundException theFNFEx) {
                throw new EnhancedException("FILE_NOT_FOUND", (Throwable)theFNFEx, new String[]{"OORupdatefile=" + theXCUFilePath});
            }
        }
        return thePS;
    }

    public static File createConfigFile(PropertySheet aConfig) throws EnhancedException {
        File theConfigFile = null;
        String theValue = null;
        try {
            theConfigFile = File.createTempFile("config", null);
            theConfigFile.deleteOnExit();
            WrapperHelper.setReadonly(theConfigFile);
            LOGGER.log(Level.FINE, "TEMP CONFIG FILE :" + theConfigFile.getAbsolutePath());
            FileWriter theFileWriter = null;
            Map<String, String> theListProperties = aConfig.getAllProps();
            Set<String> theListOfKeys = theListProperties.keySet();
            theFileWriter = new FileWriter(theConfigFile, false);
            for (String theKey : theListOfKeys) {
                theValue = theListProperties.get(theKey);
                LOGGER.log(Level.FINE, "KEY: " + theKey + "==" + "VALUE: " + theValue);
                theFileWriter.write(theKey + "=" + theValue);
                theFileWriter.write("\n");
            }
            theFileWriter.close();
        }
        catch (IOException theIOEx) {
            LOGGER.log(Level.SEVERE, "COULD_NOT_CREATE_FILE" + theConfigFile);
            throw new EnhancedException("COULD_NOT_CREATE_FILE", (Throwable)theIOEx, new String[]{"file=" + theConfigFile});
        }
        return theConfigFile;
    }

    private static void setReadonly(File aFile) throws EnhancedException {
        try {
            switch (Platform.getCurrentOsType()) {
                case UNIX: {
                    String[] theCmdStr = null;
                    switch (Platform.getCurrentOsName()) {
                        case SOLARIS: {
                            theCmdStr = new String[]{"/usr/bin/chmod", "600", aFile.getAbsolutePath()};
                            break;
                        }
                        default: {
                            theCmdStr = new String[]{"/bin/chmod", "600", aFile.getAbsolutePath()};
                        }
                    }
                    ExecuteCommand theCmd = new ExecuteCommand(theCmdStr);
                    theCmd.setCollectOutput(true);
                    theCmd.setOutputType(3);
                    theCmd.execute();
                    if (theCmd.getResult() == 0) break;
                    throw new EnhancedException("COULD_NOT_CHANGE_READONLY_FOR_FILE", new String[]{"file=" + aFile.getAbsolutePath()});
                }
                case WINDOWS: 
                case BE: 
                case UNDEFINED: 
                case MAC: {
                    LOGGER.log(Level.FINE, "COULD_NOT_CHANGE_READONLY_FOR_FILE" + aFile.getAbsolutePath());
                }
            }
        }
        catch (EnhancedException theEnhEx) {
            theEnhEx.addContext("COULD_NOT_CHANGE_READONLY_FOR_FILE", new String[]{"file=" + aFile.getAbsolutePath()});
            throw theEnhEx;
        }
    }

    public static void printResultReport(String aConfigStatus, String aPlatformError, String aProductError, String aDocReference, String aNextSteps) {
        System.err.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        System.err.print("<resultReport xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>");
        System.err.print("<configStatus>" + aConfigStatus + "</configStatus>");
        System.err.print("<platformError>" + aPlatformError + "</platformError>");
        System.err.print("<productError>" + aProductError + "</productError>");
        System.err.print("<docReference>" + aDocReference + "</docReference>");
        System.err.print("<nextSteps>" + aNextSteps + "</nextSteps>");
        System.err.print("</resultReport>");
    }
}

