/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.productselection;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusEvent;
import org.openinstaller.bus.BusException;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.NoSuchMemberException;
import org.openinstaller.bus.ServiceProvider;
import org.openinstaller.contracts.product.PSPBusRequestType;
import org.openinstaller.contracts.product.PSPControl;
import org.openinstaller.contracts.product.ProductNodeInterface;
import org.openinstaller.core.EngineConfigCommand;
import org.openinstaller.core.EngineConfigItem;
import org.openinstaller.core.PROCESSING_MODE;
import org.openinstaller.provider.conf.ConfigHelper;
import org.openinstaller.provider.dependency.DependencyControl;
import org.openinstaller.provider.dependency.MediaProduct;
import org.openinstaller.provider.operation.Operation;
import org.openinstaller.provider.operation.OpsControl;
import org.openinstaller.provider.operation.ProductMap;
import org.openinstaller.sims.Backend;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Version;
import org.openinstaller.util.install.Common;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductSelectionProvider
implements ServiceProvider {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public final void init(ControlBus aBus) throws BusException {
    }

    public final void shutdown() throws BusException {
    }

    public final void receiveEvent(ControlBus aBus, BusEvent aEvent) {
    }

    public String getName() {
        return "svc://general/product";
    }

    public void receiveRequest(ControlBus aBus, BusRequest aReq, BusResponse aResp) {
        EnhancedException theException = null;
        if (!PSPControl.class.isInstance(aReq.getData())) {
            aResp.setException((Exception)((Object)new EnhancedException("INVALID_OPS_REQUEST", new String[]{"request=" + aReq})));
            return;
        }
        switch (((PSPControl)aReq.getData()).getCommand()) {
            case GET_AVAILABLE_PRODUCTS: {
                Object thePSPData = ((PSPControl)aReq.getData()).getData();
                LOGGER.finest(ClassUtils.getClassName() + " received a request");
                if (!PSPBusRequestType.class.isInstance(thePSPData)) {
                    aResp.setFinalResult(null);
                    aResp.setException((Exception)((Object)new EnhancedException("INVALID_PRODUCTLIST_REQUEST", new String[]{"request=" + aReq})));
                    return;
                }
                PSPBusRequestType theRequest = (PSPBusRequestType)thePSPData;
                try {
                    String theProcessingMode = Common.getProcessingMode();
                    if (!PROCESSING_MODE.INSTALL.name().equals(theProcessingMode) && !PROCESSING_MODE.REMOVE.name().equals(theProcessingMode)) {
                        aResp.setException((Exception)((Object)new EnhancedException("UNEXPECTED_PROCESSING_MODE", new String[0])));
                        aResp.setFinalResult(null);
                        return;
                    }
                    String INSTALLHOME_DATAPATH = "InstallHome.directory.INSTALL_HOME";
                    String theInstallHome = (String)ConfigHelper.getValue("InstallHome.directory.INSTALL_HOME");
                    ProductMap theProdMap = ProductSelectionProvider.getProductMap(aBus, theInstallHome);
                    Operation.OPTYPE gOpType = theProdMap.getOperation();
                    boolean theNoUpgradeFlag = ProductSelectionProvider.isNoUpgradeFlagPresent(aBus, gOpType);
                    Set<SystemProduct> theInstalledProducts = theProdMap.getSystemModel();
                    for (SystemProduct theSystemProduct : theInstalledProducts) {
                        LOGGER.finest(ClassUtils.getClassName() + ": " + theSystemProduct.getID() + " is installed.");
                    }
                    MediaProduct theAvailableProductsModel = theProdMap.getMediaModel();
                    if (PROCESSING_MODE.REMOVE.name().equals(theProcessingMode)) {
                        aResp.setFinalResult(ProductSelectionProvider.removableTreeWalk(theInstalledProducts, theRequest.isGetFeatures(), theRequest.isGetDependencies()));
                        break;
                    }
                    if (!PROCESSING_MODE.INSTALL.name().equals(theProcessingMode)) break;
                    aResp.setFinalResult(this.installableTreeWalk(aBus, theAvailableProductsModel, theInstalledProducts, theRequest.isGetFeatures(), theRequest.isGetDependencies(), theRequest.isRootIsAContainer(), true));
                }
                catch (EnhancedException theEE) {
                    LOGGER.log(Level.FINE, "Cannot determine system model");
                    theException = theEE;
                }
                break;
            }
            case GET_SELECTED_PRODUCTS: {
                try {
                    String PRODUCT_SELECTION_DATAPATH = "ProductSelection.product.PRODUCT_SELECTION";
                    String theSelectedProductsStr = (String)ConfigHelper.getValue("ProductSelection.product.PRODUCT_SELECTION");
                    LOGGER.finest("Product selection list = " + theSelectedProductsStr);
                    aResp.setFinalResult(this.getSelectedProducts(theSelectedProductsStr));
                    break;
                }
                catch (EnhancedException theEE) {
                    theException = theEE;
                }
            }
        }
        if (theException != null) {
            aResp.setException((Exception)((Object)theException));
        }
    }

    private static Set<? extends ProductNodeInterface> removableTreeWalk(Set<? extends SystemProduct> aSystemProducts, boolean aShowFeatures, boolean aShowDependencies) {
        LOGGER.finest("In " + ClassUtils.getFQMethodName());
        LOGGER.finest("aShowFeatures " + aShowFeatures);
        LOGGER.finest("aShowDependencies " + aShowDependencies);
        LinkedHashSet<Object> theReturnSet = new LinkedHashSet<Object>();
        for (SystemProduct systemProduct : aSystemProducts) {
            LOGGER.finest(ClassUtils.getFQMethodName() + ": Inspecting " + systemProduct.getID());
            Backend.EntityState theState = systemProduct.getState();
            LOGGER.finest("EntityState = " + theState.name());
            if (systemProduct.getState() != Backend.EntityState.NOT_INSTALLED) {
                LOGGER.finest(ClassUtils.getFQMethodName() + ": Adding " + systemProduct.getID() + " to return set");
                theReturnSet.add(systemProduct);
            }
            if (aShowFeatures) {
                LOGGER.finest(ClassUtils.getFQMethodName() + ": Will inspect features for " + systemProduct.getID());
                theReturnSet.addAll(ProductSelectionProvider.removableTreeWalk(systemProduct.getFeatures(), aShowFeatures, aShowDependencies));
            }
            if (!aShowDependencies) continue;
            LOGGER.finest(ClassUtils.getFQMethodName() + ": Will inspect dependencies for " + systemProduct.getID());
            theReturnSet.addAll(ProductSelectionProvider.removableTreeWalk(systemProduct.getDependencies(), aShowFeatures, aShowDependencies));
        }
        LOGGER.finest(ClassUtils.getFQMethodName() + ": Returning " + theReturnSet);
        return theReturnSet;
    }

    private Set<? extends ProductNodeInterface> installableTreeWalk(ControlBus aBus, MediaProduct aMediaProduct, Set<SystemProduct> aInstalledProducts, boolean aShowFeatures, boolean aShowDependencies, boolean aRootIsAContainer, boolean aThisIsRoot) throws EnhancedException {
        DependencyControl theDC;
        LOGGER.finest(ClassUtils.getFQMethodName() + " inspecting " + aMediaProduct.getID());
        LOGGER.finest("aShowFeatures " + aShowFeatures);
        LOGGER.finest("aShowDependencies " + aShowDependencies);
        LOGGER.finest("aRootIsAContainer " + aRootIsAContainer);
        LinkedHashSet<Object> theReturnSet = new LinkedHashSet<Object>();
        LOGGER.finest(ClassUtils.getFQMethodName() + ": Inspecting " + aMediaProduct.getID());
        Version theInstalledVersion = ProductSelectionProvider.getInstalledVersion(aMediaProduct, aInstalledProducts);
        if (aRootIsAContainer && aThisIsRoot) {
            theDC = new DependencyControl(DependencyControl.COMMAND.FORCE_SELECT_ELEMENT, aMediaProduct.getID());
            if (!aShowFeatures) {
                for (MediaProduct theMediaProduct : aMediaProduct.getFeatures()) {
                    theReturnSet.add(theMediaProduct);
                }
            }
        } else {
            theDC = new DependencyControl(DependencyControl.COMMAND.FORCE_DESELECT_ELEMENT, aMediaProduct.getID());
        }
        aBus.publishRequest(new BusRequest("The Force", (Object)theDC), "svc://general/Dependency");
        if (!(null != theInstalledVersion && theInstalledVersion.compareTo(aMediaProduct.getVersion()) >= 0 || aThisIsRoot && aRootIsAContainer)) {
            LOGGER.finest(ClassUtils.getFQMethodName() + ": Adding " + aMediaProduct.getID() + " to return set");
            theReturnSet.add(aMediaProduct);
        }
        for (MediaProduct theMediaProduct : aMediaProduct.getFeatures()) {
            Set<? extends ProductNodeInterface> theFeatures = this.installableTreeWalk(aBus, theMediaProduct, aInstalledProducts, aShowFeatures, aShowDependencies, aRootIsAContainer, false);
            if (!aShowFeatures) continue;
            theReturnSet.addAll(theFeatures);
        }
        for (MediaProduct theMediaProduct : aMediaProduct.getDependencies()) {
            Set<? extends ProductNodeInterface> theDependencies = this.installableTreeWalk(aBus, theMediaProduct, aInstalledProducts, aShowFeatures, aShowDependencies, aRootIsAContainer, false);
            if (!aShowDependencies) continue;
            theReturnSet.addAll(theDependencies);
        }
        return theReturnSet;
    }

    private List<String> getSelectedProducts(String aSelectedProductList) {
        String[] theSelectedProds;
        ArrayList<String> theReturnList = new ArrayList<String>();
        if (null == aSelectedProductList || "".equals(aSelectedProductList)) {
            return theReturnList;
        }
        for (String theProduct : theSelectedProds = aSelectedProductList.split(",")) {
            theReturnList.add(theProduct);
        }
        return theReturnList;
    }

    private static Version getInstalledVersion(ProductNodeInterface aProduct, Set<SystemProduct> aInstalledProducts) {
        for (SystemProduct theInstalledProduct : aInstalledProducts) {
            if (!theInstalledProduct.getID().equalsIgnoreCase(aProduct.getID()) || theInstalledProduct.getState() != Backend.EntityState.INSTALLED) continue;
            return theInstalledProduct.getRelease();
        }
        return null;
    }

    private static ProductMap getProductMap(ControlBus aBus, String aInstallHome) throws EnhancedException {
        OpsControl theOpsCmd = new OpsControl(OpsControl.OpsCommand.GET_PRODUCT_MAP, aInstallHome);
        BusResponse theProdMapResp = aBus.publishRequest(new BusRequest("ProductMapRequest", (Object)theOpsCmd), "svc://general/operation");
        if (theProdMapResp == null) {
            throw new EnhancedException("CANNOT_CREATE_PRODUCT_MAP", new String[0]);
        }
        if (theProdMapResp.getException() != null) {
            throw new EnhancedException("CANNOT_CREATE_PRODUCT_MAP", (Throwable)theProdMapResp.getException(), new String[0]);
        }
        Object theProdMap = theProdMapResp.getResult();
        if (theProdMap == null) {
            throw new EnhancedException("CANNOT_CREATE_PRODUCT_MAP", new String[0]);
        }
        return (ProductMap)theProdMap;
    }

    private static boolean isNoUpgradeFlagPresent(ControlBus aBus, Operation.OPTYPE aOpType) throws NoSuchMemberException, InvalidArgumentException {
        String theUpResult;
        BusRequest theUpgradeFlagReq;
        BusResponse theUpgradeResp;
        return Operation.OPTYPE.UPGRADE == aOpType && (theUpgradeResp = aBus.publishRequest(theUpgradeFlagReq = new BusRequest("NoUpgradeFlagRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.NO_UPGRADE)), "svc://general/EngineConfig")) != null && theUpgradeResp.getException() == null && "true".equalsIgnoreCase(theUpResult = (String)theUpgradeResp.getResult());
    }
}

