/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.openinstaller.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIResourceLoader
extends URLClassLoader {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public UIResourceLoader() {
        super(new URL[0]);
        LOGGER.fine("UIResourceLoader() constructor");
    }

    public void addURLToPath(URL aURL) {
        super.addURL(aURL);
        LOGGER.fine("UIResourceLoader.addURLToPath(" + aURL + ")");
    }

    public UIResourceLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public UIResourceLoader(URL[] urls) {
        super(urls);
    }

    @Override
    protected Class<?> findClass(String aName) throws ClassNotFoundException {
        LOGGER.fine("UIResourceLoader.findClass(" + aName + ")");
        return super.findClass(aName);
    }

    @Override
    public URL findResource(String aName) {
        LOGGER.fine("UIResourceLoader.findResource(" + aName + ")");
        URL theFoundResource = null;
        URL[] theURLs = super.getURLs();
        LOGGER.fine("  looking for " + aName);
        for (URL theURL : theURLs) {
            try {
                if (new URL(theURL, aName).openConnection() == null) continue;
                theFoundResource = theURL;
                break;
            }
            catch (IOException theIOException) {
                // empty catch block
            }
        }
        return theFoundResource;
    }

    @Override
    public Enumeration<URL> findResources(String aName) throws IOException {
        LOGGER.fine("UIResourceLoader.findResources(" + aName + ")");
        return super.findResources(aName);
    }
}

