/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.JDKSelection.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.JDKSelection.utils.StreamUtils;
import org.openinstaller.util.JDKSelection.utils.exceptions.DownloadException;

public class FileProxy {
    private static final String RESOURCE_SCHEME = "resource";
    public static final String RESOURCE_SCHEME_PREFIX = "resource:";
    private final File tmpDir = new File(System.getProperty("java.io.tmpdir"));
    private final Map<String, File> cache = new HashMap<String, File>();
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    public static final FileProxy proxy = new FileProxy();

    public FileProxy() {
        this.tmpDir.mkdirs();
        this.tmpDir.deleteOnExit();
    }

    public static FileProxy getInstance() {
        return proxy;
    }

    public File getFile(String uri) throws DownloadException {
        return this.getFile(uri, null, false);
    }

    public File getFile(String uri, boolean deleteOnExit) throws DownloadException {
        return this.getFile(uri, null, deleteOnExit);
    }

    public File getFile(String uri, ClassLoader loader) throws DownloadException {
        return this.getFile(uri, loader, false);
    }

    public File getFile(String uri, ClassLoader loader, boolean deleteOnExit) throws DownloadException {
        URI myUri;
        try {
            myUri = new URI(uri);
        }
        catch (URISyntaxException ex) {
            throw new DownloadException("uri:" + uri, ex);
        }
        return this.getFile(myUri, loader, deleteOnExit);
    }

    public File getFile(URI uri) throws DownloadException {
        return this.getFile(uri, null, false);
    }

    public File getFile(URI uri, ClassLoader loader, boolean deleteOnExit) throws DownloadException {
        if (this.cache.containsKey(uri.toString()) && this.cache.get(uri.toString()).exists()) {
            return this.cache.get(uri.toString());
        }
        if (uri.getScheme().equals("file")) {
            File file = new File(uri);
            if (!file.exists()) {
                throw new DownloadException("file does not exist: " + uri);
            }
            return file;
        }
        if (uri.getScheme().equals(RESOURCE_SCHEME)) {
            OutputStream out = null;
            try {
                String path = uri.getSchemeSpecificPart();
                File file = new File(this.tmpDir, path.substring(path.lastIndexOf(47)));
                String fileName = file.getName();
                File parent = file.getParentFile();
                int i = 0;
                while (file.exists()) {
                    file = new File(parent, fileName + "." + i);
                    ++i;
                }
                file.createNewFile();
                if (deleteOnExit) {
                    file.deleteOnExit();
                }
                InputStream resource = (loader != null ? loader : this.getClass().getClassLoader()).getResourceAsStream(uri.getSchemeSpecificPart());
                out = new FileOutputStream(file);
                if (resource == null) {
                    throw new DownloadException(RESOURCE_SCHEME_PREFIX + uri + "not found");
                }
                StreamUtils.transferData(resource, out);
                this.cache.put(uri.toString(), file);
                File file2 = file;
                return file2;
            }
            catch (IOException ex) {
                throw new DownloadException("I/O error has occures", ex);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ignord) {}
                }
            }
        }
        if (uri.getScheme().startsWith("http")) {
            return new File(uri);
        }
        throw new DownloadException("unsupported sheme: " + uri.getScheme());
    }
}

