/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2000-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

/*
 * @(#)ClusterBroadcast.java	1.37 07/23/07
 */ 

package com.sun.messaging.jmq.jmsserver.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import java.util.Map;
import java.util.Hashtable;
import java.util.Set;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.io.SysMessageID;

/**
 * Hides access to the clustering interface.
 */
public interface ClusterBroadcast {

    /** MessageBus protocol version */
    public static final int VERSION_410 = 410;
    public static final int VERSION_400 = 400;
    public static final int VERSION_350 = 350;
    public static final int VERSION_300 = 300;
    public static final int VERSION_210 = 210;

    public static final int MSG_DELIVERED = 0;
    public static final int MSG_ACKNOWLEDGED = 1;
    public static final int MSG_TXN_ACKNOWLEDGED_RN = 2;
    public static final int MSG_PREPARE_RN = 3;
    public static final int MSG_ROLLEDBACK_RN = 4;
    public static final int MSG_IGNORED = 5;
    public static final int MSG_UNDELIVERABLE = 6;
    public static final int MSG_DEAD = 7;
    public static final int MSG_PREPARE = 8;
    public static final int MSG_ROLLEDBACK = 9;

    public static final String RB_RELEASE_MSG_INACTIVE = "RB_RELEASE_MSG_INACTIVE";
    public static final String RC_RELEASE_MSG_INACTIVE = "RC_RELEASE_MSG_INACTIVE";
    public static final String RB_RELEASE_MSG_ORPHAN = "RB_RELEASE_MSG_ORPHAN";
    public static final String MSG_NOT_SENT_TO_REMOTE = "MSG_NOT_SENT_TO_REMOTE";
    public static final String MSG_REMOTE_REJECTED = "MSG_REMOTE_REJECTED";
    public static final String MSG_OUT_TIME_MILLIS = "MSG_OUT_TIME_MILLIS";

    public Protocol getProtocol();

    public boolean waitForConfigSync();
    public void setMatchProps(Properties match);

    /**
     * Get runtime cluster version
     */
    public int getClusterVersion() throws BrokerException;

    public void startClusterIO();

    public void stopClusterIO(boolean requestTakeover);

    public void pauseMessageFlow() throws IOException;

    public void resumeMessageFlow() throws IOException;

    public void messageDelivered(SysMessageID id, ConsumerUID uid,
                BrokerAddress ba);

    public void forwardMessage(PacketReference ref, Collection consumers);

    /**
     * Returns the address of this broker.
     * @return <code> BrokerAddress </code> object representing this
     * broker.
     */
    public BrokerAddress getMyAddress();

    public boolean lockSharedResource(String resource, Object owner);

    public boolean lockDestination(DestinationUID uid, Object owner);

    public void unlockDestination(DestinationUID uid, Object owner);

    public boolean lockClientID(String clientid, Object owner, boolean shared);

    public void unlockClientID(String clientid, Object owner);

    public boolean getConsumerLock(ConsumerUID uid,
                    DestinationUID duid, int position,
                    int maxActive, Object owner)
            throws BrokerException;

    public void unlockConsumer(ConsumerUID uid, DestinationUID duid, int position);
    
    public void acknowledgeMessage(BrokerAddress address,
                SysMessageID sysid, ConsumerUID cuid, int ackType, 
                Map optionalProps, boolean ackack) throws BrokerException;

    public void acknowledgeMessage2P(BrokerAddress address,
                SysMessageID[] sysids, ConsumerUID[] cuids, int ackType,
                Map optionalProps, Long txnID, boolean ackack, boolean async) 
                throws BrokerException;

    public void recordUpdateDestination(Destination d)
        throws BrokerException;

    public void recordRemoveDestination(Destination d)
        throws BrokerException;

    public void createDestination(Destination dest)
            throws BrokerException;

    public void recordCreateSubscription(Subscription sub)
        throws BrokerException;

    public void recordUnsubscribe(Subscription sub)
        throws BrokerException;

    public void createSubscription(Subscription sub, Consumer cons)
            throws BrokerException;

    public void createConsumer(Consumer con)
            throws BrokerException;

    public void updateDestination(Destination dest)
            throws BrokerException;

    public void updateSubscription(Subscription sub)
            throws BrokerException;

    public void updateConsumer(Consumer con)
            throws BrokerException;


    public void destroyDestination(Destination dest)
            throws BrokerException;

    public void destroyConsumer(Consumer con, Map pendingMsgs, boolean cleanup)
            throws BrokerException;

    public void connectionClosed(ConnectionUID uid, boolean admin);

    public void reloadCluster();

    public Hashtable getAllDebugState();

    /**
     * Ensures that the given "prefix" number is unique in the
     * cluster. This method is used to ensure the uniqueness of the
     * UIDs generated by a broker.
     *
     * @return true if the number is unique. false if some other
     * broker is using this number as a UID prefix.
     */
    public boolean lockUIDPrefix(short p);

    public void preTakeover(String brokerID, UID storeSession, 
                String brokerHost, UID brokerSession) throws BrokerException ;
	public void postTakeover(String brokerID, UID storeSession, boolean aborted);

	public void sendClusterTransactionInfo(long tid, BrokerAddress to);

    /**
     * Lookup the broker address for a broker ID - only for HA mode
     */
	public BrokerAddress lookupBrokerAddress(String brokerid);

   /**
     * This method can only be called if this broker is the current
     * master broker else it throws BrokerException.
     *
     * If this method throws BrokerException with status codes
     * Status.BAD_REQUEST, NOT_ALLOWED, UNAVAILABLE, PRECONDITION_FAILED,
     * then the failure didn't affect current master broker configuration;
     *
     * If this method throws BrokerException with any error status code 
     * other than the ones listed above,
     *
     * 1. It is possible the old master broker has switched to
     *    the new master but the new master broker has not switched
     *    itself, for example, IO failure while storing new master
     *    configuration, network problem between the new and old
     *    master broker at the last stage of the protocol;
     * 2. It is ensured that the new master broker has up to date 
     *    change records of the cluster;
     * 3. After the failure, while the old or new master broker
     *    continues running, it is ensured no cluster change record
     *    operation will succeed on the old master.
     * 4. The proper action to take is to shutdown the cluster or
     *    all brokers in the cluster and restart with master broker
     *    configuration using the new master broker
     *
     * When this method returns successfully, it is possible a
     * non-master broker that the change of master broker
     * notification had sent to has not switched to the new
     * master broker due to wait timeout. 
     *
     * Once this method returns successfully, it is ensured that
     * no cluster change record operation will succeed on the old
     * master broker.
     */
    public void changeMasterBroker(BrokerMQAddress newmaster, BrokerMQAddress oldmaster)
    throws BrokerException;
}

