/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sun.messaging.jmq.jmsserver.Globals;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;

public final class BrokerHostPortFile {
    public static final int FILE_MAGIC_NUMBER = -1145193509;
    private static final String HOSTPORT_FILENAME = "hostport";
    private RandomAccessFile raf = null;
    private boolean uselock = true;
    private FileLock lock = null;

    public BrokerHostPortFile(File envtop, boolean readonly, boolean uselock) throws Exception {
        File f = new File(envtop, HOSTPORT_FILENAME);
        if (readonly) {
            this.raf = new RandomAccessFile(f, "r");
            if (uselock) {
                this.lock = this.raf.getChannel().tryLock(0L, Long.MAX_VALUE, true);
            }
        } else {
            this.raf = new RandomAccessFile(f, "rwd");
            if (uselock) {
                this.lock = this.raf.getChannel().tryLock();
            }
        }
        if (uselock && this.lock == null) {
            throw new IOException("Unable to obtain file hostport lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHostPort(String hostport) throws Exception {
        if (this.raf == null || this.uselock && this.lock == null) {
            throw new IllegalStateException("Not initialized");
        }
        try {
            byte[] data = hostport.getBytes("UTF8");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeInt(-1145193509);
            dos.writeInt(data.length);
            dos.write(data, 0, data.length);
            dos.writeInt(-1145193509);
            dos.flush();
            bos.flush();
            byte[] bytes = bos.toByteArray();
            dos.close();
            this.raf.seek(0L);
            this.raf.write(bytes);
            this.raf.getChannel().force(false);
        }
        finally {
            if (this.uselock) {
                try {
                    this.lock.release();
                }
                catch (Exception e) {
                    Globals.getLogger().log(16, "Unable to release file hostport lock: " + e.getMessage());
                }
            }
            try {
                this.raf.close();
            }
            catch (Exception e) {
                Globals.getLogger().log(16, "Exception in closing file hostport: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readHostPort() throws Exception {
        if (this.raf == null || this.uselock && this.lock == null) {
            throw new IllegalStateException("Not initialized");
        }
        try {
            this.raf.seek(0L);
            int magic = this.raf.readInt();
            if (magic != -1145193509) {
                throw new IOException("First magic number read: " + magic + ", expected: " + -1145193509);
            }
            int len = this.raf.readInt();
            byte[] data = new byte[len];
            int count = 0;
            int off = 0;
            for (int totalread = 0; totalread < len; totalread += count) {
                count = this.raf.read(data, off + totalread, len - totalread);
                if (count >= 0) continue;
                throw new EOFException("Trying to read " + (len - totalread) + " bytes. Already read " + totalread + " bytes.");
            }
            magic = this.raf.readInt();
            if (magic != -1145193509) {
                throw new IOException("Second magic number read: " + magic + ", expected: " + -1145193509);
            }
            String string = new String(data, "UTF8");
            return string;
        }
        finally {
            if (this.uselock) {
                try {
                    this.lock.release();
                }
                catch (Exception e) {
                    Globals.getLogger().log(16, "Unable to release file hostport lock: " + e.getMessage());
                }
            }
            try {
                this.raf.close();
            }
            catch (Exception e) {
                Globals.getLogger().log(16, "Exception in closing file hostport: " + e.getMessage());
            }
        }
    }
}

