/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.coherence;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.coherence.CoherenceStore;
import com.sun.messaging.jmq.jmsserver.persist.coherence.ConfigRecordObject;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

class ConfigRecordStore {
    Logger logger = Globals.getLogger();
    private static final String SEQUENCER_KEY = "sequencer";
    private NamedCache sequencer = null;
    private NamedCache crcache = null;

    ConfigRecordStore(CoherenceStore s) {
        this.sequencer = CacheFactory.getCache((String)(s.getCacheNamePrefix() + "changerecordseq"));
        this.crcache = CacheFactory.getCache((String)(s.getCacheNamePrefix() + "changerecord"));
    }

    private Long getNextSequence() {
        return (Long)this.sequencer.invoke((Object)SEQUENCER_KEY, (InvocableMap.EntryProcessor)new SequencerProcessor());
    }

    protected void storeConfigChangeRecord(long timestamp, byte[] recordData, boolean sync) throws BrokerException {
        this.crcache.put((Object)this.getNextSequence(), (Object)new ConfigRecordObject(timestamp, recordData));
    }

    protected ArrayList<ChangeRecordInfo> getConfigChangeRecordsSince(long timestamp) {
        ArrayList<ChangeRecordInfo> records = new ArrayList<ChangeRecordInfo>();
        ConfigRecordObject cri = null;
        ArrayList cris = new ArrayList(this.crcache.values());
        Collections.sort(cris);
        Iterator itr = cris.iterator();
        while (itr.hasNext() && (cri = (ConfigRecordObject)itr.next()).getTimestamp() <= timestamp) {
            records.add(new ChangeRecordInfo(cri.getData(), cri.getTimestamp()));
        }
        return records;
    }

    protected List<ChangeRecordInfo> getAllConfigRecords() throws BrokerException {
        ArrayList<ChangeRecordInfo> records = new ArrayList<ChangeRecordInfo>();
        ConfigRecordObject cri2 = null;
        ArrayList cris = new ArrayList(this.crcache.values());
        Collections.sort(cris);
        for (ConfigRecordObject cri2 : cris) {
            records.add(new ChangeRecordInfo(cri2.getData(), cri2.getTimestamp()));
        }
        return records;
    }

    protected void clearAll() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(8, "ConfigRecordStore.clearAll()");
        }
        try {
            this.sequencer.destroy();
        }
        catch (Throwable t) {
            this.logger.logStack(16, "Destroy change record sequencer cache " + this.sequencer + " failed", t);
        }
        try {
            this.crcache.destroy();
        }
        catch (Throwable t) {
            this.logger.logStack(16, "Destroy change record cache " + this.crcache + " failed", t);
        }
    }

    protected void close(boolean cleanup) {
        if (Store.getDEBUG()) {
            this.logger.log(8, "ConfigRecordStore.close(" + cleanup + ")" + this.crcache.size() + " change records [" + this.sequencer.get((Object)SEQUENCER_KEY) + "]");
        }
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("ConfigRecordStore", String.valueOf(this.crcache.size()) + "[" + this.sequencer.get((Object)SEQUENCER_KEY) + "]");
        return t;
    }

    private static class SequencerProcessor
    extends AbstractProcessor {
        public Object process(InvocableMap.Entry entry) {
            Long seq = null;
            seq = !entry.isPresent() ? Long.valueOf(0L) : Long.valueOf((Long)entry.getValue() + 1L);
            entry.setValue((Object)seq);
            return seq;
        }
    }
}

