/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;

class InterestStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private ConcurrentHashMap interestMap = new ConcurrentHashMap(256);

    InterestStore() {
    }

    Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("Consumers", String.valueOf(this.interestMap.size()));
        return t;
    }

    public void printInfo(PrintStream out) {
        out.println("\nInterests");
        out.println("---------");
        out.println("number of interests:   " + this.interestMap.size());
    }

    void storeInterest(Consumer interest) throws IOException, BrokerException {
        ConsumerUID id = interest.getConsumerUID();
        try {
            Consumer oldValue = this.interestMap.putIfAbsent(id, interest);
            if (oldValue != null) {
                this.logger.log(32, "B3010", (Object)id, interest.getDestinationUID().getLongString());
                throw new BrokerException(this.br.getString("B3010", id, interest.getDestinationUID().getLongString()));
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4012", (Object)id, (Throwable)e);
            throw e;
        }
    }

    void removeInterest(Consumer interest) throws IOException, BrokerException {
        Object oldinterest = null;
        ConsumerUID id = interest.getConsumerUID();
        try {
            oldinterest = this.interestMap.remove(id);
            if (oldinterest == null) {
                this.logger.log(32, "B3011", (Object)id, interest.getDestinationUID().getLongString());
                throw new BrokerException(this.br.getString("B3011", id, interest.getDestinationUID().getLongString()));
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4034", id);
            throw new BrokerException(this.br.getString("B4034", id), e);
        }
    }

    Consumer[] getAllInterests() throws IOException {
        return this.interestMap.values().toArray(new Consumer[0]);
    }

    void clearAll() {
        if (Store.getDEBUG()) {
            this.logger.log(1, "InterestStore.clearAll() called");
        }
        this.interestMap.clear();
    }

    void close(boolean cleanup) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "InterestStore: closing, " + this.interestMap.size() + " in-memory interests");
        }
        this.interestMap.clear();
    }
}

