/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.audit.impl;

import com.sun.audit.AuditEvent_network_modify;
import com.sun.audit.AuditSession;
import com.sun.messaging.jmq.jmsserver.audit.api.MQAuditService;
import com.sun.messaging.jmq.jmsserver.audit.impl.MQAuditSessionImpl;
import java.util.HashMap;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="bsm")
@PerLookup
public class BSMAuditSession
extends MQAuditSessionImpl {
    private static final String LIBRARY = "imqutil";
    private static boolean useNative = false;
    private static final int ADT_NO_ATTRIB = -1;
    private AuditSession auditSession = null;
    private int[] unknownids = new int[]{-1, -1};
    private int[] brokerids = this.unknownids;
    HashMap idTable = new HashMap();

    private static native int[] nativeGetUidGid(String var0);

    private static native int[] nativeBrokerUidGid();

    public BSMAuditSession() {
        if (MQAuditService.isBSMAudit()) {
            try {
                this.auditSession = new AuditSession(null);
                this.auditOn = this.auditSession.auditOn();
            }
            catch (Throwable t) {
                this.logger.log(16, "Failed to get BSM AuditSession; BSM auditing will not be available", t);
            }
            this.logger.log(4, "created auditSession= " + this.auditSession);
            if (this.auditOn && useNative) {
                try {
                    int[] nids = BSMAuditSession.nativeBrokerUidGid();
                    if (nids != null && nids.length == 2) {
                        this.brokerids = nids;
                    }
                    this.logger.log(4, "Broker uid=" + this.brokerids[0] + ";gid=" + this.brokerids[1]);
                }
                catch (Throwable t) {
                    this.logger.log(4, "Failed to get uid/gid of user running the broker", t);
                }
            }
        }
        this.logger.log(4, this + ":auditOn=" + this.auditOn);
    }

    @Override
    public void authentication(String user, String host, boolean success) {
        if (!this.auditOn) {
            return;
        }
        try {
            int status = success ? 0 : -1;
            this.setUser(user, host, true);
            AuditEvent_network_modify event = new AuditEvent_network_modify(this.auditSession);
            event.domain("MQ action=authentication;MQ user=" + user + ";" + "host=" + host);
            event.object_name("MQ instance=" + this.instance);
            event.putEvent(status, 0);
            this.logger.log(4, "BSM putEvent for authentication");
        }
        catch (Throwable t) {
            this.logger.log(16, "BSM putEvent failed for authentication", t);
        }
    }

    @Override
    public void brokerOperation(String user, String host, String op) {
        if (!this.auditOn) {
            return;
        }
        try {
            if (user == null) {
                this.setUser(this.brokerids, this.brokerHost);
            } else {
                this.setUser(user, host, false);
            }
            AuditEvent_network_modify event = new AuditEvent_network_modify(this.auditSession);
            event.domain("MQ action=" + op + ";" + "MQ user=" + user + ";" + "host=" + (host == null ? this.brokerHost : host));
            event.object_name("MQ instance=" + this.instance);
            event.putEvent(0, 0);
            this.logger.log(4, "BSM putEvent for " + op);
        }
        catch (Throwable t) {
            this.logger.log(16, "BSM putEvent failed for " + op, t);
        }
    }

    @Override
    public void connectionAuth(String user, String host, String type, String name, boolean success) {
        if (!this.auditOn) {
            return;
        }
        try {
            this.setUser(user, host, false);
            AuditEvent_network_modify event = new AuditEvent_network_modify(this.auditSession);
            event.domain("MQ action=authorization;MQ user=" + user + ";" + "host=" + host);
            event.object_name("MQ instance=" + this.instance);
            event.auth_used("type=" + type + ";" + "name=" + name);
            int status = success ? 0 : -1;
            event.putEvent(status, 0);
            this.logger.log(4, "BSM putEvent for connection authorization");
        }
        catch (Throwable t) {
            this.logger.log(16, "BSM putEvent failed for connection authorization", t);
        }
    }

    @Override
    public void destinationAuth(String user, String host, String type, String name, String op, boolean success) {
        if (!this.auditOn) {
            return;
        }
        try {
            this.setUser(user, host, false);
            AuditEvent_network_modify event = new AuditEvent_network_modify(this.auditSession);
            event.domain("MQ action=authorization;MQ user=" + user + ";" + "host=" + host);
            event.object_name("MQ instance=" + this.instance);
            event.auth_used("type=" + type + ";" + "name=" + name + ";" + "operation=" + op);
            int status = success ? 0 : -1;
            event.putEvent(status, 0);
            this.logger.log(4, "BSM putEvent for destination authorization");
        }
        catch (Throwable t) {
            this.logger.log(16, "BSM putEvent failed for destination authorization", t);
        }
    }

    @Override
    public void storeOperation(String user, String host, String op) {
        if (!this.auditOn) {
            return;
        }
        try {
            if (user == null) {
                this.setUser(this.brokerids, this.brokerHost);
            } else {
                this.setUser(user, host, false);
            }
            AuditEvent_network_modify event = new AuditEvent_network_modify(this.auditSession);
            event.domain("MQ action=" + op + ";" + "MQ user=" + user + ";" + "host=" + (host == null ? this.brokerHost : host));
            event.object_name("MQ instance=" + this.instance);
            event.putEvent(0, 0);
            this.logger.log(4, "BSM putEvent for " + op);
        }
        catch (Throwable t) {
            this.logger.log(16, "BSM putEvent failed for " + op, t);
        }
    }

    @Override
    public void destinationOperation(String user, String host, String op, String type, String name) {
        if (!this.auditOn) {
            return;
        }
        try {
            this.setUser(user, host, false);
            AuditEvent_network_modify event = new AuditEvent_network_modify(this.auditSession);
            event.domain("MQ action=" + op + ";" + "MQ user=" + user + ";" + "host=" + host);
            event.object_name("MQ instance=" + this.instance);
            event.changed_values("type=" + type + ";" + "name=" + name);
            event.putEvent(0, 0);
            this.logger.log(4, "BSM putEvent for " + op);
        }
        catch (Throwable t) {
            this.logger.log(16, "BSM putEvent failed for " + op, t);
        }
    }

    @Override
    public void durableSubscriberOperation(String user, String host, String op, String name, String clientID) {
        if (!this.auditOn) {
            return;
        }
        try {
            this.setUser(user, host, false);
            AuditEvent_network_modify event = new AuditEvent_network_modify(this.auditSession);
            event.domain("MQ action=" + op + ";" + "MQ user=" + user + ";" + "host=" + host);
            event.object_name("MQ instance=" + this.instance);
            event.changed_values("name=" + name + ";" + "clientID=" + clientID);
            event.putEvent(0, 0);
            this.logger.log(4, "BSM putEvent for " + op);
        }
        catch (Throwable t) {
            this.logger.log(16, "BSM putEvent failed for " + op, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUser(String user, String host, boolean doLookup) {
        int[] ids = this.unknownids;
        if (useNative) {
            HashMap hashMap = this.idTable;
            synchronized (hashMap) {
                ids = (int[])this.idTable.get(user);
                try {
                    if (doLookup || ids == null) {
                        int[] nids;
                        ids = user != null && user.length() > 0 ? ((nids = BSMAuditSession.nativeGetUidGid(user)) != null && nids.length == 2 ? nids : this.unknownids) : this.unknownids;
                        this.idTable.put(user, ids);
                    }
                }
                catch (Throwable t) {
                    this.logger.log(4, "Failed to get uid/gid", t);
                }
            }
        }
        this.setUser(ids, host);
    }

    private void setUser(int[] ids, String host) {
        if (this.auditSession == null) {
            return;
        }
        if (host == null) {
            host = this.brokerHost;
        } else if ("127.0.0.1".equals(host)) {
            host = "localhost";
        }
        try {
            if (ids[0] == -1) {
                ids[0] = 0;
            }
            if (ids[1] == -1) {
                ids[1] = 0;
            }
            this.auditSession.setUser(ids[0], ids[1], ids[0], ids[1], host, 0);
        }
        catch (Throwable t) {
            this.logger.log(16, "Failed to set user in BSM AuditSession", t);
        }
    }

    static {
        if (MQAuditService.isBSMAudit()) {
            try {
                System.loadLibrary(LIBRARY);
                useNative = true;
            }
            catch (Throwable ex) {
                useNative = false;
                ex.printStackTrace();
            }
        }
    }
}

