/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.cluster.api.RemoteTransactionAckEntry;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import java.util.ArrayList;
import java.util.Hashtable;

class RemoteTransactionInformation
extends TransactionInformation {
    RemoteTransactionAckEntry txnAckEntry = null;
    ArrayList recoveryTxnAckEntrys = new ArrayList();
    TransactionBroker txnhome = null;
    long pendingStartTime = 0L;

    public RemoteTransactionInformation(TransactionUID tid, TransactionState state, TransactionAcknowledgement[] acks, BrokerAddress txnhome, boolean recovery, boolean localremote, boolean persist) {
        super(tid, state, persist);
        this.type = 3;
        this.txnhome = new TransactionBroker(txnhome, true);
        if (recovery) {
            this.addRecoveryTransactionAcks(acks);
        } else {
            this.txnAckEntry = new RemoteTransactionAckEntry(acks, localremote);
        }
    }

    public void pendingStarted() {
        this.pendingStartTime = System.currentTimeMillis();
    }

    public boolean isPendingTimeout(long timeout) {
        return System.currentTimeMillis() - this.pendingStartTime >= timeout;
    }

    @Override
    public synchronized String toString() {
        return "RemoteTransactionInfo[" + this.tid + "]remote - " + this.txnhome.toString();
    }

    public synchronized TransactionBroker getTransactionHomeBroker() {
        return this.txnhome;
    }

    public synchronized RemoteTransactionAckEntry getTransactionAcks() {
        return this.txnAckEntry;
    }

    public synchronized RemoteTransactionAckEntry[] getRecoveryTransactionAcks() {
        if (this.recoveryTxnAckEntrys.size() == 0) {
            return null;
        }
        return this.recoveryTxnAckEntrys.toArray(new RemoteTransactionAckEntry[this.recoveryTxnAckEntrys.size()]);
    }

    public synchronized void addRecoveryTransactionAcks(TransactionAcknowledgement[] acks) {
        if (this.getState().getState() == 5) {
            this.recoveryTxnAckEntrys.add(new RemoteTransactionAckEntry(acks, true, false));
        } else {
            this.recoveryTxnAckEntrys.add(new RemoteTransactionAckEntry(acks, true, true));
        }
    }

    public synchronized int getNRemoteConsumedMessages() {
        int n = 0;
        if (this.txnAckEntry != null) {
            n += this.txnAckEntry.getAcks().length;
        }
        RemoteTransactionAckEntry tae2 = null;
        for (RemoteTransactionAckEntry tae2 : this.recoveryTxnAckEntrys) {
            n += tae2.getAcks().length;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProcessed() {
        if (this.txnAckEntry != null && !this.txnAckEntry.isProcessed()) {
            return false;
        }
        RemoteTransactionInformation remoteTransactionInformation = this;
        synchronized (remoteTransactionInformation) {
            RemoteTransactionAckEntry tae2 = null;
            for (RemoteTransactionAckEntry tae2 : this.recoveryTxnAckEntrys) {
                if (tae2.isProcessed()) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized boolean isRecovery() {
        return this.recoveryTxnAckEntrys.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        RemoteTransactionInformation remoteTransactionInformation = this;
        synchronized (remoteTransactionInformation) {
            ht.put("state", this.getState().getDebugState());
            if (this.txnhome != null) {
                ht.put("txnhome", this.txnhome.toString());
            }
            if (this.txnAckEntry != null) {
                ht.put("txnAckEntry", this.txnAckEntry.getDebugState());
            }
            if (this.recoveryTxnAckEntrys != null) {
                ArrayList<Hashtable> l = new ArrayList<Hashtable>();
                int len = this.recoveryTxnAckEntrys.size();
                for (int i = 0; i < len; ++i) {
                    l.add(((RemoteTransactionAckEntry)this.recoveryTxnAckEntrys.get(i)).getDebugState());
                }
                ht.put("recoveryTxnAckEntrys", l);
            }
        }
        return ht;
    }
}

