/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.ClusterImpl;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.net.MQServerSocketFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import javax.net.ServerSocketFactory;

class ClusterServiceListener
extends Thread {
    private static final BrokerResources br = Globals.getBrokerResources();
    private static final Logger logger = Globals.getLogger();
    ClusterImpl callback = null;
    boolean done = false;
    ServerSocket ss = null;
    private boolean nodelay;
    private boolean isSSL = false;
    private static ServerSocketFactory ssf = MQServerSocketFactory.getDefault();

    public ClusterServiceListener(ClusterImpl callback) throws IOException {
        this.callback = callback;
        this.setName("ClusterServiceListener");
        this.setDaemon(true);
        this.nodelay = callback.getTCPNodelay();
        if (callback.getTransport().equalsIgnoreCase("ssl")) {
            this.nodelay = callback.getSSLNodelay();
            this.isSSL = true;
            this.initSSLListener();
        } else {
            this.initTCPListener();
        }
        this.start();
    }

    private void initSSLListener() throws IOException {
        if (ClusterImpl.DEBUG) {
            logger.log(8, "ClusterImpl.initSSLListener[nodelay=" + this.nodelay + ", inbufsz=" + this.callback.getSSLInputBufferSize() + ", outbufsz=" + this.callback.getSSLOutputBufferSize() + "]");
        }
        ServerSocketFactory sslfactory = null;
        try {
            LicenseBase license = Globals.getCurrentLicense(null);
            if (!license.getBooleanProperty("imq.enable_ssl", false)) {
                logger.log(32, "B3123", br.getString("B0073"));
                throw new BrokerException(br.getKString("B3123", br.getString("B0073")));
            }
            Class<?> TLSProtocolClass = Class.forName("com.sun.messaging.jmq.jmsserver.net.tls.TLSProtocol");
            if (ClusterImpl.DEBUG) {
                logger.log(4, "ClusterImpl.initSSLListener. Initializing SSLServerSocketFactory");
            }
            Method m = TLSProtocolClass.getMethod("getServerSocketFactory", null);
            sslfactory = (ServerSocketFactory)m.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof InvocationTargetException) {
                t = e.getCause();
                if (t == null) {
                    t = e;
                }
                if (ClusterImpl.DEBUG && t != e) {
                    logger.logStack(32, e.getMessage(), e);
                }
            }
            logger.logStack(32, t.getMessage(), t);
            throw new IOException(t.getMessage());
        }
        InetAddress listenHost = this.callback.getListenHost();
        int listenPort = this.callback.getListenPort();
        HashMap<String, String> h = null;
        if (ClusterImpl.DEBUG) {
            logger.log(4, "ClusterImpl.initSSLListener. Initializing ServerSocket");
        }
        if (listenHost == null) {
            this.ss = sslfactory.createServerSocket(listenPort);
        } else {
            this.ss = sslfactory.createServerSocket(listenPort, 50, listenHost);
            h = new HashMap<String, String>();
            h.put("hostname", listenHost.getHostName());
            h.put("hostaddr", listenHost.getHostAddress());
        }
        Globals.getPortMapper().addService("cluster", "ssl", "CLUSTER", this.ss.getLocalPort(), h);
        if (ClusterImpl.DEBUG) {
            logger.log(8, "ClusterImpl.initSSLListener: " + this.ss + " " + MQServerSocketFactory.serverSocketToString(this.ss));
        }
    }

    private void initTCPListener() throws IOException {
        if (ClusterImpl.DEBUG) {
            logger.log(8, "ClusterImpl.initTCPListener[TcpNoDelay=" + this.nodelay + ", inbufsz=" + this.callback.getTCPInputBufferSize() + ", outbufsz=" + this.callback.getTCPOutputBufferSize() + "]");
        }
        InetAddress listenHost = this.callback.getListenHost();
        int listenPort = this.callback.getListenPort();
        HashMap<String, String> h = null;
        if (listenHost == null) {
            this.ss = ssf.createServerSocket(listenPort);
        } else {
            this.ss = ssf.createServerSocket(listenPort, 50, listenHost);
            h = new HashMap<String, String>();
            h.put("hostname", listenHost.getHostName());
            h.put("hostaddr", listenHost.getHostAddress());
        }
        Globals.getPortMapper().addService("cluster", "tcp", "CLUSTER", this.ss.getLocalPort(), h);
        if (ClusterImpl.DEBUG) {
            logger.log(4, "ClusterImpl.initTCPListener: " + this.ss + " " + MQServerSocketFactory.serverSocketToString(this.ss));
        }
    }

    public String getServerSocketString() {
        ServerSocket ssocket = this.ss;
        if (ssocket != null) {
            return ssocket.getInetAddress() + ":" + ssocket.getLocalPort();
        }
        return null;
    }

    public synchronized void shutdown() {
        this.done = true;
        try {
            this.ss.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            ClusterServiceListener clusterServiceListener = this;
            synchronized (clusterServiceListener) {
                if (this.done) {
                    break;
                }
            }
            try {
                Socket sock = this.ss.accept();
                try {
                    sock.setTcpNoDelay(this.nodelay);
                }
                catch (SocketException e) {
                    logger.log(16, this.getClass().getSimpleName() + ".run(): [" + sock.toString() + "]setTcpNoDelay(" + this.nodelay + "): " + e.toString(), e);
                }
                this.callback.acceptConnection(sock, this.isSSL);
            }
            catch (Exception exception) {}
        }
    }
}

