/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class Packet {
    private static final short VERSION = 100;
    private static final int HEADER_SIZE = 16;
    public static final int UNICAST = 1;
    public static final int BROADCAST = 2;
    public static final int BROKER_INFO = 3;
    public static final int LINK_INIT = 4;
    public static final int STOP_FLOW = 5;
    public static final int RESUME_FLOW = 6;
    public static final int PING = 7;
    public static final int BROKER_INFO_REPLY = 9;
    public static final int USE_FLOW_CONTROL = 1;
    private short version = (short)100;
    private short packetType = 0;
    private int packetSize = 0;
    private int destId = 0;
    private int bitFlags = 0;
    private byte[] packetBuffer = null;

    Packet() {
    }

    public void readPacket(InputStream is) throws IOException, EOFException {
        DataInputStream dis = new DataInputStream(is);
        this.version = dis.readShort();
        this.packetType = dis.readShort();
        this.packetSize = dis.readInt();
        this.destId = dis.readInt();
        this.bitFlags = dis.readInt();
        try {
            this.packetBuffer = new byte[this.packetSize - 16];
        }
        catch (OutOfMemoryError oom) {
            dis.skip(this.packetSize - 16);
            throw oom;
        }
        dis.readFully(this.packetBuffer);
    }

    public void writePacket(OutputStream os) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeShort(this.version);
        dos.writeShort(this.packetType);
        dos.writeInt(this.packetSize);
        dos.writeInt(this.destId);
        dos.writeInt(this.bitFlags);
        dos.flush();
        bos.flush();
        byte[] headerBuffer = bos.toByteArray();
        os.write(headerBuffer, 0, 16);
        if (this.packetBuffer != null) {
            os.write(this.packetBuffer, 0, this.packetSize - 16);
        }
        os.flush();
    }

    public int getPacketType() {
        return this.packetType;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public int getDestId() {
        return this.destId;
    }

    public byte[] getPacketBody() {
        return this.packetBuffer;
    }

    public boolean getFlag(int flag) {
        return (this.bitFlags & flag) == flag;
    }

    public void setPacketType(int packetType) {
        this.packetType = (short)packetType;
    }

    public void setDestId(int destId) {
        this.destId = destId;
    }

    public void setPacketBody(byte[] data) {
        this.packetBuffer = data;
        this.packetSize = 16;
        if (this.packetBuffer != null) {
            this.packetSize += this.packetBuffer.length;
        }
    }

    public void setFlag(int flag, boolean on) {
        this.bitFlags = on ? (this.bitFlags |= flag) : (this.bitFlags &= ~flag);
    }

    public String toString() {
        return "PacketType = " + this.packetType + ", DestId = " + this.destId + ", DATA :\n" + Packet.hexdump(this.packetBuffer, 128);
    }

    public static String hexdump(byte[] buffer, int maxlen) {
        if (buffer == null) {
            return "";
        }
        int addr = 0;
        int buflen = buffer.length;
        if (buflen > maxlen) {
            buflen = maxlen;
        }
        StringBuffer ret = new StringBuffer(buflen);
        while (buflen > 0) {
            int i;
            int count = buflen < 16 ? buflen : 16;
            ret.append("\n" + Packet.i2hex(addr, 6, "0"));
            StringBuffer tmp = new StringBuffer();
            for (i = 0; i < count; ++i) {
                byte b = buffer[addr + i];
                if (i == 8) {
                    ret.append("-");
                } else {
                    ret.append(" ");
                }
                ret.append(Packet.i2hex(b, 2, "0"));
                if (b >= 32 && b < 128) {
                    tmp.append((char)b);
                    continue;
                }
                tmp.append(".");
            }
            while (i < 16) {
                ret.append("   ");
                ++i;
            }
            ret.append("   " + tmp);
            addr += count;
            buflen -= count;
        }
        return ret.append("\n").toString();
    }

    public static String i2hex(int i, int len, String filler) {
        String str = Integer.toHexString(i);
        if (str.length() == len) {
            return str;
        }
        if (str.length() > len) {
            return str.substring(str.length() - len);
        }
        while (str.length() < len) {
            str = filler + str;
        }
        return str;
    }

    public static String getPacketTypeString(int type) {
        switch (type) {
            case 3: {
                return "BROKER_INFO";
            }
            case 4: {
                return "LINK_INIT";
            }
            case 5: {
                return "STOP_FLOW";
            }
            case 6: {
                return "RESUME_FLOW";
            }
            case 7: {
                return "PING";
            }
            case 9: {
                return "BROKER_INFO_REPLY";
            }
        }
        return "UNKNOWN";
    }
}

