/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms;

import com.sun.messaging.bridge.api.Bridge;
import com.sun.messaging.bridge.api.BridgeCmdSharedReplyData;
import com.sun.messaging.bridge.api.BridgeContext;
import com.sun.messaging.bridge.api.BridgeException;
import com.sun.messaging.bridge.api.JMSBridgeStore;
import com.sun.messaging.bridge.service.jms.AsyncStartListener;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.RejectedExecutionException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="JMS")
@PerLookup
public class BridgeImpl
implements Bridge,
AsyncStartListener {
    private final String _type = "JMS";
    private String _name = null;
    private Bridge.State _state = Bridge.State.STOPPED;
    private JMSBridge _jmsbridge = null;

    @Override
    public synchronized void asyncStartCompleted() throws Exception {
        if (this._state == Bridge.State.STARTING) {
            this._state = Bridge.State.STARTED;
            return;
        }
        throw new IllegalStateException("Received bridge async start completion notification on unexpected state " + this._state.toString(JMSBridge.getJMSBridgeResources()));
    }

    @Override
    public synchronized void asyncStartFailed() throws Exception {
        if (this._state == Bridge.State.STARTING) {
            this._state = Bridge.State.STOPPED;
            return;
        }
        throw new IllegalStateException("Received bridge async start failure notification on unexpected state " + this._state.toString(JMSBridge.getJMSBridgeResources()));
    }

    @Override
    public synchronized boolean start(BridgeContext bc, String[] args) throws Exception {
        String linkName = this.parseLinkName(args);
        if (linkName != null) {
            if (this._state != Bridge.State.STARTED) {
                JMSBridgeResources jMSBridgeResources = JMSBridge.getJMSBridgeResources();
                JMSBridge.getJMSBridgeResources();
                throw new IllegalStateException(jMSBridgeResources.getKString("BSJ4000", Bridge.State.STARTED.toString(JMSBridge.getJMSBridgeResources())));
            }
            return this._jmsbridge.start(linkName, null);
        }
        if (this._state == Bridge.State.STARTED) {
            return true;
        }
        if (this._state == Bridge.State.STARTING) {
            return false;
        }
        Bridge.State oldstate = this._state;
        this._state = Bridge.State.STARTING;
        boolean inited = false;
        try {
            this._jmsbridge = new JMSBridge();
            this._jmsbridge.init(bc, this._name, this.parseResetArg(args));
            inited = true;
            try {
                if (this._jmsbridge.start(this.parseLinkName(args), this)) {
                    this._state = Bridge.State.STARTED;
                    return true;
                }
                return false;
            }
            catch (RejectedExecutionException e) {
                this._state = oldstate;
                throw e;
            }
        }
        catch (Exception e) {
            try {
                this.stop(bc, null);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (!inited) {
                this._jmsbridge = null;
                throw e;
            }
            throw new BridgeException(e.getMessage(), e, 201);
        }
    }

    @Override
    public synchronized void pause(BridgeContext bc, String[] args) throws Exception {
        String linkName = this.parseLinkName(args);
        if (linkName != null) {
            if (this._state != Bridge.State.STARTED) {
                JMSBridgeResources jMSBridgeResources = JMSBridge.getJMSBridgeResources();
                JMSBridge.getJMSBridgeResources();
                throw new IllegalStateException(jMSBridgeResources.getKString("BSJ4000", Bridge.State.STARTED.toString(JMSBridge.getJMSBridgeResources())));
            }
            this._jmsbridge.pause(linkName);
            return;
        }
        if (this._state == Bridge.State.PAUSED) {
            return;
        }
        if (this._state != Bridge.State.STARTED) {
            JMSBridgeResources jMSBridgeResources = JMSBridge.getJMSBridgeResources();
            JMSBridge.getJMSBridgeResources();
            throw new IllegalStateException(jMSBridgeResources.getKString("BSJ4001", this._state.toString(JMSBridge.getJMSBridgeResources())));
        }
        Bridge.State oldstate = this._state;
        this._state = Bridge.State.PAUSING;
        try {
            this._jmsbridge.pause(this.parseLinkName(args));
            this._state = Bridge.State.PAUSED;
        }
        catch (Exception e) {
            if (e instanceof RejectedExecutionException) {
                this._state = oldstate;
                throw e;
            }
            try {
                this._jmsbridge.stop(this.parseLinkName(args));
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public synchronized void resume(BridgeContext bc, String[] args) throws Exception {
        String linkName = this.parseLinkName(args);
        if (linkName != null) {
            if (this._state != Bridge.State.STARTED) {
                JMSBridgeResources jMSBridgeResources = JMSBridge.getJMSBridgeResources();
                JMSBridge.getJMSBridgeResources();
                throw new IllegalStateException(jMSBridgeResources.getKString("BSJ4000", Bridge.State.STARTED.toString(JMSBridge.getJMSBridgeResources())));
            }
            this._jmsbridge.resume(linkName);
            return;
        }
        if (this._state == Bridge.State.STARTED) {
            return;
        }
        if (this._state != Bridge.State.PAUSED) {
            JMSBridgeResources jMSBridgeResources = JMSBridge.getJMSBridgeResources();
            JMSBridge.getJMSBridgeResources();
            throw new IllegalStateException(jMSBridgeResources.getKString("BSJ4002", this._state.toString(JMSBridge.getJMSBridgeResources())));
        }
        Bridge.State oldstate = this._state;
        this._state = Bridge.State.RESUMING;
        try {
            this._jmsbridge.resume(this.parseLinkName(args));
        }
        catch (Exception e) {
            if (e instanceof RejectedExecutionException) {
                this._state = oldstate;
                throw e;
            }
            try {
                this._jmsbridge.stop(this.parseLinkName(args));
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw e;
        }
        this._state = Bridge.State.STARTED;
    }

    @Override
    public synchronized void stop(BridgeContext bc, String[] args) throws Exception {
        if (this._jmsbridge == null) {
            this._state = Bridge.State.STOPPED;
            JMSBridgeResources jMSBridgeResources = JMSBridge.getJMSBridgeResources();
            JMSBridge.getJMSBridgeResources();
            throw new IllegalStateException(jMSBridgeResources.getKString("BSJ4003", this.getName()));
        }
        String linkName = this.parseLinkName(args);
        if (linkName != null) {
            if (this._state != Bridge.State.STARTED) {
                JMSBridgeResources jMSBridgeResources = JMSBridge.getJMSBridgeResources();
                JMSBridge.getJMSBridgeResources();
                throw new IllegalStateException(jMSBridgeResources.getKString("BSJ4000", Bridge.State.STARTED.toString(JMSBridge.getJMSBridgeResources())));
            }
            this._jmsbridge.stop(linkName);
            return;
        }
        if (this._state == Bridge.State.STOPPED) {
            return;
        }
        Bridge.State oldstate = this._state;
        this._state = Bridge.State.STOPPING;
        try {
            this._jmsbridge.stop(this.parseLinkName(args));
            this._state = Bridge.State.STOPPED;
        }
        catch (RejectedExecutionException e) {
            this._state = oldstate;
            throw e;
        }
    }

    private synchronized JMSBridge getJMSBridge() {
        return this._jmsbridge;
    }

    @Override
    public ArrayList<BridgeCmdSharedReplyData> list(BridgeContext bc, String[] args, ResourceBundle rb) throws Exception {
        JMSBridge jb = this.getJMSBridge();
        if (jb == null) {
            JMSBridgeResources jMSBridgeResources = JMSBridge.getJMSBridgeResources();
            JMSBridge.getJMSBridgeResources();
            throw new IllegalStateException(jMSBridgeResources.getKString("BSJ4003", this.getName()));
        }
        ArrayList<BridgeCmdSharedReplyData> replys = new ArrayList<BridgeCmdSharedReplyData>();
        BridgeCmdSharedReplyData reply = new BridgeCmdSharedReplyData(4, 3, "-");
        Object[] oneRow = new String[]{rb.getString("BS1000"), rb.getString("BS1001"), rb.getString("BS1002"), rb.getString("BS1003")};
        reply.addTitle((String[])oneRow);
        oneRow[0] = this.getName();
        oneRow[1] = this.getType();
        oneRow[2] = this.getState().toString(rb);
        oneRow[3] = String.valueOf(jb.getNumLinks());
        reply.add(oneRow);
        replys.add(reply);
        String linkName = this.parseLinkName(args);
        boolean debugMode = this.parseDebugModeArg(args);
        ArrayList<BridgeCmdSharedReplyData> rep = jb.list(linkName, rb, debugMode);
        replys.addAll(rep);
        return replys;
    }

    @Override
    public String getType() {
        return "JMS";
    }

    @Override
    public boolean isMultipliable() {
        return true;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name + "[" + (Object)((Object)this.getState()) + "]";
    }

    @Override
    public synchronized Bridge.State getState() {
        return this._state;
    }

    @Override
    public Object getExportedService(Class c, Properties props) throws Exception {
        if (c == null) {
            throw new IllegalArgumentException("null class");
        }
        if (props == null) {
            throw new IllegalArgumentException("null props");
        }
        if (!c.getName().equals(JMSBridgeStore.class.getName())) {
            throw new IllegalArgumentException("Unexpected class " + c);
        }
        return JMSBridge.exportJMSBridgeStoreService(props);
    }

    private String parseLinkName(String[] args) {
        if (args == null) {
            return null;
        }
        for (int n = 0; n < args.length; ++n) {
            if (!args[n].equals("-ln")) continue;
            return args[++n];
        }
        return null;
    }

    private boolean parseResetArg(String[] args) {
        if (args == null) {
            return false;
        }
        for (int n = 0; n < args.length; ++n) {
            if (!args[n].equals("-reset")) continue;
            return true;
        }
        return false;
    }

    private boolean parseDebugModeArg(String[] args) {
        if (args == null) {
            return false;
        }
        for (int n = 0; n < args.length; ++n) {
            if (!args[n].equals("-debug")) continue;
            return true;
        }
        return false;
    }
}

