#!/bin/bash

SCRIPT_DIR=$(dirname $0)
ABS_SCRIPT_DIR=$(cd $SCRIPT_DIR && pwd)

# Set PATH
. ${ABS_SCRIPT_DIR}/setenv.sh

# run NSS IPS packages repository test
REPO_BASE_DIR=$1

if [ -z "$REPO_BASE_DIR" ] ;
then
	echo "usage:   $0 REPO_BASE_DIR"
	exit 1
fi

PKG_LIST="nss-libs nss-utils nss-dev"
PLATFORM_LIST="Windows SunOS_x86 SunOS_sparc Linux Darwin"

# Temporary directory to unzip packages
TMPDIR=/tmp/integrate_pkg$$

test_error () {
errno=$1
errmsg=$2

	if [ ! $errno == 0 ] ;
	then
		echo "Test failed: $errmsg (error $errno)"
		exit 1
	fi
} # function test_error

add_pkg_repo () {
repo_dir=$1
zip_file=$2

	if [ ! -f $zip_file ] ;
	then
		test_error 1 "No zip file $zip_file"
	fi
	
	if [ ! -d $repo_dir ] ;
	then
		test_error 1 "No repo directory $repo_dir"
	fi

	# The package name is everything before the version which starts with "-[0-9]"
	pkg=$(basename $zip_file | sed -e 's|[-,_][0-9].*||')
	echo "File $zip_file: package $pkg"
	
	if [ -d $TMPDIR ] ;
	then
			rm -rf $TMPDIR
	fi
	mkdir -p $TMPDIR
	test_error $? "mkdir -p $TMPDIR"

    # We need to prime the repository with the first package
    if [ ! -e $repo_dir/catalog/catalog ] ;
    then
        (cd $repo_dir && unzip -o $zip_file)
    else
		(cd $TMPDIR && unzip -o $zip_file)
		copypkgs.sh -s $TMPDIR -d $repo_dir $pkg
		test_error $? "copypkgs.sh -s $TMPDIR -d $repo_dir $pkg"
		rm -rf $TMPDIR
    fi
} # function add_pkg_repo

# Verify that we have pkg in the PATH
echo "Verifying the pkg-toolkit ==========="
which pkg
test_error $? "which pkg"

# Creating the Repo directories
if [ -d $REPO_BASE_DIR ] ;
then
	rm -rf $REPO_BASE_DIR
fi
mkdir $REPO_BASE_DIR
test_error $? "mkdir $REPO_BASE_DIR"

ABS_REPO_BASE_DIR=$(cd $REPO_BASE_DIR && pwd)

for plat in $PLATFORM_LIST
do
	mkdir ${ABS_REPO_BASE_DIR}/${plat}
	test_error $? "mkdir ${ABS_REPO_BASE_DIR}/${plat}"
done

# Copy the packages in the repo directories
for plat in $PLATFORM_LIST
do
	for pkg_zip in $(ls ${ABS_SCRIPT_DIR}/pkg/${plat}/*.zip ${ABS_SCRIPT_DIR}/pkg/common/*.zip)
	do
		add_pkg_repo ${ABS_REPO_BASE_DIR}/${plat} $pkg_zip
	done
done

kill_all_repo () {
	for pid in $repo_pid_list
	do
		kill $pid
	done

	trap - INT TERM EXIT

	exit 0
} # function kill_all_repo

# Start the repositories
repo_pid_list=""
repo_port=10021

trap 'kill_all_repo' INT TERM EXIT
for plat in $PLATFORM_LIST
do
	echo "Starting repor for $plat on port $repo_port ========="
	pkg.depotd -p $repo_port -d ${ABS_REPO_BASE_DIR}/${plat} --rebuild >${ABS_REPO_BASE_DIR}/${plat}.log 2>&1 &
	test_error $? "pkg.depotd -p $repo_port -d ${ABS_REPO_BASE_DIR}/${plat} --rebuild"
	echo "pid=$!"
	repo_pid_list="$repo_pid_list $!"
	repo_port=$(expr $repo_port + 1)
done

echo "Type ctrl-C to stop all the repositories"

# Wait
while(true)
do
	sleep 10
done
